/*
 * Decompiled with CFR 0.152.
 */
package com.blockout.views;

import com.blockout.Pane;
import com.blockout.PaneParams;
import com.blockout.View;
import com.blockout.controls.Scrollbar;
import com.blockout.views.ScrollingContainer;
import org.jetbrains.annotations.NotNull;

public class ScrollingView
extends View {
    private static final int DEFAULT_SCROLLBAR_WIDTH = 8;
    protected int scrollbarWidth = 8;
    protected ScrollingContainer container;
    protected Scrollbar scrollbar;

    public ScrollingView() {
        this.setup();
    }

    private void setup() {
        this.container = this.createScrollingContainer();
        this.container.setPosition(0, 0);
        this.container.setSize(this.getInteriorWidth() - this.scrollbarWidth, this.getInteriorHeight());
        this.container.putInside(this);
        this.scrollbar = new Scrollbar(this.container);
        this.scrollbar.setPosition(this.getInteriorWidth() - this.scrollbarWidth, 0);
        this.scrollbar.setSize(this.scrollbarWidth, this.getInteriorHeight());
        this.scrollbar.putInside(this);
    }

    @NotNull
    protected ScrollingContainer createScrollingContainer() {
        return new ScrollingContainer(this);
    }

    public ScrollingView(PaneParams params) {
        super(params);
        this.setup();
    }

    public ScrollingContainer getContainer() {
        return this.container;
    }

    @Override
    public void parseChildren(PaneParams params) {
        this.container.parseChildren(params);
    }

    @Override
    protected boolean childIsVisible(Pane child) {
        return true;
    }

    public int getScrollY() {
        return this.container.getScrollY();
    }

    public void setScrollY(int offset) {
        this.container.setScrollY(offset);
    }
}

