/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.client.gui;

import com.blockout.controls.Button;
import com.blockout.controls.Label;
import com.minecolonies.MineColonies;
import com.minecolonies.client.gui.AbstractWindowSkeleton;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.buildings.AbstractBuildingHut;
import com.minecolonies.network.messages.BuildRequestMessage;
import com.minecolonies.network.messages.OpenInventoryMessage;
import com.minecolonies.util.LanguageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class AbstractWindowBuilding<B extends AbstractBuildingHut.View>
extends AbstractWindowSkeleton {
    private static final String BUTTON_BUILD = "build";
    private static final String BUTTON_REPAIR = "repair";
    private static final String BUTTON_INVENTORY = "inventory";
    private static final String LABEL_BUILDING_NAME = "name";
    protected final B building;

    public AbstractWindowBuilding(B building, String resource) {
        super(resource);
        this.building = building;
        this.registerButton(BUTTON_BUILD, this::buildClicked);
        this.registerButton(BUTTON_REPAIR, this::repairClicked);
        this.registerButton(BUTTON_INVENTORY, this::inventoryClicked);
    }

    private void buildClicked(Button ignored) {
        MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((AbstractBuilding.View)this.building, 0));
    }

    private void repairClicked(Button ignored) {
        MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage((AbstractBuilding.View)this.building, 1));
    }

    private void inventoryClicked(Button ignored) {
        MineColonies.getNetwork().sendToServer((IMessage)new OpenInventoryMessage((AbstractBuilding.View)this.building));
    }

    @Override
    public void onOpened() {
        this.findPaneOfTypeByID(LABEL_BUILDING_NAME, Label.class).setLabelText(LanguageHandler.getString(this.getBuildingName()));
        if (((AbstractBuilding.View)this.building).getBuildingLevel() == 0) {
            this.findPaneOfTypeByID(BUTTON_BUILD, Button.class).setLabel(LanguageHandler.getString("com.minecolonies.gui.workerHuts.build"));
            this.findPaneByID(BUTTON_REPAIR).disable();
        } else if (((AbstractBuilding.View)this.building).isBuildingMaxLevel()) {
            Button button = this.findPaneOfTypeByID(BUTTON_BUILD, Button.class);
            button.setLabel(LanguageHandler.getString("com.minecolonies.gui.workerHuts.upgradeUnavailable"));
            button.disable();
        }
    }

    public abstract String getBuildingName();
}

