/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.client.gui;

import com.blockout.controls.Button;
import com.blockout.controls.Label;
import com.minecolonies.MineColonies;
import com.minecolonies.client.gui.AbstractWindowBuilding;
import com.minecolonies.client.gui.WindowHireWorker;
import com.minecolonies.colony.CitizenDataView;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.network.messages.HireFireMessage;
import com.minecolonies.network.messages.RecallCitizenMessage;
import com.minecolonies.util.LanguageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowWorkerBuilding<B extends AbstractBuildingWorker.View>
extends AbstractWindowBuilding<B> {
    private static final String BUTTON_HIRE = "hire";
    private static final String BUTTON_RECALL = "recall";
    private static final String LABEL_BUILDINGTYPE = "type";
    private static final String LABEL_WORKERNAME = "workerName";
    private static final String LABEL_WORKERLEVEL = "workerLevel";

    AbstractWindowWorkerBuilding(B building, String resource) {
        super(building, resource);
        super.registerButton(BUTTON_HIRE, this::hireClicked);
        super.registerButton(BUTTON_RECALL, this::recallClicked);
    }

    private void hireClicked(@NotNull Button button) {
        if (((AbstractBuildingWorker.View)this.building).getColony().isManualHiring()) {
            if (((AbstractBuildingWorker.View)this.building).getWorkerId() == 0) {
                WindowHireWorker window = new WindowHireWorker(((AbstractBuildingWorker.View)this.building).getColony(), ((AbstractBuildingWorker.View)this.building).getLocation());
                window.open();
            } else {
                MineColonies.getNetwork().sendToServer((IMessage)new HireFireMessage(this.building, false, 0));
                button.setLabel(LanguageHandler.format("com.minecolonies.gui.workerHuts.hire", new Object[0]));
                this.findPaneOfTypeByID(LABEL_WORKERNAME, Label.class).setLabelText("");
                this.findPaneOfTypeByID(LABEL_WORKERLEVEL, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.gui.workerHuts.workerLevel", ""));
                ((AbstractBuildingWorker.View)this.building).setWorkerId(0);
            }
        }
    }

    private void recallClicked(Button ignored) {
        MineColonies.getNetwork().sendToServer((IMessage)new RecallCitizenMessage((AbstractBuildingWorker.View)this.building));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        String workerName = "";
        String workerLevel = "";
        if (((AbstractBuildingWorker.View)this.building).getWorkerId() != 0) {
            CitizenDataView worker = ((AbstractBuildingWorker.View)this.building).getColony().getCitizen(((AbstractBuildingWorker.View)this.building).getWorkerId());
            if (worker != null) {
                workerName = worker.getName();
                workerLevel = String.format("%d", worker.getLevel());
            }
            this.findPaneOfTypeByID(BUTTON_HIRE, Button.class).setLabel(LanguageHandler.format("com.minecolonies.gui.workerHuts.fire", new Object[0]));
        } else {
            this.findPaneOfTypeByID(BUTTON_HIRE, Button.class).setLabel(LanguageHandler.format("com.minecolonies.gui.workerHuts.hire", new Object[0]));
        }
        this.findPaneOfTypeByID(LABEL_WORKERNAME, Label.class).setLabelText(workerName);
        this.findPaneOfTypeByID(LABEL_WORKERLEVEL, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.gui.workerHuts.workerLevel", workerLevel));
        this.findPaneOfTypeByID(LABEL_BUILDINGTYPE, Label.class).setLabelText("xxxxxxxx");
    }
}

