/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.client.gui;

import com.blockout.controls.Button;
import com.blockout.controls.ButtonVanilla;
import com.blockout.views.SwitchView;
import com.minecolonies.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.colony.buildings.BuildingWarehouse;
import com.minecolonies.util.LanguageHandler;
import org.jetbrains.annotations.NotNull;

public class WindowHutWarehouse
extends AbstractWindowWorkerBuilding<BuildingWarehouse.View>
implements Button.Handler {
    private static final String BUTTON_BLACKSMITH_GOLD = "blacksmithGold";
    private static final String BUTTON_BLACKSMITH_DIAMOND = "blacksmithDiamond";
    private static final String BUTTON_STONEMASON_COBBLESTONE = "stonemasonCobblestone";
    private static final String BUTTON_STONEMASON_SAND = "stonemasonSand";
    private static final String BUTTON_STONEMASON_NETHERRACK = "stonemasonNetherrack";
    private static final String BUTTON_STONEMASON_QUARTZ = "stonemasonQuartz";
    private static final String BUTTON_GUARD_ARMOR = "guardArmor";
    private static final String BUTTON_GUARD_WEAPON = "guardWeapon";
    private static final String BUTTON_CITIZEN_CHESTS = "citizenChests";
    private static final String BUTTON_PREVPAGE = "prevPage";
    private static final String BUTTON_NEXTPAGE = "nextPage";
    private static final String VIEW_PAGES = "pages";
    private static final String HUT_WAREHOUSE_RESOURCE_SUFFIX = ":gui/windowHutWarehouse.xml";
    private Button buttonPrevPage;
    private Button buttonNextPage;

    public WindowHutWarehouse(@NotNull BuildingWarehouse.View building) {
        super(building, "minecolonies:gui/windowHutWarehouse.xml");
        super.registerButton(BUTTON_BLACKSMITH_GOLD, b -> {
            view.blacksmithGold = !view.blacksmithGold;
        });
        super.registerButton(BUTTON_BLACKSMITH_DIAMOND, b -> {
            view.blacksmithDiamond = !view.blacksmithDiamond;
        });
        super.registerButton(BUTTON_STONEMASON_COBBLESTONE, b -> {
            view.stonemasonStone = !view.stonemasonStone;
        });
        super.registerButton(BUTTON_STONEMASON_SAND, b -> {
            view.stonemasonSand = !view.stonemasonSand;
        });
        super.registerButton(BUTTON_STONEMASON_NETHERRACK, b -> {
            view.stonemasonNetherrack = !view.stonemasonNetherrack;
        });
        super.registerButton(BUTTON_STONEMASON_QUARTZ, b -> {
            view.stonemasonQuartz = !view.stonemasonQuartz;
        });
        super.registerButton(BUTTON_GUARD_ARMOR, b -> {
            view.guardArmor = !view.guardArmor;
        });
        super.registerButton(BUTTON_GUARD_WEAPON, b -> {
            view.guardWeapon = !view.guardWeapon;
        });
        super.registerButton(BUTTON_CITIZEN_CHESTS, b -> {
            view.citizenVisit = !view.citizenVisit;
        });
        super.registerButton(BUTTON_BLACKSMITH_GOLD, b -> {
            view.blacksmithGold = !view.blacksmithGold;
        });
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.gui.workerHuts.warehouse";
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.updateButtonLabels();
        this.findPaneOfTypeByID(BUTTON_PREVPAGE, Button.class).setEnabled(false);
        this.buttonPrevPage = this.findPaneOfTypeByID(BUTTON_PREVPAGE, Button.class);
        this.buttonNextPage = this.findPaneOfTypeByID(BUTTON_NEXTPAGE, Button.class);
    }

    private void updateButtonLabels() {
        this.findPaneOfTypeByID(BUTTON_BLACKSMITH_GOLD, ButtonVanilla.class).setLabel(WindowHutWarehouse.getYesOrNo(((BuildingWarehouse.View)this.building).blacksmithGold));
        this.findPaneOfTypeByID(BUTTON_BLACKSMITH_DIAMOND, ButtonVanilla.class).setLabel(WindowHutWarehouse.getYesOrNo(((BuildingWarehouse.View)this.building).blacksmithDiamond));
        this.findPaneOfTypeByID(BUTTON_STONEMASON_COBBLESTONE, ButtonVanilla.class).setLabel(WindowHutWarehouse.getYesOrNo(((BuildingWarehouse.View)this.building).stonemasonStone));
        this.findPaneOfTypeByID(BUTTON_STONEMASON_SAND, ButtonVanilla.class).setLabel(WindowHutWarehouse.getYesOrNo(((BuildingWarehouse.View)this.building).stonemasonSand));
        this.findPaneOfTypeByID(BUTTON_STONEMASON_NETHERRACK, ButtonVanilla.class).setLabel(WindowHutWarehouse.getYesOrNo(((BuildingWarehouse.View)this.building).stonemasonNetherrack));
        this.findPaneOfTypeByID(BUTTON_STONEMASON_QUARTZ, ButtonVanilla.class).setLabel(WindowHutWarehouse.getYesOrNo(((BuildingWarehouse.View)this.building).stonemasonQuartz));
        this.findPaneOfTypeByID(BUTTON_GUARD_ARMOR, ButtonVanilla.class).setLabel(WindowHutWarehouse.getYesOrNo(((BuildingWarehouse.View)this.building).guardArmor));
        this.findPaneOfTypeByID(BUTTON_GUARD_WEAPON, ButtonVanilla.class).setLabel(WindowHutWarehouse.getYesOrNo(((BuildingWarehouse.View)this.building).guardWeapon));
        this.findPaneOfTypeByID(BUTTON_CITIZEN_CHESTS, ButtonVanilla.class).setLabel(WindowHutWarehouse.getYesOrNo(((BuildingWarehouse.View)this.building).citizenVisit));
    }

    private static String getYesOrNo(boolean bool) {
        return bool ? LanguageHandler.format("gui.yes", new Object[0]) : LanguageHandler.format("gui.no", new Object[0]);
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        switch (button.getID()) {
            case "prevPage": {
                this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).previousView();
                this.buttonPrevPage.setEnabled(false);
                this.buttonNextPage.setEnabled(true);
                break;
            }
            case "nextPage": {
                this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).nextView();
                this.buttonPrevPage.setEnabled(true);
                this.buttonNextPage.setEnabled(false);
                break;
            }
            default: {
                super.onButtonClicked(button);
            }
        }
        this.updateButtonLabels();
    }
}

