/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.buildings;

import com.blockout.views.Window;
import com.minecolonies.achievements.ModAchievements;
import com.minecolonies.client.gui.WindowTownHall;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuildingHut;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingTownHall
extends AbstractBuildingHut {
    private static final String TOWN_HALL = "TownHall";

    public BuildingTownHall(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return TOWN_HALL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 4;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().triggerAchievement(ModAchievements.achievementBuildingTownhall);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().triggerAchievement(ModAchievements.achievementUpgradeTownhallMax);
        }
    }

    public static class View
    extends AbstractBuildingHut.View {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowTownHall(this);
        }
    }
}

