/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.materials;

import com.minecolonies.colony.materials.MaterialStore;
import com.minecolonies.colony.materials.QuantityNotFound;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Material {
    @NotNull
    private Map<MaterialStore, Integer> locations = new HashMap<MaterialStore, Integer>();
    private Integer id;

    Material(Integer id) {
        this.id = id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(@Nullable Object material) {
        return material != null && material.getClass() == this.getClass() && this.id.equals(((Material)material).id);
    }

    @NotNull
    public Map<MaterialStore, Integer> getLocationsStored() {
        return Collections.unmodifiableMap(this.locations);
    }

    public int getMaterialCount(@NotNull MaterialStore store, Material material) {
        if (this.locations.containsKey(store)) {
            return store.getMaterialCount(material);
        }
        return 0;
    }

    void add(MaterialStore store, int quantity) {
        Integer count = this.locations.get(store);
        if (count == null) {
            this.locations.put(store, quantity);
        } else {
            this.locations.put(store, count + quantity);
        }
    }

    void remove(MaterialStore store, int quantity) {
        Integer count = this.locations.get(store);
        if (count == null || count < quantity) {
            throw new QuantityNotFound("MaterialStore (Material)", this.getID(), count == null ? 0 : count, quantity);
        }
        if (count == quantity) {
            this.locations.remove(store);
        } else {
            this.locations.put(store, count - quantity);
        }
    }

    Integer getID() {
        return this.id;
    }

    void remove(MaterialStore store) {
        this.locations.remove(store);
    }
}

