/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity;

import com.minecolonies.MineColonies;
import com.minecolonies.client.render.RenderBipedCitizen;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.CitizenDataView;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.colony.buildings.BuildingFarmer;
import com.minecolonies.colony.buildings.BuildingHome;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.configuration.Configurations;
import com.minecolonies.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.entity.ai.minimal.EntityAICitizenAvoidEntity;
import com.minecolonies.entity.ai.minimal.EntityAICitizenWander;
import com.minecolonies.entity.ai.minimal.EntityAIGoHome;
import com.minecolonies.entity.ai.minimal.EntityAIOpenFenceGate;
import com.minecolonies.entity.ai.minimal.EntityAISleep;
import com.minecolonies.entity.pathfinding.PathNavigate;
import com.minecolonies.inventory.InventoryCitizen;
import com.minecolonies.network.messages.BlockParticleEffectMessage;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.EntityUtils;
import com.minecolonies.util.ExperienceUtils;
import com.minecolonies.util.InventoryUtils;
import com.minecolonies.util.LanguageHandler;
import com.minecolonies.util.Log;
import com.minecolonies.util.SoundUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCitizen
extends EntityAgeable
implements INpc {
    private static final DataParameter<Integer> DATA_TEXTURE = EntityDataManager.func_187226_a(EntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_LEVEL = EntityDataManager.func_187226_a(EntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_IS_FEMALE = EntityDataManager.func_187226_a(EntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_COLONY_ID = EntityDataManager.func_187226_a(EntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_CITIZEN_ID = EntityDataManager.func_187226_a(EntityCitizen.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> DATA_MODEL = EntityDataManager.func_187226_a(EntityCitizen.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> DATA_RENDER_METADATA = EntityDataManager.func_187226_a(EntityCitizen.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final int MOVE_AWAY_SPEED = 2;
    private static final int MOVE_AWAY_RANGE = 6;
    private static final int HEAL_CITIZENS_AFTER = 200;
    private static final String TAG_COLONY_ID = "colony";
    private static final String TAG_CITIZEN = "citizen";
    private static final String TAG_HELD_ITEM_SLOT = "HeldItemSlot";
    private static final String TAG_STATUS = "status";
    private static final float FACING_DELTA_YAW = 10.0f;
    private static final double BLOCK_BREAK_SOUND_RANGE = 16.0;
    private static final double BLOCK_BREAK_PARTICLE_RANGE = 16.0;
    private static final int EXP_DIVIDER = 10;
    private static final int RANT_ABOUT_WEATHER_CHANCE = 6000;
    private static Field navigatorField;
    protected Status status = Status.IDLE;
    private RenderBipedCitizen.Model modelId = RenderBipedCitizen.Model.SETTLER;
    private String renderMetadata;
    private ResourceLocation texture;
    private InventoryCitizen inventory;
    private int colonyId;
    private int citizenId = 0;
    private int level;
    private int textureId;
    private double skillModifier = 0.0;
    private boolean female;
    @Nullable
    private Colony colony;
    @Nullable
    private CitizenData citizenData;
    @NotNull
    private Map<String, Integer> statusMessages = new HashMap<String, Integer>();
    private PathNavigate newNavigator;
    private static final double CITIZEN_HEIGHT = 1.8;
    private static final double CITIZEN_WIDTH = 0.6;
    private static final double RENDER_DISTANCE_WEIGHT = 2.0;

    public EntityCitizen(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_110163_bv();
        this.func_174805_g(Configurations.alwaysRenderNameTag);
        this.inventory = new InventoryCitizen("Minecolonies Inventory", false, this);
        this.newNavigator = new PathNavigate((EntityLiving)this, world);
        this.updateNavigatorField();
        if (world.field_72995_K) {
            EntityCitizen.func_184227_b((double)2.0);
        }
        this.newNavigator.func_179693_d(true);
        this.newNavigator.func_179691_c(true);
        this.initTasks();
    }

    private synchronized void updateNavigatorField() {
        if (navigatorField == null) {
            Field[] fields;
            for (Field field : fields = EntityLiving.class.getDeclaredFields()) {
                if (!field.getType().equals(net.minecraft.pathfinding.PathNavigate.class)) continue;
                field.setAccessible(true);
                navigatorField = field;
                break;
            }
        }
        if (navigatorField == null) {
            throw new IllegalStateException("Navigator field should not be null, contact developers.");
        }
        try {
            navigatorField.set((Object)this, (Object)this.newNavigator);
        }
        catch (IllegalAccessException e) {
            Log.getLogger().error("Navigator error", (Throwable)e);
        }
    }

    private void initTasks() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAICitizenAvoidEntity(this, EntityMob.class, 8.0f, 0.6, 1.6));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIGoHome(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISleep(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenFenceGate((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityCitizen.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAICitizenWander(this, 0.6));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 6.0f));
        this.onJobChanged(this.getColonyJob());
    }

    public void onJobChanged(@Nullable AbstractJob job) {
        Object[] currentTasks;
        if (job != null) {
            this.modelId = job.getModel();
        } else {
            switch (this.getLevel()) {
                case 1: {
                    this.modelId = RenderBipedCitizen.Model.CITIZEN;
                    break;
                }
                case 2: {
                    this.modelId = RenderBipedCitizen.Model.NOBLE;
                    break;
                }
                case 3: {
                    this.modelId = RenderBipedCitizen.Model.ARISTOCRAT;
                    break;
                }
                default: {
                    this.modelId = RenderBipedCitizen.Model.SETTLER;
                }
            }
        }
        this.field_70180_af.func_187227_b(DATA_MODEL, (Object)this.modelId.name());
        this.setRenderMetadata("");
        for (Object task : currentTasks = this.field_70714_bg.field_75782_a.toArray()) {
            if (!(((EntityAITasks.EntityAITaskEntry)task).field_75733_a instanceof AbstractEntityAIInteract)) continue;
            this.field_70714_bg.func_85156_a(((EntityAITasks.EntityAITaskEntry)task).field_75733_a);
        }
        if (job != null) {
            job.addTasks(this.field_70714_bg);
            if (this.field_70173_aa > 0 && this.getWorkBuilding() != null) {
                BlockPosUtil.tryMoveLivingToXYZ((EntityLiving)this, this.getWorkBuilding().getLocation());
            }
        }
    }

    public AbstractJob getColonyJob() {
        return this.citizenData != null ? this.citizenData.getJob() : null;
    }

    public int getLevel() {
        return this.level;
    }

    public void setRenderMetadata(String metadata) {
        this.renderMetadata = metadata;
        this.field_70180_af.func_187227_b(DATA_RENDER_METADATA, (Object)this.renderMetadata);
        if (this.citizenData != null) {
            if (this.getColonyJob() != null && Configurations.enableInDevelopmentFeatures) {
                this.func_96094_a(this.citizenData.getName() + " (" + (Object)((Object)this.getStatus()) + ")[" + this.getColonyJob().getNameTagDescription() + "]");
            } else {
                this.func_96094_a(this.citizenData.getName());
            }
        }
    }

    @Nullable
    public AbstractBuildingWorker getWorkBuilding() {
        return this.citizenData != null ? this.citizenData.getWorkBuilding() : null;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isWorkerAtSiteWithMove(@NotNull BlockPos site, int range) {
        return EntityUtils.isWorkerAtSiteWithMove(this, site.func_177958_n(), site.func_177956_o(), site.func_177952_p(), range) || EntityUtils.isWorkerAtSite(this, site.func_177958_n(), site.func_177956_o(), site.func_177952_p(), range + 1);
    }

    @Nullable
    public <J extends AbstractJob> J getColonyJob(@NotNull Class<J> type) {
        return this.citizenData != null ? (J)this.citizenData.getJob(type) : null;
    }

    public void faceBlock(@Nullable BlockPos block) {
        if (block == null) {
            return;
        }
        double xDifference = (double)block.func_177958_n() - this.field_70165_t;
        double zDifference = (double)block.func_177952_p() - this.field_70161_v;
        double yDifference = (double)block.func_177956_o() - (this.field_70163_u + (double)this.func_70047_e());
        double squareDifference = Math.sqrt(xDifference * xDifference + zDifference * zDifference);
        double intendedRotationYaw = Math.atan2(zDifference, xDifference) * 180.0 / Math.PI - 90.0;
        double intendedRotationPitch = -(Math.atan2(yDifference, squareDifference) * 180.0 / Math.PI);
        this.func_70101_b((float)this.updateRotation(this.field_70177_z, intendedRotationYaw, 30.0), (float)this.updateRotation(this.field_70125_A, intendedRotationPitch, 30.0));
    }

    private double updateRotation(double currentRotation, double intendedRotation, double maxIncrement) {
        double wrappedAngle = MathHelper.func_76138_g((double)(intendedRotation - currentRotation));
        if (wrappedAngle > maxIncrement) {
            wrappedAngle = maxIncrement;
        }
        if (wrappedAngle < -maxIncrement) {
            wrappedAngle = -maxIncrement;
        }
        return currentRotation + wrappedAngle;
    }

    public void gatherXp() {
        for (EntityXPOrb orb : this.getXPOrbsOnGrid()) {
            this.addExperience(orb.func_70526_d());
            orb.func_70106_y();
        }
    }

    private List<EntityXPOrb> getXPOrbsOnGrid() {
        AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - 2.0, this.field_70163_u - 2.0, this.field_70161_v - 2.0, this.field_70165_t + 2.0, this.field_70163_u + 2.0, this.field_70161_v + 2.0);
        return this.field_70170_p.func_72872_a(EntityXPOrb.class, bb);
    }

    public void addExperience(double xp) {
        double localXp = xp * this.skillModifier / 10.0;
        double maxValue = 2.147483647E9 - this.citizenData.getExperience();
        if (localXp > maxValue) {
            localXp = maxValue;
        }
        this.citizenData.addExperience(localXp);
        while (ExperienceUtils.getXPNeededForNextLevel(this.citizenData.getLevel()) < this.citizenData.getExperience()) {
            this.citizenData.increaseLevel();
        }
        this.citizenData.markDirty();
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.field_70122_E) {
            int px = MathHelper.func_76128_c((double)this.field_70165_t);
            int py = (int)this.field_70163_u;
            int pz = MathHelper.func_76128_c((double)this.field_70161_v);
            this.field_70122_E = this.field_70170_p.func_180495_p(new BlockPos(px, py, pz)).func_177230_c().isLadder(this.field_70170_p.func_180495_p(new BlockPos(px, py, pz)), (IBlockAccess)this.field_70170_p, new BlockPos(px, py, pz), (EntityLivingBase)this);
        }
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        this.dropExperience();
        this.func_70106_y();
        if (this.colony != null) {
            LanguageHandler.sendPlayersLocalizedMessage(this.colony.getMessageEntityPlayers(), "tile.blockHutTownHall.messageColonistDead", this.citizenData.getName());
            this.colony.removeCitizen(this.getCitizenData());
        }
        super.func_70645_a(par1DamageSource);
    }

    private void dropExperience() {
        if (!this.field_70170_p.field_72995_K && this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            int j;
            for (int experience = (int)((double)(this.citizenData.getLevel() * 100) + this.getExperiencePoints()); experience > 0; experience -= j) {
                j = EntityXPOrb.func_70527_a((int)experience);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        }
        for (int i = 0; i < 20; ++i) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + this.field_70146_Z.nextDouble() * (double)this.field_70130_N * 2.0 - (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + this.field_70146_Z.nextDouble() * (double)this.field_70130_N * 2.0 - (double)this.field_70130_N, d2, d0, d1, new int[0]);
        }
    }

    @Nullable
    public CitizenData getCitizenData() {
        return this.citizenData;
    }

    private double getExperiencePoints() {
        return this.citizenData.getExperience();
    }

    public EntityAgeable func_90011_a(EntityAgeable var1) {
        return null;
    }

    public boolean func_184645_a(@NotNull EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        CitizenDataView citizenDataView;
        if (this.field_70170_p.field_72995_K && (citizenDataView = this.getCitizenDataView()) != null) {
            MineColonies.proxy.showCitizenWindow(citizenDataView);
        }
        return true;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_COLONY_ID, (Object)this.colonyId);
        this.field_70180_af.func_187214_a(DATA_CITIZEN_ID, (Object)this.citizenId);
        this.field_70180_af.func_187214_a(DATA_TEXTURE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(DATA_IS_FEMALE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_MODEL, (Object)RenderBipedCitizen.Model.SETTLER.name());
        this.field_70180_af.func_187214_a(DATA_RENDER_METADATA, (Object)"");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a(TAG_STATUS, this.status.ordinal());
        if (this.colony != null && this.citizenData != null) {
            compound.func_74768_a(TAG_COLONY_ID, this.colony.getID());
            compound.func_74768_a(TAG_CITIZEN, this.citizenData.getId());
        }
        this.inventory.writeToNBT(compound);
        compound.func_74768_a(TAG_HELD_ITEM_SLOT, this.inventory.getHeldItemSlot());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.status = Status.values()[compound.func_74762_e(TAG_STATUS)];
        this.colonyId = compound.func_74762_e(TAG_COLONY_ID);
        this.citizenId = compound.func_74762_e(TAG_CITIZEN);
        if (this.func_70613_aW()) {
            this.updateColonyServer();
        }
        this.inventory.readFromNBT(compound);
        this.inventory.setHeldItem(compound.func_74762_e(TAG_HELD_ITEM_SLOT));
    }

    public void func_70636_d() {
        if (this.field_70718_bc > 0) {
            this.citizenData.markDirty();
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateColonyClient();
        } else {
            this.pickupItems();
            this.cleanupChatMessages();
            this.updateColonyServer();
            if (this.field_70170_p.func_72935_r() && !this.field_70170_p.func_72896_J()) {
                SoundUtils.playRandomSound(this.field_70170_p, this);
            } else if (this.field_70170_p.func_72896_J() && 1 >= this.field_70146_Z.nextInt(6000) && this.getColonyJob() != null) {
                SoundUtils.playSoundAtCitizenWithChance(this.field_70170_p, this.func_180425_c(), this.getColonyJob().getBadWeatherSound(), 1);
            }
        }
        if (this.func_70094_T() || this.func_70055_a(Material.field_151584_j)) {
            this.getNavigator().moveAwayFromXYZ(this.func_180425_c(), 6.0, 2.0);
        }
        this.checkHeal();
        super.func_70636_d();
    }

    public Random getRandom() {
        return this.field_70146_Z;
    }

    private void updateColonyClient() {
        if (this.field_70180_af.func_187223_a()) {
            if (this.colonyId == 0) {
                this.colonyId = (Integer)this.field_70180_af.func_187225_a(DATA_COLONY_ID);
            }
            if (this.citizenId == 0) {
                this.citizenId = (Integer)this.field_70180_af.func_187225_a(DATA_CITIZEN_ID);
            }
            this.female = (Integer)this.field_70180_af.func_187225_a(DATA_IS_FEMALE) != 0;
            this.level = (Integer)this.field_70180_af.func_187225_a(DATA_LEVEL);
            this.modelId = RenderBipedCitizen.Model.valueOf((String)this.field_70180_af.func_187225_a(DATA_MODEL));
            this.textureId = (Integer)this.field_70180_af.func_187225_a(DATA_TEXTURE);
            this.renderMetadata = (String)this.field_70180_af.func_187225_a(DATA_RENDER_METADATA);
            this.setTexture();
            this.field_70180_af.func_187230_e();
        }
        this.func_82168_bl();
    }

    private void pickupItems() {
        ArrayList<EntityItem> retList = new ArrayList<EntityItem>();
        for (Object o : this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(2.0, 0.0, 2.0))) {
            if (!(o instanceof EntityItem)) continue;
            retList.add((EntityItem)o);
        }
        retList.stream().filter(item -> item != null).filter(item -> !item.field_70128_L).filter(item -> this.func_98052_bS()).forEach(this::tryPickupEntityItem);
    }

    private void cleanupChatMessages() {
        if (this.statusMessages.size() > 0 && this.field_70173_aa % 20 == 0) {
            Iterator<Map.Entry<String, Integer>> it = this.statusMessages.entrySet().iterator();
            while (it.hasNext()) {
                if (this.field_70173_aa - it.next().getValue() <= 20 * Configurations.chatFrequency) continue;
                it.remove();
            }
        }
    }

    private void checkHeal() {
        if (this.citizenData != null && this.getOffsetTicks() % 200 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(1.0f);
            this.citizenData.markDirty();
        }
    }

    private void setTexture() {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        RenderBipedCitizen.Model model = this.getModelID();
        String textureBase = "textures/entity/";
        textureBase = textureBase + model.textureBase;
        textureBase = textureBase + (this.female ? "Female" : "Male");
        int moddedTextureId = this.textureId % model.numTextures + 1;
        this.texture = new ResourceLocation("minecolonies", textureBase + moddedTextureId + this.renderMetadata + ".png");
    }

    public int getOffsetTicks() {
        return this.field_70173_aa + 7 * this.func_145782_y();
    }

    public RenderBipedCitizen.Model getModelID() {
        return this.modelId;
    }

    public void updateColonyServer() {
        if (this.colonyId == 0) {
            this.func_70106_y();
            return;
        }
        if (this.colony == null) {
            this.handleNullColony();
        }
    }

    private void handleNullColony() {
        Colony c = ColonyManager.getColony(this.colonyId);
        if (c == null) {
            Log.getLogger().warn(String.format("EntityCitizen '%s' unable to find Colony #%d", this.func_110124_au(), this.colonyId));
            this.func_70106_y();
            return;
        }
        CitizenData data = c.getCitizen(this.citizenId);
        if (data == null) {
            Log.getLogger().warn(String.format("EntityCitizen '%s' attempting to register with Colony #%d as Citizen %d, but not known to colony", this.func_110124_au(), this.colonyId, this.citizenId));
            this.func_70106_y();
            return;
        }
        EntityCitizen existingCitizen = data.getCitizenEntity();
        if (existingCitizen != null && existingCitizen != this) {
            this.handleExistingCitizen(data, existingCitizen);
            return;
        }
        this.setColony(c, data);
    }

    private void handleExistingCitizen(@NotNull CitizenData data, @NotNull EntityCitizen existingCitizen) {
        Log.getLogger().warn(String.format("EntityCitizen '%s' attempting to register with Colony #%d as Citizen #%d, but already have a citizen ('%s')", this.func_110124_au(), this.colonyId, this.citizenId, existingCitizen.func_110124_au()));
        if (!existingCitizen.func_110124_au().equals(this.func_110124_au())) {
            this.func_70106_y();
        } else {
            data.setCitizenEntity(this);
        }
    }

    public void setColony(@Nullable Colony c, @Nullable CitizenData data) {
        if (c == null) {
            this.colony = null;
            this.colonyId = 0;
            this.citizenId = 0;
            this.citizenData = null;
            this.func_70106_y();
            return;
        }
        this.colony = c;
        this.colonyId = this.colony.getID();
        this.citizenId = data.getId();
        this.citizenData = data;
        this.func_96094_a(this.citizenData.getName());
        this.female = this.citizenData.isFemale();
        this.textureId = this.citizenData.getTextureId();
        this.field_70180_af.func_187227_b(DATA_COLONY_ID, (Object)this.colonyId);
        this.field_70180_af.func_187227_b(DATA_CITIZEN_ID, (Object)this.citizenId);
        this.field_70180_af.func_187227_b(DATA_IS_FEMALE, (Object)(this.female ? 1 : 0));
        this.field_70180_af.func_187227_b(DATA_TEXTURE, (Object)this.textureId);
        this.updateLevel();
        this.citizenData.setCitizenEntity(this);
        this.onJobChanged(this.getColonyJob());
        this.inventory.createMaterialStore(c.getMaterialSystem());
    }

    private void updateLevel() {
        this.level = this.citizenData != null ? this.citizenData.getLevel() : 0;
        this.field_70180_af.func_187227_b(DATA_LEVEL, (Object)this.level);
    }

    private CitizenDataView getCitizenDataView() {
        ColonyView colonyView;
        if (this.colonyId != 0 && this.citizenId != 0 && (colonyView = ColonyManager.getColonyView(this.colonyId)) != null) {
            return colonyView.getCitizen(this.citizenId);
        }
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    @NotNull
    public PathNavigate getNavigator() {
        return this.newNavigator;
    }

    protected void func_82160_b(boolean par1, int par2) {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack == null || itemstack.field_77994_a <= 0) continue;
            this.entityDropItem(itemstack);
        }
    }

    public boolean func_175446_cd() {
        return false;
    }

    @NotNull
    public InventoryCitizen getInventoryCitizen() {
        return this.inventory;
    }

    private EntityItem entityDropItem(@NotNull ItemStack itemstack) {
        return this.func_70099_a(itemstack, 0.0f);
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public boolean isFemale() {
        return this.female;
    }

    public void clearColony() {
        this.setColony(null, null);
    }

    public boolean isAtHome() {
        BlockPos homePosition = this.func_180486_cf();
        return homePosition != null && homePosition.func_177954_c((double)((int)Math.floor(this.field_70165_t)), (double)((int)this.field_70163_u), (double)((int)Math.floor(this.field_70161_v))) <= 16.0;
    }

    @Nullable
    public BlockPos func_180486_cf() {
        BuildingHome homeBuilding = this.getHomeBuilding();
        if (homeBuilding != null) {
            return homeBuilding.getLocation();
        }
        if (this.getColony() != null && this.getColony().getTownHall() != null) {
            return this.getColony().getTownHall().getLocation();
        }
        return null;
    }

    private BuildingHome getHomeBuilding() {
        return this.citizenData != null ? this.citizenData.getHomeBuilding() : null;
    }

    @Nullable
    public Colony getColony() {
        return this.colony;
    }

    public boolean isInventoryFull() {
        return InventoryUtils.isInventoryFull(this.getInventoryCitizen());
    }

    @NotNull
    public DesiredActivity getDesiredActivity() {
        if (!this.field_70170_p.func_72935_r()) {
            return DesiredActivity.SLEEP;
        }
        if (this.field_70170_p.func_72896_J()) {
            return DesiredActivity.IDLE;
        }
        return DesiredActivity.WORK;
    }

    @Nullable
    public Entity func_184204_a(int dimensionIn) {
        return null;
    }

    @NotNull
    public BlockPos func_180425_c() {
        return new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public int findFirstSlotInInventoryWith(Item targetItem) {
        return InventoryUtils.findFirstSlotInInventoryWith((IInventory)this.getInventoryCitizen(), targetItem);
    }

    public int findFirstSlotInInventoryWith(Block block) {
        return InventoryUtils.findFirstSlotInInventoryWith((IInventory)this.getInventoryCitizen(), block);
    }

    public int getItemCountInInventory(Block block) {
        return InventoryUtils.getItemCountInInventory((IInventory)this.getInventoryCitizen(), block);
    }

    public int getItemCountInInventory(Item targetItem) {
        return InventoryUtils.getItemCountInInventory((IInventory)this.getInventoryCitizen(), targetItem);
    }

    public boolean hasItemInInventory(Block block) {
        return InventoryUtils.hasitemInInventory((IInventory)this.getInventoryCitizen(), block);
    }

    public boolean hasItemInInventory(Item item) {
        return InventoryUtils.hasitemInInventory((IInventory)this.getInventoryCitizen(), item);
    }

    private void tryPickupEntityItem(@NotNull EntityItem entityItem) {
        if (!this.field_70170_p.field_72995_K) {
            if (entityItem.func_174874_s()) {
                return;
            }
            ItemStack itemStack = entityItem.func_92059_d();
            int i = itemStack.field_77994_a;
            if (i <= 0 || InventoryUtils.addItemStackToInventory(this.getInventoryCitizen(), itemStack)) {
                this.field_70170_p.func_184133_a((EntityPlayer)null, this.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.AMBIENT, 0.2f, (float)((this.field_70146_Z.nextGaussian() * 0.7 + 1.0) * 2.0));
                this.func_71001_a((Entity)this, i);
                if (itemStack.field_77994_a <= 0) {
                    entityItem.func_70106_y();
                }
            }
        }
    }

    public void removeHeldItem() {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
    }

    public void setHeldItem(int slot) {
        this.inventory.setHeldItem(slot);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.inventory.func_70301_a(slot));
    }

    public void hitBlockWithToolInHand(@Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        this.hitBlockWithToolInHand(blockPos, false);
    }

    private void hitBlockWithToolInHand(@Nullable BlockPos blockPos, boolean breakBlock) {
        if (blockPos == null) {
            return;
        }
        this.func_70671_ap().func_75650_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 10.0f, (float)this.func_70646_bf());
        this.func_184609_a(this.func_184600_cs());
        IBlockState blockState = this.field_70170_p.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        if (breakBlock) {
            if (!this.field_70170_p.field_72995_K) {
                MineColonies.getNetwork().sendToAllAround((IMessage)new BlockParticleEffectMessage(blockPos, this.field_70170_p.func_180495_p(blockPos), -1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 16.0));
            }
            this.field_70170_p.func_184133_a(null, blockPos, block.getSoundType(blockState, this.field_70170_p, blockPos, (Entity)this).func_185845_c(), SoundCategory.BLOCKS, block.getSoundType(blockState, this.field_70170_p, blockPos, (Entity)this).func_185843_a(), block.getSoundType(blockState, this.field_70170_p, blockPos, (Entity)this).func_185847_b());
            this.field_70170_p.func_175698_g(blockPos);
            this.damageItemInHand(1);
        } else {
            if (!this.field_70170_p.field_72995_K) {
                MineColonies.getNetwork().sendToAllAround((IMessage)new BlockParticleEffectMessage(blockPos, this.field_70170_p.func_180495_p(blockPos), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 16.0));
            }
            this.field_70170_p.func_184133_a((EntityPlayer)null, blockPos, block.getSoundType(blockState, this.field_70170_p, blockPos, (Entity)this).func_185845_c(), SoundCategory.BLOCKS, block.getSoundType(blockState, this.field_70170_p, blockPos, (Entity)this).func_185843_a(), block.getSoundType(blockState, this.field_70170_p, blockPos, (Entity)this).func_185847_b());
        }
    }

    public void damageItemInHand(int damage) {
        ItemStack heldItem = this.inventory.getHeldItemMainhand();
        if (heldItem == null) {
            return;
        }
        heldItem.func_77972_a(damage, (EntityLivingBase)this);
        if (heldItem.field_77994_a < 1) {
            this.getInventoryCitizen().func_70299_a(this.getInventoryCitizen().getHeldItemSlot(), null);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
        }
    }

    public void breakBlockWithToolInHand(@Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        this.hitBlockWithToolInHand(blockPos, true);
    }

    public void sendLocalizedChat(String key, Object ... args) {
        this.sendChat(LanguageHandler.format(key, args));
    }

    private void sendChat(@Nullable String msg) {
        if (msg == null || msg.length() == 0 || this.statusMessages.containsKey(msg)) {
            return;
        }
        this.statusMessages.put(msg, this.field_70173_aa);
        LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), LanguageHandler.format(this.getColonyJob().getName(), new Object[0]) + " " + this.func_95999_t() + ": " + msg);
    }

    public int getIntelligence() {
        return this.citizenData.getIntelligence();
    }

    public int getCharisma() {
        return this.citizenData.getCharisma();
    }

    public int getStrength() {
        return this.citizenData.getStrength();
    }

    public int getEndurance() {
        return this.citizenData.getEndurance();
    }

    public int getDexterity() {
        return this.citizenData.getDexterity();
    }

    public void setSkillModifier(int modifier) {
        this.skillModifier = modifier;
    }

    public int getExperienceLevel() {
        return this.citizenData.getLevel();
    }

    public void onWakeUp() {
        if (this.getWorkBuilding() instanceof BuildingFarmer) {
            ((BuildingFarmer)this.getWorkBuilding()).resetFields();
        }
    }

    public static enum Status {
        IDLE,
        SLEEPING,
        WORKING,
        GETTING_ITEMS,
        NEED_ASSISTANCE,
        PATHFINDING_ERROR;

    }

    public static enum DesiredActivity {
        SLEEP,
        IDLE,
        WORK;

    }
}

