/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.basic;

import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.configuration.Configurations;
import com.minecolonies.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.entity.ai.util.AIState;
import com.minecolonies.entity.ai.util.AITarget;
import com.minecolonies.entity.ai.util.Structure;
import com.minecolonies.util.BlockUtils;
import com.minecolonies.util.EntityUtils;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIStructure<J extends AbstractJob>
extends AbstractEntityAIInteract<J> {
    private static final int MIN_ADDITIONAL_RANGE_TO_BUILD = 3;
    private static final int MAX_ADDITIONAL_RANGE_TO_BUILD = 25;
    private static final int BUILDING_WALK_RANGE = 10;
    private static final int UNLIMITED_RESOURCES_TIMEOUT = 5;
    private Structure currentStructure;
    private BlockPos workFrom;

    protected AbstractEntityAIStructure(@NotNull J job) {
        super(job);
        this.registerTargets(new AITarget(this::isThereAStructureToBuild, () -> AIState.START_BUILDING), new AITarget(AIState.START_BUILDING, this::startBuilding), new AITarget(AIState.CLEAR_STEP, this.generateSchematicIterator(this::clearStep, AIState.BUILDER_STRUCTURE_STEP)), new AITarget(AIState.BUILDING_STEP, () -> AIState.IDLE), new AITarget(AIState.DECORATION_STEP, () -> AIState.IDLE), new AITarget(AIState.SPAWN_STEP, () -> AIState.IDLE), new AITarget(AIState.COMPLETE_BUILD, () -> AIState.IDLE));
    }

    private Supplier<AIState> generateSchematicIterator(@NotNull Function<Structure.SchematicBlock, Boolean> evaluationFunction, @NotNull AIState nextState) {
        Supplier<Structure.SchematicBlock> getCurrentBlock = () -> this.currentStructure.getCurrentBlock();
        Supplier<Structure.Result> advanceBlock = () -> this.currentStructure.advanceBlock();
        return () -> {
            Structure.SchematicBlock currentBlock = (Structure.SchematicBlock)getCurrentBlock.get();
            if (currentBlock.block == null || ((Boolean)evaluationFunction.apply(currentBlock)).booleanValue()) {
                Structure.Result result = (Structure.Result)((Object)((Object)advanceBlock.get()));
                if (result == Structure.Result.AT_END) {
                    return nextState;
                }
                if (result == Structure.Result.CONFIG_LIMIT) {
                    return this.getState();
                }
            }
            return this.getState();
        };
    }

    private boolean walkToConstructionSite() {
        if (this.workFrom == null) {
            this.workFrom = this.getWorkingPosition();
        }
        return this.walkToBlock(this.workFrom, 10);
    }

    private BlockPos getWorkingPosition() {
        return this.getWorkingPosition(0);
    }

    private BlockPos getWorkingPosition(int offset) {
        EnumFacing[] directions;
        if (offset > 25) {
            return this.currentStructure.getCurrentBlockPosition();
        }
        int length = this.currentStructure.getLength();
        int width = this.currentStructure.getWidth();
        int distance = Math.max(width, length) + 3 + offset;
        for (EnumFacing direction : directions = new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}) {
            BlockPos positionInDirection = this.getPositionInDirection(direction, distance);
            if (!EntityUtils.checkForFreeSpace(this.world, positionInDirection)) continue;
            return positionInDirection;
        }
        return this.getWorkingPosition(offset + 1);
    }

    private boolean clearStep(@NotNull Structure.SchematicBlock currentBlock) {
        if (!BlockUtils.shouldNeverBeMessedWith(currentBlock.worldBlock)) {
            if (this.walkToConstructionSite()) {
                return false;
            }
            this.worker.faceBlock(currentBlock.blockPosition);
            if (Configurations.builderInfiniteResources) {
                this.worker.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
                this.world.func_175698_g(currentBlock.blockPosition);
                this.worker.func_184609_a(this.worker.func_184600_cs());
                this.setDelay(5);
            } else if (!this.mineBlock(currentBlock.blockPosition)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    private BlockPos getPositionInDirection(EnumFacing facing, int distance) {
        return this.getFloor(this.currentStructure.getCurrentBlockPosition().func_177967_a(facing, distance));
    }

    @NotNull
    private BlockPos getFloor(@NotNull BlockPos position) {
        if (!EntityUtils.solidOrLiquid(this.world, position)) {
            return this.getFloor(position.func_177977_b());
        }
        if (!EntityUtils.solidOrLiquid(this.world, position.func_177984_a())) {
            return position;
        }
        return this.getFloor(position.func_177984_a());
    }

    private boolean isThereAStructureToBuild() {
        return this.currentStructure != null;
    }

    @NotNull
    private AIState startBuilding() {
        switch (this.currentStructure.getStage()) {
            case CLEAR: {
                return AIState.CLEAR_STEP;
            }
            case BUILD: {
                return AIState.BUILDING_STEP;
            }
            case DECORATE: {
                return AIState.DECORATION_STEP;
            }
            case SPAWN: {
                return AIState.SPAWN_STEP;
            }
        }
        return AIState.COMPLETE_BUILD;
    }
}

