/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.pathfinding;

import com.minecolonies.configuration.Configurations;
import com.minecolonies.entity.pathfinding.AbstractPathJob;
import com.minecolonies.entity.pathfinding.Node;
import com.minecolonies.util.Log;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobMoveToLocation
extends AbstractPathJob {
    private static final float DESTINATION_SLACK_NONE = 0.1f;
    private static final float DESTINATION_SLACK_ADJACENT = 3.1f;
    private static final double TIE_BREAKER = 1.001;
    @NotNull
    private final BlockPos destination;
    private float destinationSlack = 0.1f;

    public PathJobMoveToLocation(World world, @NotNull BlockPos start, @NotNull BlockPos end, int range) {
        super(world, start, end, range);
        this.destination = new BlockPos((Vec3i)end);
    }

    @Override
    @Nullable
    protected Path search() {
        if (Configurations.pathfindingDebugVerbosity > 0) {
            Log.getLogger().info(String.format("Pathfinding from [%d,%d,%d] to [%d,%d,%d]", this.start.func_177958_n(), this.start.func_177956_o(), this.start.func_177952_p(), this.destination.func_177958_n(), this.destination.func_177956_o(), this.destination.func_177952_p()));
        }
        if (this.getGroundHeight(null, this.destination) != this.destination.func_177956_o()) {
            this.destinationSlack = 3.1f;
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        int dx = pos.func_177958_n() - this.destination.func_177958_n();
        int dy = pos.func_177956_o() - this.destination.func_177956_o();
        int dz = pos.func_177952_p() - this.destination.func_177952_p();
        return (double)(Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) * 1.001;
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        if (this.destinationSlack <= 0.1f) {
            return n.pos.func_177958_n() == this.destination.func_177958_n() && n.pos.func_177956_o() == this.destination.func_177956_o() && n.pos.func_177952_p() == this.destination.func_177952_p();
        }
        return this.destination.func_177954_c((double)n.pos.func_177958_n(), (double)n.pos.func_177956_o(), (double)n.pos.func_177952_p()) <= (double)this.destinationSlack;
    }

    @Override
    protected double getNodeResultScore(@NotNull Node n) {
        return -this.destination.func_177954_c((double)n.pos.func_177958_n(), (double)n.pos.func_177956_o(), (double)n.pos.func_177952_p());
    }
}

