/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.items;

import com.minecolonies.achievements.ModAchievements;
import com.minecolonies.blocks.ModBlocks;
import com.minecolonies.configuration.Configurations;
import com.minecolonies.creativetab.ModCreativeTabs;
import com.minecolonies.items.AbstractItemMinecolonies;
import com.minecolonies.items.ModItems;
import com.minecolonies.util.BlockUtils;
import com.minecolonies.util.LanguageHandler;
import com.minecolonies.util.Log;
import com.minecolonies.util.SchematicWrapper;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSupplyChestDeployer
extends AbstractItemMinecolonies {
    private static final int SPACE_RIGHT = 11;
    private static final int SPACE_LEFT = 20;
    private static final int LENGTH = 32;
    private static final int WIDTH = 20;
    private static final int DISTANCE = 4;

    public ItemSupplyChestDeployer() {
        super("supplyChestDeployer");
        super.func_77637_a(ModCreativeTabs.MINECOLONIES);
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn == null || playerIn == null || worldIn.field_72995_K || stack.field_77994_a == 0 || !this.isFirstPlacing(playerIn)) {
            return EnumActionResult.FAIL;
        }
        EnumFacing enumfacing = this.canShipBePlaced(worldIn, pos);
        if (enumfacing != EnumFacing.DOWN) {
            this.spawnShip(worldIn, pos, playerIn, enumfacing);
            --stack.field_77994_a;
            playerIn.func_71029_a((StatBase)ModAchievements.achievementGetSupply);
            return EnumActionResult.SUCCESS;
        }
        LanguageHandler.sendPlayerLocalizedMessage(playerIn, "item.supplyChestDeployer.invalid", new Object[0]);
        return EnumActionResult.FAIL;
    }

    boolean isFirstPlacing(@NotNull EntityPlayer player) {
        if (Configurations.allowInfiniteSupplyChests || !player.func_189102_a(ModAchievements.achievementGetSupply)) {
            return true;
        }
        LanguageHandler.sendPlayerLocalizedMessage(player, "com.minecolonies.error.supplyChestAlreadyPlaced", new Object[0]);
        return false;
    }

    @NotNull
    public EnumFacing canShipBePlaced(@NotNull World world, @NotNull BlockPos pos) {
        if (this.check(world, pos.func_177976_e(), true, false)) {
            return EnumFacing.WEST;
        }
        if (this.check(world, pos.func_177974_f(), true, true)) {
            return EnumFacing.EAST;
        }
        if (this.check(world, pos.func_177968_d(), false, true)) {
            return EnumFacing.SOUTH;
        }
        if (this.check(world, pos.func_177978_c(), false, false)) {
            return EnumFacing.NORTH;
        }
        return EnumFacing.DOWN;
    }

    private void spawnShip(@NotNull World world, @NotNull BlockPos pos, EntityPlayer entityPlayer, @NotNull EnumFacing chestFacing) {
        world.func_175656_a(pos.func_177984_a(), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)chestFacing));
        this.placeSupplyShip(world, pos, chestFacing);
        this.fillChest((TileEntityChest)world.func_175625_s(pos.func_177984_a()));
    }

    private boolean check(@NotNull World world, @NotNull BlockPos pos, boolean shouldCheckX, boolean isCoordPositivelyAdded) {
        int k = isCoordPositivelyAdded ? 1 : -1;
        int horizontalX = isCoordPositivelyAdded ? 20 : 11;
        int horizontalZ = isCoordPositivelyAdded ? 11 : 20;
        int spaceRightK = 11 * k;
        int spaceLeftK = 20 * k;
        int widthK = 20 * k;
        int widthKHalf = widthK / 2;
        if (shouldCheckX) {
            int i;
            for (i = 4; i < 20; ++i) {
                int j = k * i;
                if (BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(j, 0, 0))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(j, 0, spaceRightK))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(j, 0, -spaceLeftK)))) continue;
                return false;
            }
            for (i = 0; i < 32; ++i) {
                if (BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(4 * k, 0, -horizontalX + i))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(widthKHalf, 0, -horizontalX + i))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(widthK, 0, -horizontalX + i)))) continue;
                return false;
            }
        } else {
            int i;
            for (i = 4; i < 20; ++i) {
                int j = k * i;
                if (BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(0, 0, j))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(-spaceRightK, 0, j))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(spaceLeftK, 0, j)))) continue;
                return false;
            }
            for (i = 0; i < 32; ++i) {
                if (BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(-horizontalZ + i, 0, 4 * k))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(-horizontalZ + i, 0, widthKHalf))) && BlockUtils.isWater(world.func_180495_p(pos.func_177982_a(-horizontalZ + i, 0, widthK)))) continue;
                return false;
            }
        }
        return true;
    }

    private void placeSupplyShip(World world, @NotNull BlockPos pos, @NotNull EnumFacing direction) {
        switch (direction) {
            case SOUTH: {
                SchematicWrapper.loadAndPlaceSchematicWithRotation(world, "supplyShip", pos.func_177982_a(-11, -2, 5), 3);
                break;
            }
            case NORTH: {
                SchematicWrapper.loadAndPlaceSchematicWithRotation(world, "supplyShip", pos.func_177982_a(-20, -2, -21), 1);
                break;
            }
            case EAST: {
                SchematicWrapper.loadAndPlaceSchematicWithRotation(world, "supplyShip", pos.func_177982_a(5, -2, -20), 2);
                break;
            }
            case WEST: {
                SchematicWrapper.loadAndPlaceSchematicWithRotation(world, "supplyShip", pos.func_177982_a(-21, -2, -11), 0);
                break;
            }
        }
    }

    private void fillChest(@Nullable TileEntityChest chest) {
        if (chest == null) {
            Log.getLogger().error("Supply chest tile entity was null.");
            return;
        }
        chest.func_70299_a(0, new ItemStack(ModBlocks.blockHutTownHall));
        chest.func_70299_a(1, new ItemStack(ModItems.buildTool));
    }
}

