/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.buildings.BuildingFarmer;
import com.minecolonies.colony.permissions.Permissions;
import com.minecolonies.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignmentModeMessage
implements IMessage,
IMessageHandler<AssignmentModeMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private boolean assignmentMode;

    public AssignmentModeMessage() {
    }

    public AssignmentModeMessage(@NotNull BuildingFarmer.View building, boolean assignmentMode) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.assignmentMode = assignmentMode;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.assignmentMode = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeBoolean(this.assignmentMode);
    }

    @Nullable
    public IMessage onMessage(@NotNull AssignmentModeMessage message, @NotNull MessageContext ctx) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)ctx.getServerHandler().field_147369_b, Permissions.Action.ACCESS_HUTS)) {
                return null;
            }
            BuildingFarmer building = colony.getBuilding(message.buildingId, BuildingFarmer.class);
            if (building != null) {
                building.setAssignManually(message.assignmentMode);
            }
        }
        return null;
    }
}

