/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewCitizenViewMessage
implements IMessage,
IMessageHandler<ColonyViewCitizenViewMessage, IMessage> {
    private int colonyId;
    private int citizenId;
    private ByteBuf citizenBuffer;

    public ColonyViewCitizenViewMessage() {
    }

    public ColonyViewCitizenViewMessage(@NotNull Colony colony, @NotNull CitizenData citizen) {
        this.colonyId = colony.getID();
        this.citizenId = citizen.getId();
        this.citizenBuffer = Unpooled.buffer();
        citizen.serializeViewNetworkData(this.citizenBuffer);
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.citizenId = buf.readInt();
        this.citizenBuffer = Unpooled.buffer();
        buf.readBytes(this.citizenBuffer, buf.readableBytes());
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.citizenId);
        buf.writeBytes(this.citizenBuffer);
    }

    @Nullable
    public IMessage onMessage(@NotNull ColonyViewCitizenViewMessage message, MessageContext ctx) {
        return ColonyManager.handleColonyViewCitizensMessage(message.colonyId, message.citizenId, message.citizenBuffer);
    }
}

