/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewRemoveCitizenMessage
implements IMessage,
IMessageHandler<ColonyViewRemoveCitizenMessage, IMessage> {
    private int colonyId;
    private int citizenId;

    public ColonyViewRemoveCitizenMessage() {
    }

    public ColonyViewRemoveCitizenMessage(@NotNull Colony colony, int citizen) {
        this.colonyId = colony.getID();
        this.citizenId = citizen;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.citizenId = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.citizenId);
    }

    @Nullable
    public IMessage onMessage(@NotNull ColonyViewRemoveCitizenMessage message, MessageContext ctx) {
        return ColonyManager.handleColonyViewRemoveCitizenMessage(message.colonyId, message.citizenId);
    }
}

