/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.workorders.AbstractWorkOrder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewWorkOrderMessage
implements IMessage,
IMessageHandler<ColonyViewWorkOrderMessage, IMessage> {
    private int colonyId;
    private int workOrderId;
    private ByteBuf workOrderBuffer;

    public ColonyViewWorkOrderMessage() {
    }

    public ColonyViewWorkOrderMessage(@NotNull Colony colony, @NotNull AbstractWorkOrder workOrder) {
        this.colonyId = colony.getID();
        this.workOrderBuffer = Unpooled.buffer();
        this.workOrderId = workOrder.getID();
        workOrder.serializeViewNetworkData(this.workOrderBuffer);
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.workOrderId = buf.readInt();
        this.workOrderBuffer = buf;
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.workOrderId);
        buf.writeBytes(this.workOrderBuffer);
    }

    @Nullable
    public IMessage onMessage(@NotNull ColonyViewWorkOrderMessage message, MessageContext ctx) {
        return ColonyManager.handleColonyViewWorkOrderMessage(message.colonyId, message.workOrderBuffer);
    }
}

