/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.buildings.BuildingMiner;
import com.minecolonies.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinerSetLevelMessage
implements IMessage,
IMessageHandler<MinerSetLevelMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private int level;

    public MinerSetLevelMessage() {
    }

    public MinerSetLevelMessage(@NotNull BuildingMiner.View building, int level) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.level = level;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.level = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.level);
    }

    @Nullable
    public IMessage onMessage(@NotNull MinerSetLevelMessage message, MessageContext ctx) {
        BuildingMiner building;
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null && (building = colony.getBuilding(message.buildingId, BuildingMiner.class)) != null && message.level >= 0 && message.level < building.getNumberOfLevels()) {
            building.setCurrentLevel(message.level);
        }
        return null;
    }
}

