/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.CitizenDataView;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.entity.EntityCitizen;
import com.minecolonies.inventory.InventoryCitizen;
import com.minecolonies.inventory.InventoryField;
import com.minecolonies.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInventoryMessage
implements IMessage,
IMessageHandler<OpenInventoryMessage, IMessage> {
    private String name;
    private InventoryType inventoryType;
    private int entityID;
    private BlockPos tePos;
    private int colonyId;

    public OpenInventoryMessage() {
    }

    public OpenInventoryMessage(@NotNull CitizenDataView citizen) {
        this.inventoryType = InventoryType.INVENTORY_CITIZEN;
        this.name = citizen.getName();
        this.entityID = citizen.getEntityId();
    }

    public OpenInventoryMessage(@NotNull AbstractBuilding.View building) {
        this.inventoryType = InventoryType.INVENTORY_CHEST;
        this.name = "";
        this.tePos = building.getLocation();
    }

    public OpenInventoryMessage(BlockPos field, int colonyId) {
        this.inventoryType = InventoryType.INVENTORY_FIELD;
        this.name = "field";
        this.tePos = field;
        this.colonyId = colonyId;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.inventoryType = InventoryType.values()[buf.readInt()];
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        switch (this.inventoryType) {
            case INVENTORY_CITIZEN: {
                this.entityID = buf.readInt();
                break;
            }
            case INVENTORY_CHEST: {
                this.tePos = BlockPosUtil.readFromByteBuf(buf);
                break;
            }
            case INVENTORY_FIELD: {
                this.colonyId = buf.readInt();
                this.tePos = BlockPosUtil.readFromByteBuf(buf);
            }
        }
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.inventoryType.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        switch (this.inventoryType) {
            case INVENTORY_CITIZEN: {
                buf.writeInt(this.entityID);
                break;
            }
            case INVENTORY_CHEST: {
                BlockPosUtil.writeToByteBuf(buf, this.tePos);
                break;
            }
            case INVENTORY_FIELD: {
                buf.writeInt(this.colonyId);
                BlockPosUtil.writeToByteBuf(buf, this.tePos);
            }
        }
    }

    @Nullable
    public IMessage onMessage(@NotNull OpenInventoryMessage message, @NotNull MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        switch (message.inventoryType) {
            case INVENTORY_CITIZEN: {
                InventoryCitizen citizenInventory = ((EntityCitizen)player.field_70170_p.func_73045_a(message.entityID)).getInventoryCitizen();
                if (!StringUtils.func_151246_b((String)message.name)) {
                    citizenInventory.setCustomName(message.name);
                }
                player.func_71007_a((IInventory)citizenInventory);
                break;
            }
            case INVENTORY_CHEST: {
                TileEntityChest chest = (TileEntityChest)BlockPosUtil.getTileEntity(player.field_70170_p, message.tePos);
                if (!StringUtils.func_151246_b((String)message.name)) {
                    chest.func_145976_a(message.name);
                }
                player.func_71007_a((IInventory)chest);
                break;
            }
            case INVENTORY_FIELD: {
                InventoryField inventoryField = ColonyManager.getColony(this.colonyId).getField(message.tePos).getInventoryField();
                if (!StringUtils.func_151246_b((String)message.name)) {
                    inventoryField.setCustomName(message.name);
                }
                player.func_71007_a((IInventory)inventoryField);
            }
        }
        return null;
    }

    private static enum InventoryType {
        INVENTORY_CITIZEN,
        INVENTORY_CHEST,
        INVENTORY_FIELD;

    }
}

