/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.ColonyView;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleJobMessage
implements IMessage,
IMessageHandler<ToggleJobMessage, IMessage> {
    private int colonyId;
    private boolean toggle;

    public ToggleJobMessage() {
    }

    public ToggleJobMessage(@NotNull ColonyView colony, boolean toggle) {
        this.colonyId = colony.getID();
        this.toggle = toggle;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.toggle = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeBoolean(this.toggle);
    }

    @Nullable
    public IMessage onMessage(@NotNull ToggleJobMessage message, MessageContext ctx) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            colony.setManualHiring(message.toggle);
        }
        return null;
    }
}

