/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.proxy;

import com.minecolonies.MineColonies;
import com.minecolonies.colony.CitizenDataView;
import com.minecolonies.entity.EntityCitizen;
import com.minecolonies.entity.EntityFishHook;
import com.minecolonies.event.EventHandler;
import com.minecolonies.event.FMLEventHandler;
import com.minecolonies.inventory.GuiHandler;
import com.minecolonies.proxy.IProxy;
import com.minecolonies.sounds.ModSoundEvents;
import com.minecolonies.tileentities.ScarecrowTileEntity;
import com.minecolonies.tileentities.TileEntityColonyBuilding;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommonProxy
implements IProxy {
    private static final Map<String, NBTTagCompound> playerPropertiesData = new HashMap<String, NBTTagCompound>();
    private int nextEntityId = 0;

    public static void storeEntityData(String name, NBTTagCompound compound) {
        playerPropertiesData.put(name, compound);
    }

    public static NBTTagCompound getEntityData(String name) {
        return playerPropertiesData.remove(name);
    }

    @Override
    public void registerSounds() {
        ModSoundEvents.registerSounds();
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityColonyBuilding.class, (String)"minecolonies.ColonyBuilding");
        GameRegistry.registerTileEntity(ScarecrowTileEntity.class, (String)"minecolonies.Scarecrow");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)MineColonies.instance, (IGuiHandler)new GuiHandler());
    }

    @Override
    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FMLEventHandler());
    }

    @Override
    public void registerEntities() {
        EntityRegistry.registerModEntity(EntityCitizen.class, (String)"Citizen", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)256, (int)2, (boolean)true);
        EntityRegistry.registerModEntity(EntityFishHook.class, (String)"Fishhook", (int)this.getNextEntityId(), (Object)MineColonies.instance, (int)250, (int)5, (boolean)true);
    }

    @Override
    public void registerEntityRendering() {
    }

    @Override
    public void registerTileEntityRendering() {
    }

    @Override
    public void showCitizenWindow(CitizenDataView citizen) {
    }

    @Override
    public void openBuildToolWindow(BlockPos pos) {
    }

    @Override
    public void registerRenderer() {
    }

    private int getNextEntityId() {
        return this.nextEntityId++;
    }
}

