/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.util;

import com.minecolonies.blocks.AbstractBlockHut;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPurpurSlab;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockStoneSlabNew;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockUtils {
    @NotNull
    private static List<BiPredicate<Block, IBlockState>> freeToPlaceBlocks = Arrays.asList((block, iBlockState) -> block.equals(Blocks.field_150350_a), (block, iBlockState) -> iBlockState.func_185904_a().func_76224_d(), (block, iBlockState) -> BlockUtils.isWater(block.func_176223_P()), (block, iBlockState) -> block.equals(Blocks.field_150362_t), (block, iBlockState) -> block.equals(Blocks.field_150361_u), (block, iBlockState) -> block.equals(Blocks.field_150398_cm), (block, iBlockState) -> block.equals(Blocks.field_150349_c), (block, iBlockState) -> block instanceof BlockDoor && iBlockState != null && (Boolean)iBlockState.func_177229_b((IProperty)PropertyBool.func_177716_a((String)"upper")) != false);

    private BlockUtils() {
    }

    public static boolean shouldNeverBeMessedWith(Block block) {
        return block instanceof AbstractBlockHut || Objects.equals(block, Blocks.field_150357_h);
    }

    public static boolean freeToPlace(Block block) {
        return BlockUtils.freeToPlace(block, null);
    }

    public static boolean freeToPlace(@Nullable Block block, IBlockState blockState) {
        if (block == null) {
            return true;
        }
        for (BiPredicate<Block, IBlockState> predicate : freeToPlaceBlocks) {
            if (!predicate.test(block, blockState)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWater(IBlockState iBlockState) {
        return Objects.equals(iBlockState, Blocks.field_150355_j.func_176223_P()) || Objects.equals(iBlockState, Blocks.field_150358_i.func_176223_P());
    }

    public static boolean isBlockSeed(@NotNull World world, @NotNull BlockPos pos) {
        return BlockUtils.getItemStackFromBlockState(world.func_180495_p(pos.func_177984_a())) != null && BlockUtils.getItemStackFromBlockState(world.func_180495_p(pos.func_177984_a())).func_77973_b() instanceof ItemSeeds;
    }

    public static ItemStack getItemStackFromBlockState(@NotNull IBlockState blockState) {
        Item item = BlockUtils.getItem(blockState);
        if (item == null) {
            return null;
        }
        Block block = blockState.func_177230_c();
        if (item instanceof ItemBlock) {
            block = Block.func_149634_a((Item)item);
        }
        return new ItemStack(item, 1, BlockUtils.getDamageValue(block, blockState));
    }

    private static Item getItem(@NotNull IBlockState blockState) {
        if (blockState.func_177230_c() instanceof BlockBanner) {
            return Items.field_179564_cE;
        }
        if (blockState.func_177230_c() instanceof BlockBed) {
            return Items.field_151104_aV;
        }
        if (blockState.func_177230_c() instanceof BlockBrewingStand) {
            return Items.field_151067_bt;
        }
        if (blockState.func_177230_c() instanceof BlockCake) {
            return Items.field_151105_aU;
        }
        if (blockState.func_177230_c() instanceof BlockCauldron) {
            return Items.field_151066_bu;
        }
        if (blockState.func_177230_c() instanceof BlockCocoa) {
            return Items.field_151100_aR;
        }
        if (blockState.func_177230_c() instanceof BlockCrops) {
            ItemStack stack = ((BlockCrops)blockState.func_177230_c()).func_185473_a(null, null, blockState);
            if (stack != null) {
                return stack.func_77973_b();
            }
            return Items.field_151014_N;
        }
        if (blockState.func_177230_c() instanceof BlockDaylightDetector) {
            return Item.func_150898_a((Block)Blocks.field_150453_bW);
        }
        if (blockState.func_177230_c() instanceof BlockDoor) {
            Item item = blockState.func_177230_c() == Blocks.field_150454_av ? Items.field_151139_aw : (blockState.func_177230_c() == Blocks.field_180414_ap ? Items.field_179569_ar : (blockState.func_177230_c() == Blocks.field_180412_aq ? Items.field_179568_as : (blockState.func_177230_c() == Blocks.field_180411_ar ? Items.field_179567_at : (blockState.func_177230_c() == Blocks.field_180410_as ? Items.field_179572_au : (blockState.func_177230_c() == Blocks.field_180409_at ? Items.field_179571_av : Items.field_179570_aq)))));
            return item == null ? Item.func_150898_a((Block)blockState.func_177230_c()) : item;
        }
        if (blockState.func_177230_c() instanceof BlockFarmland || blockState.func_177230_c() instanceof BlockGrassPath) {
            return Item.func_150898_a((Block)Blocks.field_150346_d);
        }
        if (blockState.func_177230_c() instanceof BlockFlowerPot) {
            return Items.field_151162_bE;
        }
        if (blockState.func_177230_c() instanceof BlockFurnace) {
            return Item.func_150898_a((Block)Blocks.field_150460_al);
        }
        if (blockState.func_177230_c() instanceof BlockHugeMushroom) {
            return blockState.func_177230_c().func_180660_a(null, null, 0);
        }
        if (blockState.func_177230_c() instanceof BlockNetherWart) {
            return Items.field_151075_bm;
        }
        if (blockState.func_177230_c() instanceof BlockPistonExtension) {
            return blockState.func_177229_b((IProperty)BlockPistonExtension.field_176325_b) == BlockPistonExtension.EnumPistonType.STICKY ? Item.func_150898_a((Block)Blocks.field_150320_F) : Item.func_150898_a((Block)Blocks.field_150331_J);
        }
        if (blockState.func_177230_c() instanceof BlockRedstoneComparator) {
            return Items.field_151132_bS;
        }
        if (blockState.func_177230_c() instanceof BlockRedstoneLight) {
            return Item.func_150898_a((Block)Blocks.field_150379_bu);
        }
        if (blockState.func_177230_c() instanceof BlockRedstoneRepeater) {
            return Items.field_151107_aW;
        }
        if (blockState.func_177230_c() instanceof BlockRedstoneTorch) {
            return Item.func_150898_a((Block)Blocks.field_150429_aA);
        }
        if (blockState.func_177230_c() instanceof BlockRedstoneWire) {
            return Items.field_151137_ax;
        }
        if (blockState.func_177230_c() instanceof BlockReed) {
            return Items.field_151120_aE;
        }
        if (blockState.func_177230_c() instanceof BlockSign) {
            return Items.field_151155_ap;
        }
        if (blockState.func_177230_c() instanceof BlockSkull) {
            return Items.field_151144_bL;
        }
        if (blockState.func_177230_c() instanceof BlockStem) {
            ItemStack stack = ((BlockStem)blockState.func_177230_c()).func_185473_a(null, null, blockState);
            if (stack != null) {
                return stack.func_77973_b();
            }
            return Items.field_151081_bc;
        }
        if (blockState.func_177230_c() instanceof BlockStoneSlab) {
            return Item.func_150898_a((Block)Blocks.field_150333_U);
        }
        if (blockState.func_177230_c() instanceof BlockPurpurSlab) {
            return Item.func_150898_a((Block)Blocks.field_185771_cX);
        }
        if (blockState.func_177230_c() instanceof BlockStoneSlabNew) {
            return Item.func_150898_a((Block)Blocks.field_180389_cP);
        }
        if (blockState.func_177230_c() instanceof BlockTripWire) {
            return Items.field_151007_F;
        }
        if (blockState.func_177230_c() instanceof BlockWoodSlab) {
            return Item.func_150898_a((Block)Blocks.field_150376_bx);
        }
        return Item.func_150898_a((Block)blockState.func_177230_c());
    }

    private static int getDamageValue(Block block, @NotNull IBlockState blockState) {
        if (block instanceof BlockCocoa) {
            return EnumDyeColor.BROWN.func_176767_b();
        }
        if (block instanceof BlockDirt) {
            return ((BlockDirt.DirtType)blockState.func_177229_b((IProperty)BlockDirt.field_176386_a)).func_176925_a();
        }
        if (block instanceof BlockDoublePlant && blockState.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.LOWER) {
            return ((BlockDoublePlant.EnumPlantType)blockState.func_177229_b((IProperty)BlockDoublePlant.field_176493_a)).func_176936_a();
        }
        if (block instanceof BlockNewLeaf) {
            return block.func_176201_c(blockState) & 3;
        }
        if (block instanceof BlockOre) {
            return 0;
        }
        if (block instanceof BlockSilverfish || block instanceof BlockTallGrass) {
            return block.func_176201_c(blockState);
        }
        if (block instanceof BlockSlab) {
            return block.func_180651_a(blockState) & 7;
        }
        return block.func_180651_a(blockState);
    }
}

