/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.util;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageHandler {
    public static void sendPlayerLocalizedMessage(@NotNull EntityPlayer player, String key, Object ... args) {
        LanguageHandler.sendPlayerMessage(player, LanguageHandler.format(key, args));
    }

    public static void sendPlayerMessage(@NotNull EntityPlayer player, String message) {
        player.func_146105_b((ITextComponent)new TextComponentString(message));
    }

    public static String format(String key, Object ... args) {
        return String.format(LanguageHandler.getString(key), args);
    }

    public static String getString(String key) {
        return LanguageHandler.getString(key, key);
    }

    public static String getString(String key, String defaultValue) {
        return I18n.func_74838_a((String)key);
    }

    public static void sendPlayersLocalizedMessage(List<EntityPlayer> players, String key, Object ... args) {
        LanguageHandler.sendPlayersMessage(players, LanguageHandler.format(key, args));
    }

    public static void sendPlayersMessage(@Nullable List<EntityPlayer> players, String message) {
        if (players == null || players.isEmpty()) {
            return;
        }
        for (EntityPlayer player : players) {
            LanguageHandler.sendPlayerMessage(player, message);
        }
    }
}

