/*
 * Decompiled with CFR 0.152.
 */
package com.schematica.client.renderer;

import com.schematica.client.renderer.chunk.overlay.ISchematicRenderChunkFactory;
import com.schematica.client.renderer.chunk.overlay.RenderOverlay;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.chunk.IRenderChunkFactory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
class ViewFrustumOverlay
extends ViewFrustum {
    private RenderOverlay[] renderOverlays;

    ViewFrustumOverlay(World world, int renderDistanceChunks, RenderGlobal renderGlobal, ISchematicRenderChunkFactory renderChunkFactory) {
        super(world, renderDistanceChunks, renderGlobal, (IRenderChunkFactory)renderChunkFactory);
        this.createRenderOverlays(renderChunkFactory);
    }

    private void createRenderOverlays(ISchematicRenderChunkFactory renderChunkFactory) {
        int amount = this.field_178165_d * this.field_178168_c * this.field_178166_e;
        this.renderOverlays = new RenderOverlay[amount];
        int count = 0;
        for (int x = 0; x < this.field_178165_d; ++x) {
            for (int y = 0; y < this.field_178168_c; ++y) {
                for (int z = 0; z < this.field_178166_e; ++z) {
                    int index = (z * this.field_178168_c + y) * this.field_178165_d + x;
                    BlockPos pos = new BlockPos(x * 16, y * 16, z * 16);
                    this.renderOverlays[index] = renderChunkFactory.makeRenderOverlay(this.field_178167_b, this.field_178169_a, pos, count++);
                }
            }
        }
    }

    public void func_178160_a() {
        super.func_178160_a();
        for (RenderOverlay renderOverlay : this.renderOverlays) {
            renderOverlay.func_178566_a();
        }
    }

    public void func_178163_a(double viewEntityX, double viewEntityZ) {
        super.func_178163_a(viewEntityX, viewEntityZ);
        int xx = MathHelper.func_76128_c((double)viewEntityX) - 8;
        int zz = MathHelper.func_76128_c((double)viewEntityZ) - 8;
        int yy = this.field_178165_d * 16;
        for (int chunkX = 0; chunkX < this.field_178165_d; ++chunkX) {
            int x = this.getPosition(xx, yy, chunkX);
            for (int chunkZ = 0; chunkZ < this.field_178166_e; ++chunkZ) {
                int z = this.getPosition(zz, yy, chunkZ);
                for (int chunkY = 0; chunkY < this.field_178168_c; ++chunkY) {
                    int y = chunkY * 16;
                    BlockPos blockpos = new BlockPos(x, y, z);
                    RenderOverlay renderOverlay = this.renderOverlays[(chunkZ * this.field_178168_c + chunkY) * this.field_178165_d + chunkX];
                    if (blockpos.equals((Object)renderOverlay.func_178568_j())) continue;
                    renderOverlay.func_189562_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
                }
            }
        }
    }

    private int getPosition(int xz, int y, int chunk) {
        int chunks = chunk * 16;
        int i = chunks - xz + y / 2;
        if (i < 0) {
            i -= y - 1;
        }
        return chunks - i / y * y;
    }

    public void func_187474_a(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, boolean needsUpdate) {
        super.func_187474_a(fromX, fromY, fromZ, toX, toY, toZ, needsUpdate);
        int x0 = MathHelper.func_76137_a((int)fromX, (int)16);
        int y0 = MathHelper.func_76137_a((int)fromY, (int)16);
        int z0 = MathHelper.func_76137_a((int)fromZ, (int)16);
        int x1 = MathHelper.func_76137_a((int)toX, (int)16);
        int y1 = MathHelper.func_76137_a((int)toY, (int)16);
        int z1 = MathHelper.func_76137_a((int)toZ, (int)16);
        for (int xi = x0; xi <= x1; ++xi) {
            int x = xi % this.field_178165_d;
            if (x < 0) {
                x += this.field_178165_d;
            }
            for (int yi = y0; yi <= y1; ++yi) {
                int y = yi % this.field_178168_c;
                if (y < 0) {
                    y += this.field_178168_c;
                }
                for (int zi = z0; zi <= z1; ++zi) {
                    int z = zi % this.field_178166_e;
                    if (z < 0) {
                        z += this.field_178166_e;
                    }
                    int index = (z * this.field_178168_c + y) * this.field_178165_d + x;
                    RenderOverlay renderOverlay = this.renderOverlays[index];
                    renderOverlay.func_178575_a(true);
                }
            }
        }
    }

    RenderOverlay getRenderOverlay(BlockPos pos) {
        int x = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
        int y = MathHelper.func_76137_a((int)pos.func_177956_o(), (int)16);
        int z = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16);
        if (y >= 0 && y < this.field_178168_c) {
            if ((x %= this.field_178165_d) < 0) {
                x += this.field_178165_d;
            }
            if ((z %= this.field_178166_e) < 0) {
                z += this.field_178166_e;
            }
            int index = (z * this.field_178168_c + y) * this.field_178165_d + x;
            return this.renderOverlays[index];
        }
        return null;
    }
}

