/*
 * Decompiled with CFR 0.152.
 */
package com.schematica.client.renderer.shader;

import com.schematica.reference.Reference;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class ShaderProgram {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    private static final int PROGRAM_INFO_CONST = 1024;
    private int program;

    public ShaderProgram(String domain, String vertShaderFilename, String fragShaderFilename) {
        try {
            this.init(domain, vertShaderFilename, fragShaderFilename);
            if (this.program > 0) {
                GL20.glUseProgram((int)this.program);
                GL20.glUniform1i((int)GL20.glGetUniformLocation((int)this.program, (CharSequence)"texture"), (int)0);
                GL20.glUseProgram((int)0);
            }
        }
        catch (RuntimeException e) {
            Reference.logger.error("Could not initialize shader program!", (Throwable)e);
            this.program = 0;
        }
    }

    private void init(String domain, String vertShaderFilename, String fragShaderFilename) {
        if (!OpenGlHelper.field_148824_g) {
            this.program = 0;
            return;
        }
        this.program = GL20.glCreateProgram();
        int vertShader = this.loadAndCompileShader(domain, vertShaderFilename, 35633);
        int fragShader = this.loadAndCompileShader(domain, fragShaderFilename, 35632);
        if (vertShader != 0) {
            GL20.glAttachShader((int)this.program, (int)vertShader);
        }
        if (fragShader != 0) {
            GL20.glAttachShader((int)this.program, (int)fragShader);
        }
        GL20.glLinkProgram((int)this.program);
        if (GL20.glGetProgrami((int)this.program, (int)35714) == 0) {
            Reference.logger.error("Could not link shader: {}", new Object[]{GL20.glGetProgramInfoLog((int)this.program, (int)1024)});
            GL20.glDeleteProgram((int)this.program);
            this.program = 0;
            return;
        }
        GL20.glValidateProgram((int)this.program);
        if (GL20.glGetProgrami((int)this.program, (int)35715) == 0) {
            Reference.logger.error("Could not validate shader: {}", new Object[]{GL20.glGetProgramInfoLog((int)this.program, (int)1024)});
            GL20.glDeleteProgram((int)this.program);
            this.program = 0;
        }
    }

    private int loadAndCompileShader(String domain, String filename, int shaderType) {
        if (filename == null) {
            return 0;
        }
        int handle = GL20.glCreateShader((int)shaderType);
        if (handle == 0) {
            Reference.logger.error("Could not create shader of type {} for {}: {}", new Object[]{shaderType, filename, GL20.glGetProgramInfoLog((int)this.program, (int)1024)});
            return 0;
        }
        String code = ShaderProgram.loadFile(new ResourceLocation(domain, filename));
        if (code == null) {
            GL20.glDeleteShader((int)handle);
            return 0;
        }
        GL20.glShaderSource((int)handle, (CharSequence)code);
        GL20.glCompileShader((int)handle);
        if (GL20.glGetShaderi((int)handle, (int)35713) == 0) {
            Reference.logger.error("Could not compile shader {}: {}", new Object[]{filename, GL20.glGetShaderInfoLog((int)this.program, (int)1024)});
            GL20.glDeleteShader((int)handle);
            return 0;
        }
        return handle;
    }

    private static String loadFile(ResourceLocation resourceLocation) {
        try {
            String line;
            StringBuilder code = new StringBuilder();
            InputStream inputStream = MINECRAFT.func_110442_L().func_110536_a(resourceLocation).func_110527_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                code.append(line);
                code.append('\n');
            }
            reader.close();
            return code.toString();
        }
        catch (IOException e) {
            Reference.logger.error("Could not load shader file!", (Throwable)e);
            return null;
        }
    }

    public int getProgram() {
        return this.program;
    }
}

