/*
 * Decompiled with CFR 0.152.
 */
package com.schematica.world.schematic;

import com.schematica.reference.Reference;
import com.schematica.world.schematic.SchematicAlpha;
import com.schematica.world.schematic.UnsupportedFormatException;
import com.schematica.world.storage.Schematic;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class SchematicFormat {
    private static final Map<String, SchematicFormat> FORMATS = new HashMap<String, SchematicFormat>();
    private static final String FORMAT_DEFAULT;

    public static Schematic readFromStream(InputStream stream) {
        try {
            NBTTagCompound tagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
            String format = tagCompound.func_74779_i("Materials");
            SchematicFormat schematicFormat = FORMATS.get(format);
            if (schematicFormat == null) {
                throw new UnsupportedFormatException(format);
            }
            return schematicFormat.readFromNBT(tagCompound);
        }
        catch (UnsupportedFormatException | IOException ex) {
            throw new IllegalStateException("Failed to read schematic!", ex);
        }
    }

    protected abstract Schematic readFromNBT(NBTTagCompound var1);

    public static boolean writeToFile(File file, Schematic schematic) {
        try {
            NBTTagCompound tagCompound = new NBTTagCompound();
            FORMATS.get(FORMAT_DEFAULT).writeToNBT(tagCompound, schematic);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                 GZIPOutputStream gzipOutputStream = new GZIPOutputStream(fileOutputStream);
                 DataOutputStream dataOutputStream = new DataOutputStream(gzipOutputStream);){
                NBTTagCompound.func_150298_a((String)"Schematic", (NBTBase)tagCompound, (DataOutput)dataOutputStream);
            }
            return true;
        }
        catch (IOException ex) {
            Reference.logger.error("Failed to write schematic!", (Throwable)ex);
            return false;
        }
    }

    protected abstract void writeToNBT(NBTTagCompound var1, Schematic var2);

    static {
        FORMATS.put("Alpha", new SchematicAlpha());
        FORMAT_DEFAULT = "Alpha";
    }
}

