/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.blocks;

import com.minecolonies.MineColonies;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.creativetab.ModCreativeTabs;
import com.minecolonies.inventory.InventoryField;
import com.minecolonies.tileentities.ScarecrowTileEntity;
import com.minecolonies.util.LanguageHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockHutField
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final float HARDNESS = 10.0f;
    private static final float RESISTANCE = 10.0f;
    private static final double BOTTOM_COLLISION = 0.0;
    private static final double START_COLLISION = 0.1;
    private static final double END_COLLISION = 0.9;
    private static final double HEIGHT_COLLISION = 2.5;
    private static final String REGISTRY_NAME = "blockHutField";

    BlockHutField() {
        super(Material.field_151575_d);
        this.initBlock();
    }

    private void initBlock() {
        this.setRegistryName(REGISTRY_NAME);
        this.func_149663_c("minecolonies".toLowerCase() + "." + REGISTRY_NAME);
        this.func_149647_a(ModCreativeTabs.MINECOLONIES);
        this.func_149752_b(10.0f);
        this.func_149711_c(10.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public int func_176201_c(@NotNull IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, 2.5, (double)0.9f);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        Colony colony;
        if (!worldIn.field_72995_K && (colony = ColonyManager.getColony(worldIn, pos)) != null) {
            playerIn.openGui((Object)MineColonies.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nullable EntityLivingBase placer) {
        EnumFacing enumFacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumFacing);
    }

    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        Colony colony;
        if (worldIn.field_72995_K) {
            return;
        }
        if (placer instanceof EntityPlayer && (colony = ColonyManager.getColony(worldIn, pos)) != null) {
            InventoryField inventoryField = new InventoryField(LanguageHandler.getString("com.minecolonies.gui.inventory.scarecrow"));
            ((ScarecrowTileEntity)worldIn.func_175625_s(pos)).setInventoryField(inventoryField);
            colony.addNewField((ScarecrowTileEntity)worldIn.func_175625_s(pos), ((EntityPlayer)placer).field_71071_by, pos, worldIn);
        }
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @NotNull
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new ScarecrowTileEntity();
    }
}

