/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.citizen.farmer;

import com.minecolonies.blocks.BlockHutField;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.buildings.BuildingFarmer;
import com.minecolonies.colony.jobs.JobFarmer;
import com.minecolonies.entity.EntityCitizen;
import com.minecolonies.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.entity.ai.citizen.farmer.Field;
import com.minecolonies.entity.ai.util.AIState;
import com.minecolonies.entity.ai.util.AITarget;
import com.minecolonies.util.BlockUtils;
import com.minecolonies.util.InventoryUtils;
import com.minecolonies.util.Utils;
import java.util.List;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFarmer
extends AbstractEntityAIInteract<JobFarmer> {
    private static final int STANDARD_DELAY = 20;
    private static final int DELAY_DIVIDER = 10;
    private static final double XP_PER_HARVEST = 0.5;
    private boolean shouldDumpInventory = false;
    @Nullable
    private BlockPos workingOffset;
    private boolean requestSeeds = true;
    private boolean shouldTryToGetSeed = true;

    public EntityAIWorkFarmer(@NotNull JobFarmer job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, () -> AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget(AIState.PREPARING, this::prepareForFarming), new AITarget(AIState.FARMER_WORK, this::cycle));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getEndurance() + this.worker.getCitizenData().getCharisma());
        this.worker.func_98053_h(true);
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.PREPARING;
    }

    @NotNull
    private AIState prepareForFarming() {
        BuildingFarmer building = this.getOwnBuilding();
        if (building == null || building.getBuildingLevel() < 1) {
            return AIState.PREPARING;
        }
        building.syncWithColony(this.world);
        if (building.getFarmerFields().size() < this.getOwnBuilding().getBuildingLevel() && !building.assignManually()) {
            this.searchAndAddFields();
        }
        if (building.hasNoFields()) {
            this.chatSpamFilter.talkWithoutSpam("entity.farmer.noFreeFields", new String[0]);
            return AIState.PREPARING;
        }
        if (building.getCurrentField() == null && building.getFieldToWorkOn() == null) {
            building.resetFields();
            return AIState.IDLE;
        }
        Field currentField = building.getCurrentField();
        if (currentField.needsWork()) {
            if (!this.checkForHoe() && this.canGoPlanting(currentField, building)) {
                return this.walkToBlock(currentField.getLocation()) ? AIState.PREPARING : AIState.FARMER_WORK;
            }
        } else {
            this.getOwnBuilding().setCurrentField(null);
        }
        return AIState.PREPARING;
    }

    private void searchAndAddFields() {
        Field newField;
        Colony colony = this.worker.getColony();
        if (colony != null && (newField = colony.getFreeField(this.worker.func_70005_c_())) != null && this.getOwnBuilding() != null) {
            this.getOwnBuilding().addFarmerFields(newField);
        }
    }

    private boolean canGoPlanting(@NotNull Field currentField, @NotNull BuildingFarmer buildingFarmer) {
        if (currentField.getSeed() == null) {
            this.chatSpamFilter.talkWithoutSpam("entity.farmer.noSeedSet", new String[0]);
            buildingFarmer.setCurrentField(null);
            return false;
        }
        if (this.shouldTryToGetSeed) {
            int slot = this.worker.findFirstSlotInInventoryWith(currentField.getSeed());
            if (slot != -1) {
                this.requestSeeds = false;
            }
            if (!this.walkToBuilding()) {
                if (this.isInHut(new ItemStack(currentField.getSeed()))) {
                    this.requestSeeds = false;
                }
                this.shouldTryToGetSeed = this.requestSeeds;
            }
        }
        return !this.shouldTryToGetSeed;
    }

    private AIState cycle() {
        BuildingFarmer buildingFarmer = this.getOwnBuilding();
        if (buildingFarmer == null || this.checkForHoe()) {
            return AIState.PREPARING;
        }
        Field field = buildingFarmer.getCurrentField();
        if (field == null) {
            return AIState.PREPARING;
        }
        if (this.workingOffset != null) {
            BlockPos position = field.getLocation().func_177977_b().func_177970_e(this.workingOffset.func_177952_p()).func_177965_g(this.workingOffset.func_177958_n());
            if (this.walkToBlock(position.func_177984_a())) {
                return AIState.FARMER_WORK;
            }
            this.harvestIfAble(position);
            this.hoeIfAble(position, field);
            if (this.shouldPlant(position, field) && !this.plantCrop(field.getSeed(), position)) {
                this.resetVariables();
                buildingFarmer.getCurrentField().setNeedsWork(false);
                return this.terminatePlanting(buildingFarmer, field);
            }
        }
        if (!this.handleOffset(field)) {
            this.resetVariables();
            buildingFarmer.getCurrentField().setNeedsWork(false);
            return AIState.IDLE;
        }
        this.setDelay(20 - this.worker.getLevel() / 10);
        return AIState.FARMER_WORK;
    }

    private void harvestIfAble(BlockPos position) {
        if (this.shouldHarvest(position)) {
            this.worker.addExperience(0.5);
            this.harvestCrop(position.func_177984_a());
        }
    }

    private void hoeIfAble(BlockPos position, Field field) {
        if (this.shouldHoe(position, field)) {
            this.equipHoe();
            this.worker.func_184609_a(this.worker.func_184600_cs());
            this.world.func_175656_a(position, Blocks.field_150458_ak.func_176223_P());
            this.worker.damageItemInHand(1);
            this.mineBlock(position.func_177984_a());
        }
    }

    private boolean shouldPlant(@NotNull BlockPos position, @NotNull Field field) {
        ItemStack itemStack = BlockUtils.getItemStackFromBlockState(this.world.func_180495_p(position.func_177984_a()));
        if (itemStack != null && itemStack.func_77973_b() == field.getSeed()) {
            this.requestSeeds = false;
        }
        return !field.isNoPartOfField(this.world, position) && !(this.world.func_180495_p(position.func_177984_a()).func_177230_c() instanceof BlockCrops) && !(this.world.func_180495_p(position).func_177230_c() instanceof BlockHutField) && this.world.func_180495_p(position).func_177230_c() == Blocks.field_150458_ak;
    }

    private boolean plantCrop(Item item, @NotNull BlockPos position) {
        int slot = this.worker.findFirstSlotInInventoryWith(item);
        if (slot == -1) {
            return false;
        }
        IPlantable seed = (IPlantable)item;
        this.world.func_175656_a(position.func_177984_a(), seed.getPlant((IBlockAccess)this.world, position));
        this.getInventory().func_70298_a(slot, 1);
        this.requestSeeds = false;
        return true;
    }

    private void resetVariables() {
        this.requestSeeds = true;
        this.shouldDumpInventory = true;
        this.shouldTryToGetSeed = true;
    }

    @NotNull
    private AIState terminatePlanting(@NotNull BuildingFarmer buildingFarmer, @NotNull Field field) {
        if (this.requestSeeds) {
            this.chatSpamFilter.talkWithoutSpam("entity.farmer.NeedSeed", field.getSeed().func_77653_i(new ItemStack(field.getSeed())));
        } else {
            buildingFarmer.getCurrentField().setNeedsWork(false);
        }
        this.resetVariables();
        return AIState.PREPARING;
    }

    private boolean handleOffset(@NotNull Field field) {
        if (this.workingOffset == null) {
            this.workingOffset = new BlockPos(field.getLengthPlusX(), 0, field.getWidthPlusZ());
        } else {
            if (this.workingOffset.func_177952_p() <= -field.getWidthMinusZ() && this.workingOffset.func_177958_n() <= -field.getLengthMinusX()) {
                this.workingOffset = null;
                return false;
            }
            this.workingOffset = this.workingOffset.func_177958_n() <= -field.getLengthMinusX() ? new BlockPos(field.getLengthPlusX(), 0, this.workingOffset.func_177952_p() - 1) : new BlockPos(this.workingOffset.func_177958_n() - 1, 0, this.workingOffset.func_177952_p());
        }
        return true;
    }

    private boolean shouldHarvest(@NotNull BlockPos position) {
        IBlockState state = this.world.func_180495_p(position.func_177984_a());
        if (state.func_177230_c() instanceof IGrowable && state.func_177230_c() instanceof BlockCrops) {
            BlockCrops block = (BlockCrops)state.func_177230_c();
            return !block.func_176473_a(this.world, position.func_177984_a(), state, false);
        }
        return false;
    }

    private boolean harvestCrop(BlockPos position) {
        IBlockState curBlockState = this.world.func_180495_p(position);
        if (!(curBlockState.func_177230_c() instanceof IGrowable) || !(curBlockState.func_177230_c() instanceof BlockCrops)) {
            return false;
        }
        BlockCrops crops = (BlockCrops)curBlockState.func_177230_c();
        if (!crops.func_185525_y(curBlockState)) {
            return false;
        }
        ItemStack tool = this.worker.func_184614_ca();
        int fortune = Utils.getFortuneOf(tool);
        List drops = crops.getDrops((IBlockAccess)this.world, position, curBlockState, fortune);
        this.world.func_175656_a(position, crops.func_185528_e(0));
        for (ItemStack item : drops) {
            InventoryUtils.setStack(this.worker.getInventoryCitizen(), item);
        }
        this.incrementActionsDone();
        return true;
    }

    private boolean shouldHoe(@NotNull BlockPos position, @NotNull Field field) {
        return !field.isNoPartOfField(this.world, position) && !BlockUtils.isBlockSeed(this.world, position.func_177984_a()) && !(this.world.func_180495_p(position).func_177230_c() instanceof BlockHutField) && (this.world.func_180495_p(position).func_177230_c() == Blocks.field_150346_d || this.world.func_180495_p(position).func_177230_c() == Blocks.field_150349_c);
    }

    private void equipHoe() {
        this.worker.setHeldItem(this.getHoeSlot());
    }

    private int getHoeSlot() {
        return InventoryUtils.getFirstSlotContainingTool(this.getInventory(), "hoe");
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory) {
            this.shouldDumpInventory = false;
            return true;
        }
        return false;
    }

    @Override
    protected BuildingFarmer getOwnBuilding() {
        return (BuildingFarmer)this.worker.getWorkBuilding();
    }

    @Override
    protected boolean neededForWorker(@Nullable ItemStack stack) {
        return stack != null && Utils.isHoe(stack);
    }

    @Nullable
    public EntityCitizen getCitizen() {
        return this.worker;
    }
}

