/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.citizen.lumberjack;

import com.minecolonies.colony.jobs.JobLumberjack;
import com.minecolonies.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.entity.ai.citizen.lumberjack.Tree;
import com.minecolonies.entity.ai.item.handling.ItemStorage;
import com.minecolonies.entity.ai.util.AIState;
import com.minecolonies.entity.ai.util.AITarget;
import com.minecolonies.entity.pathfinding.PathJobFindTree;
import com.minecolonies.util.BlockPosUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkLumberjack
extends AbstractEntityAIInteract<JobLumberjack> {
    private static final String TOOL_TYPE_AXE = "axe";
    private static final String RENDER_META_LOGS = "Logs";
    private static final int SEARCH_RANGE = 50;
    private static final int SEARCH_INCREMENT = 5;
    private static final int SEARCH_LIMIT = 150;
    private static final int STUCK_WAIT_TIME = 10;
    private static final int WALKING_BACK_WAIT_TIME = 60;
    private static final double WALK_BACK_RANGE = 3.0;
    private static final double WALK_BACK_SPEED = 1.0;
    private static final int WAIT_BEFORE_SAPLING = 50;
    private static final int MAX_WAITING_TIME = 500;
    private static final int SAPLINGS_TO_KEEP = 10;
    private static final int TIMEOUT_DELAY = 10;
    private static final int LEAVES_RADIUS = 3;
    private static final int ITEM_PICKUP_RANGE = 3;
    private static final int STUCK_WAIT_TICKS = 20;
    private static final int WAIT_BEFORE_SEARCH = 100;
    private static final int WAIT_BEFORE_INCREMENT = 20;
    private static final int WAIT_WHILE_WALKING = 5;
    private static final float RANGE_HORIZONTAL_PICKUP = 45.0f;
    private static final float RANGE_VERTICAL_PICKUP = 3.0f;
    private static final int STRENGTH_MULTIPLIER = 2;
    private static final int CHARISMA_MULTIPLIER = 1;
    private static final int MAX_BLOCKS_MINED = 32;
    private int timeWaited = 0;
    private int stillTicks = 0;
    private int previousDistance = 0;
    private int previousIndex = 0;
    @Nullable
    private List<BlockPos> items;
    @Nullable
    private PathJobFindTree.TreePathResult pathResult;
    private int searchIncrement = 0;

    public EntityAIWorkLumberjack(@NotNull JobLumberjack job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget(AIState.PREPARING, this::prepareForWoodcutting), new AITarget(AIState.LUMBERJACK_SEARCHING_TREE, this::findTrees), new AITarget(AIState.LUMBERJACK_CHOP_TREE, this::chopWood), new AITarget(AIState.LUMBERJACK_GATHERING, this::gathering), new AITarget(AIState.LUMBERJACK_NO_TREES_FOUND, this::waitBeforeCheckingAgain));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getStrength() + 1 * this.worker.getCitizenData().getCharisma());
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIState.PREPARING;
    }

    private AIState prepareForWoodcutting() {
        if (this.checkForAxe()) {
            return this.getState();
        }
        return AIState.LUMBERJACK_SEARCHING_TREE;
    }

    private AIState waitBeforeCheckingAgain() {
        if (this.hasNotDelayed(100)) {
            return this.getState();
        }
        return AIState.LUMBERJACK_SEARCHING_TREE;
    }

    private AIState findTrees() {
        if (((JobLumberjack)this.job).tree == null) {
            return this.findTree();
        }
        return AIState.LUMBERJACK_CHOP_TREE;
    }

    private AIState findTree() {
        if (this.pathResult == null || this.pathResult.treeLocation == null) {
            this.pathResult = this.worker.getNavigator().moveToTree(50 + this.searchIncrement, 1.0);
            return this.getState();
        }
        if (this.pathResult.getPathReachesDestination()) {
            return this.setNewTree();
        }
        if (this.pathResult.isCancelled()) {
            this.pathResult = null;
            return AIState.LUMBERJACK_GATHERING;
        }
        return this.getState();
    }

    private AIState setNewTree() {
        if (this.pathResult.treeLocation != null) {
            ((JobLumberjack)this.job).tree = new Tree(this.world, this.pathResult.treeLocation);
            ((JobLumberjack)this.job).tree.findLogs(this.world);
        } else {
            this.setDelay(20);
            if (this.searchIncrement + 50 > 150) {
                return AIState.LUMBERJACK_NO_TREES_FOUND;
            }
            this.searchIncrement += 5;
        }
        this.pathResult = null;
        return this.getState();
    }

    private AIState chopWood() {
        if (this.checkForAxe()) {
            return AIState.IDLE;
        }
        if (((JobLumberjack)this.job).tree == null) {
            return AIState.LUMBERJACK_SEARCHING_TREE;
        }
        return this.chopTree();
    }

    private AIState chopTree() {
        BlockPos location = ((JobLumberjack)this.job).tree.getLocation();
        if (this.walkToBlock(location)) {
            this.checkIfStuckOnLeaves(location);
            return this.getState();
        }
        if (!((JobLumberjack)this.job).tree.hasLogs()) {
            if (this.hasNotDelayed(50)) {
                return this.getState();
            }
            this.plantSapling();
            return AIState.LUMBERJACK_GATHERING;
        }
        BlockPos log = ((JobLumberjack)this.job).tree.peekNextLog();
        if (!this.mineBlock(log)) {
            return this.getState();
        }
        ((JobLumberjack)this.job).tree.pollNextLog();
        return this.getState();
    }

    private void checkIfStuckOnLeaves(@NotNull BlockPos location) {
        int distance = (int)location.func_177951_i((Vec3i)this.worker.func_180425_c());
        if (this.previousDistance != distance) {
            this.stillTicks = 0;
            this.previousDistance = distance;
            return;
        }
        ++this.stillTicks;
        if (this.stillTicks < 10) {
            return;
        }
        this.tryGettingUnstuckFromLeaves();
    }

    private void plantSapling() {
        if (this.plantSapling(((JobLumberjack)this.job).tree.getLocation())) {
            ((JobLumberjack)this.job).tree = null;
        }
    }

    private void tryGettingUnstuckFromLeaves() {
        BlockPos nextLeaves = this.findNearLeaves();
        if (nextLeaves == null || this.stillTicks > 60) {
            this.worker.getNavigator().moveAwayFromXYZ(this.worker.func_180425_c(), 3.0, 1.0);
            this.stillTicks = 0;
            return;
        }
        if (!this.mineBlock(nextLeaves)) {
            return;
        }
        this.stillTicks = 0;
    }

    private boolean plantSapling(@NotNull BlockPos location) {
        Block worldBlock = this.world.func_180495_p(location).func_177230_c();
        if (worldBlock != Blocks.field_150350_a && !(worldBlock instanceof BlockSapling)) {
            return false;
        }
        int saplingSlot = this.findSaplingSlot();
        if (saplingSlot != -1) {
            ItemStack stack = this.getInventory().func_70301_a(saplingSlot);
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            this.worker.setHeldItem(saplingSlot);
            this.placeSaplings(saplingSlot, stack, block);
            SoundType soundType = block.getSoundType(this.world.func_180495_p(location), this.world, location, (Entity)this.worker);
            this.world.func_184133_a(null, this.worker.func_180425_c(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b());
            this.worker.func_184609_a(this.worker.func_184600_cs());
        }
        if (((JobLumberjack)this.job).tree.getStumpLocations().isEmpty() || this.timeWaited >= 500) {
            this.timeWaited = 0;
            this.setDelay(10);
            return true;
        }
        ++this.timeWaited;
        return false;
    }

    private BlockPos findNearLeaves() {
        int playerX = this.worker.func_180425_c().func_177958_n();
        int playerY = this.worker.func_180425_c().func_177956_o() + 1;
        int playerZ = this.worker.func_180425_c().func_177952_p();
        int radius = 3;
        for (int x = playerX - radius; x < playerX + radius; ++x) {
            for (int y = playerY - radius; y < playerY + radius; ++y) {
                for (int z = playerZ - radius; z < playerZ + radius; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!this.world.func_180495_p(pos).func_177230_c().isLeaves(this.world.func_180495_p(pos), (IBlockAccess)this.world, pos)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private int findSaplingSlot() {
        for (int slot = 0; slot < this.getInventory().func_70302_i_(); ++slot) {
            ItemStack stack = this.getInventory().func_70301_a(slot);
            if (!this.isCorrectSapling(stack)) continue;
            return slot;
        }
        return -1;
    }

    private void placeSaplings(int saplingSlot, @NotNull ItemStack stack, @NotNull Block block) {
        while (!((JobLumberjack)this.job).tree.getStumpLocations().isEmpty()) {
            BlockPos pos = ((JobLumberjack)this.job).tree.getStumpLocations().get(0);
            if (BlockPosUtil.setBlock(this.world, pos, block.func_176203_a(stack.func_77960_j()), 2) && this.getInventory().func_70301_a(saplingSlot) != null || Objects.equals(this.world.func_180495_p(pos), block.func_176203_a(stack.func_77960_j()))) {
                this.getInventory().func_70298_a(saplingSlot, 1);
                ((JobLumberjack)this.job).tree.removeStump(pos);
                continue;
            }
            return;
        }
    }

    private boolean isCorrectSapling(ItemStack stack) {
        return EntityAIWorkLumberjack.isStackSapling(stack) && ((JobLumberjack)this.job).tree.getVariant() == ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j()).func_177229_b((IProperty)BlockSapling.field_176480_a);
    }

    private static boolean isStackSapling(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() instanceof BlockSapling;
    }

    private AIState gathering() {
        if (this.items == null) {
            this.searchForItems();
        }
        if (!this.items.isEmpty()) {
            this.gatherItems();
            return this.getState();
        }
        this.items = null;
        return AIState.LUMBERJACK_SEARCHING_TREE;
    }

    private void searchForItems() {
        this.items = new ArrayList<BlockPos>();
        this.items = this.world.func_72872_a(EntityItem.class, this.worker.func_174813_aQ().func_72314_b(45.0, 3.0, 45.0)).stream().filter(item -> item != null && !item.field_70128_L).map(BlockPosUtil::fromEntity).collect(Collectors.toList());
    }

    private void gatherItems() {
        this.worker.func_98053_h(true);
        if (this.worker.getNavigator().func_75500_f()) {
            BlockPos pos = this.getAndRemoveClosestItem();
            this.worker.isWorkerAtSiteWithMove(pos, 3);
            return;
        }
        if (this.worker.getNavigator().func_75505_d() == null) {
            this.setDelay(5);
            return;
        }
        int currentIndex = this.worker.getNavigator().func_75505_d().func_75873_e();
        if (currentIndex != this.previousIndex) {
            this.stillTicks = 0;
            this.previousIndex = currentIndex;
            return;
        }
        ++this.stillTicks;
        if (this.stillTicks > 20) {
            this.worker.getNavigator().func_75499_g();
        }
    }

    private BlockPos getAndRemoveClosestItem() {
        int index = 0;
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < this.items.size(); ++i) {
            double tempDistance = this.items.get(i).func_177951_i((Vec3i)this.worker.func_180425_c());
            if (!(tempDistance < distance)) continue;
            index = i;
            distance = tempDistance;
        }
        return this.items.remove(index);
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 32;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.hasLogs() ? RENDER_META_LOGS : "");
    }

    @Override
    protected Map<ItemStorage, Integer> needXForWorker() {
        HashMap<ItemStorage, Integer> keepX = new HashMap<ItemStorage, Integer>();
        ItemStack stack = new ItemStack(Blocks.field_150345_g);
        keepX.put(new ItemStorage(stack.func_77973_b(), stack.func_77952_i(), 0, false), 10);
        return keepX;
    }

    @Override
    protected boolean neededForWorker(@Nullable ItemStack stack) {
        return EntityAIWorkLumberjack.isStackAxe(stack);
    }

    private static boolean isStackAxe(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b().getToolClasses(stack).contains(TOOL_TYPE_AXE);
    }

    private boolean hasLogs() {
        for (int i = 0; i < this.getInventory().func_70302_i_(); ++i) {
            if (!EntityAIWorkLumberjack.isStackLog(this.getInventory().func_70301_a(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isStackLog(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d().isWood(null, new BlockPos(0, 0, 0));
    }
}

