/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.util;

import com.minecolonies.entity.ai.util.AIState;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AITarget {
    @Nullable
    private final AIState state;
    @NotNull
    private final BooleanSupplier predicate;
    @NotNull
    private final Supplier<AIState> action;

    public AITarget(@NotNull Supplier<AIState> action) {
        this(() -> true, action);
    }

    public AITarget(@NotNull BooleanSupplier predicate, @NotNull Supplier<AIState> action) {
        this(null, predicate, action);
    }

    public AITarget(@Nullable AIState state, @NotNull BooleanSupplier predicate, @NotNull Supplier<AIState> action) {
        this.state = state;
        this.predicate = predicate;
        this.action = action;
    }

    public AITarget(@NotNull BooleanSupplier predicate, @Nullable AIState state) {
        this(null, predicate, () -> state);
    }

    public AITarget(@NotNull AIState predicateState, @Nullable AIState state) {
        this(predicateState, () -> state);
    }

    public AITarget(@Nullable AIState state, @NotNull Supplier<AIState> action) {
        this(state, () -> true, action);
    }

    @Nullable
    public AIState getState() {
        return this.state;
    }

    public boolean test() {
        return this.predicate.getAsBoolean();
    }

    public AIState apply() {
        return this.action.get();
    }
}

