/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.network.messages.AbstractMessage;
import com.minecolonies.util.BlockPosUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildRequestMessage
extends AbstractMessage<BuildRequestMessage, IMessage> {
    public static final int BUILD = 0;
    public static final int REPAIR = 1;
    private BlockPos buildingId;
    private int colonyId;
    private int mode;

    public BuildRequestMessage() {
    }

    public BuildRequestMessage(@NotNull AbstractBuilding.View building, int mode) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.mode = mode;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.mode = buf.readInt();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.mode);
    }

    @Override
    public void messageOnServerThread(BuildRequestMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony == null) {
            return;
        }
        AbstractBuilding building = colony.getBuilding(message.buildingId);
        if (building == null) {
            return;
        }
        switch (message.mode) {
            case 0: {
                building.requestUpgrade();
                break;
            }
            case 1: {
                building.requestRepair();
                break;
            }
        }
    }
}

