/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.Schematics;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.permissions.Permissions;
import com.minecolonies.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.event.EventHandler;
import com.minecolonies.network.messages.AbstractMessage;
import com.minecolonies.util.LanguageHandler;
import com.minecolonies.util.Log;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildToolPlaceMessage
extends AbstractMessage<BuildToolPlaceMessage, IMessage> {
    private static final String NO_HUT_IN_INVENTORY = "com.minecolonies.gui.buildtool.nohutininventory";
    private String hutDec;
    private String style;
    private int rotation;
    private BlockPos pos;
    private boolean isHut;

    public BuildToolPlaceMessage() {
    }

    public BuildToolPlaceMessage(String hutDec, String style, BlockPos pos, int rotation, boolean isHut) {
        this.hutDec = hutDec;
        this.style = style;
        this.pos = pos;
        this.rotation = rotation;
        this.isHut = isHut;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.hutDec = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.style = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.rotation = buf.readInt();
        this.isHut = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.hutDec);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.style);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isHut);
    }

    @Override
    public void messageOnServerThread(BuildToolPlaceMessage message, EntityPlayerMP player) {
        World world = player.field_70170_p;
        if (message.isHut) {
            BuildToolPlaceMessage.handleHut(world, (EntityPlayer)player, message.hutDec, message.style, message.rotation, message.pos);
        } else {
            BuildToolPlaceMessage.handleDecoration(world, (EntityPlayer)player, message.hutDec, message.style, message.rotation, message.pos);
        }
    }

    private static void handleHut(@NotNull World world, @NotNull EntityPlayer player, String hut, String style, int rotation, @NotNull BlockPos buildPos) {
        if (Schematics.getStylesForHut(hut) == null) {
            Log.getLogger().error("No record of hut: " + hut);
            return;
        }
        Block block = Block.func_149684_b((String)("minecolonies:blockHut" + hut));
        if (player.field_71071_by.func_70431_c(new ItemStack(block))) {
            if (EventHandler.onBlockHutPlaced(world, player, block, buildPos)) {
                world.func_175655_b(buildPos, true);
                world.func_175656_a(buildPos, block.func_176223_P());
                block.func_180633_a(world, buildPos, world.func_180495_p(buildPos), (EntityLivingBase)player, null);
                player.field_71071_by.func_174925_a(Item.func_150898_a((Block)block), -1, 1, null);
                AbstractBuilding building = ColonyManager.getBuilding(world, buildPos);
                if (building == null) {
                    Log.getLogger().error("BuildTool: building is null!");
                } else {
                    if (building.getTileEntity() != null) {
                        Colony colony = ColonyManager.getColony(world, buildPos);
                        if (colony == null) {
                            Log.getLogger().info("No colony for " + player.func_70005_c_());
                        } else {
                            building.getTileEntity().setColony(colony);
                        }
                    }
                    building.setStyle(style);
                    building.setRotation(rotation);
                }
            }
        } else {
            LanguageHandler.sendPlayerLocalizedMessage(player, NO_HUT_IN_INVENTORY, new Object[0]);
        }
    }

    private static void handleDecoration(@NotNull World world, @NotNull EntityPlayer player, String decoration, String style, int rotation, @NotNull BlockPos buildPos) {
        if (Schematics.getStylesForDecoration(decoration) == null) {
            Log.getLogger().error("No record of decoration: " + decoration);
            return;
        }
        Colony colony = ColonyManager.getColony(world, buildPos);
        if (colony != null && colony.getPermissions().hasPermission(player, Permissions.Action.PLACE_HUTS)) {
            colony.getWorkManager().addWorkOrder(new WorkOrderBuildDecoration(decoration, style, rotation, buildPos));
        }
    }
}

