/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class ToggleJobMessage
extends AbstractMessage<ToggleJobMessage, IMessage> {
    private int colonyId;
    private boolean toggle;

    public ToggleJobMessage() {
    }

    public ToggleJobMessage(@NotNull ColonyView colony, boolean toggle) {
        this.colonyId = colony.getID();
        this.toggle = toggle;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.toggle = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeBoolean(this.toggle);
    }

    @Override
    public void messageOnServerThread(ToggleJobMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            colony.setManualHiring(message.toggle);
        }
    }
}

