/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.network.messages;

import com.minecolonies.MineColonies;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class TownHallRenameMessage
extends AbstractMessage<TownHallRenameMessage, IMessage> {
    private static final int MAX_NAME_LENGTH = 25;
    private static final int SUBSTRING_LENGTH = 24;
    private int colonyId;
    private String name;

    public TownHallRenameMessage() {
    }

    public TownHallRenameMessage(@NotNull ColonyView colony, String name) {
        this.colonyId = colony.getID();
        this.name = name.length() <= 25 ? name : name.substring(0, 24);
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
    }

    @Override
    public void messageOnServerThread(TownHallRenameMessage message, EntityPlayerMP player) {
        Colony colony = ColonyManager.getColony(message.colonyId);
        if (colony != null) {
            message.name = message.name.length() <= 25 ? message.name : message.name.substring(0, 24);
            colony.setName(message.name);
            MineColonies.getNetwork().sendToAll((IMessage)message);
        }
    }
}

