/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.blocks;

import com.google.common.base.Predicate;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.creativetab.ModCreativeTabs;
import com.minecolonies.tileentities.TileEntityColonyBuilding;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractBlockHut
extends Block
implements ITileEntityProvider {
    protected int workingRange;
    private static final float HARDNESS = 10.0f;
    private static final float RESISTANCE = Float.POSITIVE_INFINITY;
    private static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"FACING", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public AbstractBlockHut() {
        super(Material.field_151575_d);
        this.initBlock();
    }

    private void initBlock() {
        this.setRegistryName(this.getName());
        this.func_149663_c("minecolonies".toLowerCase() + "." + this.getName());
        this.func_149647_a(ModCreativeTabs.MINECOLONIES);
        this.func_149752_b(Float.POSITIVE_INFINITY);
        this.func_149711_c(10.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        GameRegistry.registerBlock((Block)this);
    }

    public abstract String getName();

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityColonyBuilding hut;
        Colony colony;
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (placer instanceof EntityPlayer && tileEntity instanceof TileEntityColonyBuilding && (colony = ColonyManager.getColony(worldIn, (hut = (TileEntityColonyBuilding)tileEntity).getPosition())) != null) {
            colony.addNewBuilding(hut);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        AbstractBuilding.View building;
        if (worldIn.field_72995_K && (building = ColonyManager.getBuildingView(pos)) != null) {
            building.openGui();
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityColonyBuilding();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumFacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumFacing);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.SOLID;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }
}

