/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.client.gui;

import com.blockout.controls.Button;
import com.blockout.controls.ButtonVanilla;
import com.blockout.views.SwitchView;
import com.minecolonies.MineColonies;
import com.minecolonies.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.colony.buildings.BuildingFarmer;
import com.minecolonies.network.messages.FarmerCropTypeMessage;
import com.minecolonies.util.Log;
import java.util.Random;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WindowHutFarmer
extends AbstractWindowWorkerBuilding<BuildingFarmer.View> {
    private static final String BUTTON_WHEAT = "wheat";
    private static final String BUTTON_POTATO = "potato";
    private static final String BUTTON_CARROT = "carrot";
    private static final String BUTTON_MELON = "melon";
    private static final String BUTTON_PUMPKIN = "pumpkin";
    private static final String WHEAT = "wheat";
    private static final String POTATO = "potato";
    private static final String CARROT = "carrot";
    private static final String MELON = "melon";
    private static final String PUMPKIN = "pumpkin";
    private static final String BUTTON_PREV_PAGE = "prevPage";
    private static final String BUTTON_NEXT_PAGE = "nextPage";
    private static final String VIEW_PAGES = "pages";
    private static final int MAX_AMOUNT = 100;
    private static final String HUT_FARMER_RESOURCE_SUFFIX = ":gui/windowHutFarmer.xml";
    private Button buttonPrevPage;
    private Button buttonNextPage;
    private Random random = new Random();

    public WindowHutFarmer(BuildingFarmer.View building) {
        super(building, "minecolonies:gui/windowHutFarmer.xml");
        this.registerButton("wheat", this::wheatClicked);
        this.registerButton("potato", this::potatoClicked);
        this.registerButton("melon", this::melonClicked);
        this.registerButton("pumpkin", this::pumpkinClicked);
        this.registerButton("carrot", this::carrotClicked);
        this.registerButton(BUTTON_PREV_PAGE, this::prevClicked);
        this.registerButton(BUTTON_NEXT_PAGE, this::nextClicked);
    }

    private void removeOthers(String s) {
        while (this.sum() > 100) {
            int numberOfProducts = 5;
            int rand = this.random.nextInt() * 5;
            if (((BuildingFarmer.View)this.building).potato != 0 && !s.equals("potato") && rand == 0) {
                --((BuildingFarmer.View)this.building).potato;
                continue;
            }
            if (((BuildingFarmer.View)this.building).wheat != 0 && !s.equals("wheat") && rand == 1) {
                --((BuildingFarmer.View)this.building).wheat;
                continue;
            }
            if (((BuildingFarmer.View)this.building).carrot != 0 && !s.equals("carrot") && rand == 2) {
                --((BuildingFarmer.View)this.building).carrot;
                continue;
            }
            if (((BuildingFarmer.View)this.building).melon != 0 && !s.equals("melon") && rand == 3) {
                --((BuildingFarmer.View)this.building).melon;
                continue;
            }
            if (((BuildingFarmer.View)this.building).pumpkin == 0 || s.equals("pumpkin") || rand != 4) continue;
            --((BuildingFarmer.View)this.building).pumpkin;
        }
        if (this.sum() < 100) {
            ((BuildingFarmer.View)this.building).wheat = ((BuildingFarmer.View)this.building).wheat + 100 - this.sum();
        }
        MineColonies.getNetwork().sendToServer((IMessage)new FarmerCropTypeMessage((BuildingFarmer.View)this.building));
    }

    private int sum() {
        return ((BuildingFarmer.View)this.building).wheat + ((BuildingFarmer.View)this.building).carrot + ((BuildingFarmer.View)this.building).melon + ((BuildingFarmer.View)this.building).potato + ((BuildingFarmer.View)this.building).pumpkin;
    }

    private void wheatClicked(Button ignored) {
        if (((BuildingFarmer.View)this.building).wheat >= 100) {
            return;
        }
        ++((BuildingFarmer.View)this.building).wheat;
        this.removeOthers("wheat");
    }

    private void potatoClicked(Button ignored) {
        if (((BuildingFarmer.View)this.building).potato >= 100) {
            return;
        }
        ++((BuildingFarmer.View)this.building).potato;
        this.removeOthers("potato");
    }

    private void melonClicked(Button ignored) {
        if (((BuildingFarmer.View)this.building).melon >= 100) {
            return;
        }
        ++((BuildingFarmer.View)this.building).melon;
        this.removeOthers("melon");
    }

    private void pumpkinClicked(Button ignored) {
        if (((BuildingFarmer.View)this.building).pumpkin >= 100) {
            return;
        }
        ++((BuildingFarmer.View)this.building).pumpkin;
        this.removeOthers("pumpkin");
    }

    private void carrotClicked(Button ignored) {
        if (((BuildingFarmer.View)this.building).carrot >= 100) {
            return;
        }
        ++((BuildingFarmer.View)this.building).carrot;
        this.removeOthers("carrot");
    }

    @Override
    public String getBuildingName() {
        return "com.minecolonies.gui.workerHuts.farmer";
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.updateButtonLabels();
        this.findPaneOfTypeByID(BUTTON_PREV_PAGE, Button.class).setEnabled(false);
        this.buttonPrevPage = this.findPaneOfTypeByID(BUTTON_PREV_PAGE, Button.class);
        this.buttonNextPage = this.findPaneOfTypeByID(BUTTON_NEXT_PAGE, Button.class);
    }

    private void updateButtonLabels() {
        try {
            this.findPaneOfTypeByID("wheat", ButtonVanilla.class).setLabel(Integer.toString(((BuildingFarmer.View)this.building).wheat));
            this.findPaneOfTypeByID("potato", ButtonVanilla.class).setLabel(Integer.toString(((BuildingFarmer.View)this.building).potato));
            this.findPaneOfTypeByID("carrot", ButtonVanilla.class).setLabel(Integer.toString(((BuildingFarmer.View)this.building).carrot));
            this.findPaneOfTypeByID("melon", ButtonVanilla.class).setLabel(Integer.toString(((BuildingFarmer.View)this.building).melon));
            this.findPaneOfTypeByID("pumpkin", ButtonVanilla.class).setLabel(Integer.toString(((BuildingFarmer.View)this.building).pumpkin));
        }
        catch (RuntimeException exc) {
            Log.logger.error("findPane error, report to mod authors", (Throwable)exc);
        }
    }

    private void prevClicked(Button ignored) {
        this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).previousView();
        this.buttonPrevPage.setEnabled(false);
        this.buttonNextPage.setEnabled(true);
    }

    private void nextClicked(Button ignored) {
        this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).nextView();
        this.buttonPrevPage.setEnabled(true);
        this.buttonNextPage.setEnabled(false);
    }

    @Override
    public void onButtonClicked(Button button) {
        super.onButtonClicked(button);
        this.updateButtonLabels();
    }
}

