/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.client.gui;

import com.blockout.Pane;
import com.blockout.controls.Button;
import com.blockout.controls.Label;
import com.blockout.views.ScrollingList;
import com.blockout.views.SwitchView;
import com.minecolonies.MineColonies;
import com.minecolonies.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.colony.buildings.BuildingMiner;
import com.minecolonies.network.messages.MinerSetLevelMessage;
import com.minecolonies.util.LanguageHandler;
import java.awt.Color;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WindowHutMiner
extends AbstractWindowWorkerBuilding<BuildingMiner.View> {
    private static final String LIST_LEVELS = "levels";
    private static final String PAGE_LEVELS = "levelActions";
    private static final String BUTTON_PREVPAGE = "prevPage";
    private static final String BUTTON_NEXTPAGE = "nextPage";
    private static final String BUTTON_CURRENTLEVEL = "changeToLevel";
    private static final String VIEW_PAGES = "pages";
    private static final String HUT_MINER_RESOURCE_SUFFIX = ":gui/windowHutMiner.xml";
    private Button buttonPrevPage;
    private Button buttonNextPage;
    private int[] levels;
    private ScrollingList levelList;
    private BuildingMiner.View miner;

    public WindowHutMiner(BuildingMiner.View building) {
        super(building, "minecolonies:gui/windowHutMiner.xml");
        this.miner = building;
        this.pullLevelsFromHut();
    }

    private void pullLevelsFromHut() {
        if (this.miner.getColony().getBuilding(this.miner.getID()) != null) {
            this.levels = this.miner.levels;
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.findPaneOfTypeByID(BUTTON_PREVPAGE, Button.class).setEnabled(false);
        this.buttonNextPage = this.findPaneOfTypeByID(BUTTON_NEXTPAGE, Button.class);
        this.buttonPrevPage = this.findPaneOfTypeByID(BUTTON_PREVPAGE, Button.class);
        this.levelList = this.findPaneOfTypeByID(LIST_LEVELS, ScrollingList.class);
        this.levelList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHutMiner.this.levels.length;
            }

            @Override
            public void updateElement(int index, Pane rowPane) {
                if (index == ((WindowHutMiner)WindowHutMiner.this).miner.current) {
                    rowPane.findPaneOfTypeByID("lvl", Label.class).setColor(Color.RED.getRGB());
                } else {
                    rowPane.findPaneOfTypeByID("lvl", Label.class).setColor(Color.BLACK.getRGB());
                }
                rowPane.findPaneOfTypeByID("lvl", Label.class).setLabelText(Integer.toString(index));
                rowPane.findPaneOfTypeByID("nONodes", Label.class).setLabelText(LanguageHandler.getString("com.minecolonies.gui.workerHuts.minerNode") + ": " + WindowHutMiner.this.levels[index]);
            }
        });
    }

    @Override
    public void onButtonClicked(Button button) {
        switch (button.getID()) {
            case "prevPage": {
                this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).previousView();
                this.buttonPrevPage.setEnabled(false);
                this.buttonNextPage.setEnabled(true);
                break;
            }
            case "nextPage": {
                this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).nextView();
                this.buttonPrevPage.setEnabled(true);
                this.buttonNextPage.setEnabled(false);
                break;
            }
            case "changeToLevel": {
                int row = this.levelList.getListElementIndexByPane(button);
                if (row == this.miner.current || row < 0 || row >= this.levels.length) break;
                this.miner.current = row;
                MineColonies.getNetwork().sendToServer((IMessage)new MinerSetLevelMessage(this.miner, row));
                break;
            }
            default: {
                super.onButtonClicked(button);
            }
        }
    }

    @Override
    public void onUpdate() {
        String currentPage = this.findPaneOfTypeByID(VIEW_PAGES, SwitchView.class).getCurrentView().getID();
        if (currentPage.equals(PAGE_LEVELS)) {
            this.pullLevelsFromHut();
            this.window.findPaneOfTypeByID(LIST_LEVELS, ScrollingList.class).refreshElementPanes();
        }
    }

    @Override
    public String getBuildingName() {
        return "com.minecolonies.gui.workerHuts.minerHut";
    }
}

