/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony;

import com.minecolonies.MineColonies;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.ColonyManager;
import com.minecolonies.colony.IColony;
import com.minecolonies.colony.WorkManager;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.buildings.BuildingHome;
import com.minecolonies.colony.buildings.BuildingTownHall;
import com.minecolonies.colony.materials.MaterialSystem;
import com.minecolonies.colony.permissions.Permissions;
import com.minecolonies.colony.workorders.AbstractWorkOrder;
import com.minecolonies.configuration.Configurations;
import com.minecolonies.entity.EntityCitizen;
import com.minecolonies.network.messages.ColonyViewBuildingViewMessage;
import com.minecolonies.network.messages.ColonyViewCitizenViewMessage;
import com.minecolonies.network.messages.ColonyViewMessage;
import com.minecolonies.network.messages.ColonyViewRemoveBuildingMessage;
import com.minecolonies.network.messages.ColonyViewRemoveCitizenMessage;
import com.minecolonies.network.messages.ColonyViewRemoveWorkOrderMessage;
import com.minecolonies.network.messages.ColonyViewWorkOrderMessage;
import com.minecolonies.network.messages.PermissionsMessage;
import com.minecolonies.tileentities.TileEntityColonyBuilding;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.EntityUtils;
import com.minecolonies.util.LanguageHandler;
import com.minecolonies.util.Log;
import com.minecolonies.util.MathUtils;
import com.minecolonies.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Colony
implements IColony {
    private final int id;
    private World world = null;
    private Set<EntityPlayerMP> subscribers = new HashSet<EntityPlayerMP>();
    private boolean isDirty = false;
    private boolean isCitizensDirty = false;
    private boolean isBuildingsDirty = false;
    private boolean manualHiring = false;
    private String name = "ERROR(Wasn't placed by player)";
    private final int dimensionId;
    private BlockPos center;
    private Permissions permissions = new Permissions();
    private BuildingTownHall townHall;
    private Map<BlockPos, AbstractBuilding> buildings = new HashMap<BlockPos, AbstractBuilding>();
    private Map<Integer, CitizenData> citizens = new HashMap<Integer, CitizenData>();
    private int topCitizenId = 0;
    private int maxCitizens = Configurations.maxCitizens;
    private static final int CITIZEN_CLEANUP_TICK_INCREMENT = 100;
    private final WorkManager workManager = new WorkManager(this);
    private final MaterialSystem materialSystem = new MaterialSystem();
    private static final String TAG_ID = "id";
    private static final String TAG_NAME = "name";
    private static final String TAG_DIMENSION = "dimension";
    private static final String TAG_CENTER = "center";
    private static final String TAG_MAX_CITIZENS = "maxCitizens";
    private static final String TAG_BUILDINGS = "buildings";
    private static final String TAG_CITIZENS = "citizens";
    private static final String TAG_WORK = "work";
    private static final String TAG_MANUAL_HIRING = "manualHiring";

    Colony(int id, World w, BlockPos c) {
        this(id, w.field_73011_w.func_177502_q());
        this.center = c;
        this.world = w;
    }

    protected Colony(int id, int dim) {
        this.id = id;
        this.dimensionId = dim;
    }

    public static Colony loadColony(NBTTagCompound compound) {
        int id = compound.func_74762_e(TAG_ID);
        int dimensionId = compound.func_74762_e(TAG_DIMENSION);
        Colony c = new Colony(id, dimensionId);
        c.readFromNBT(compound);
        return c;
    }

    private void readFromNBT(NBTTagCompound compound) {
        this.name = compound.func_74779_i(TAG_NAME);
        this.center = BlockPosUtil.readFromNBT(compound, TAG_CENTER);
        this.manualHiring = compound.func_74767_n(TAG_MANUAL_HIRING);
        this.maxCitizens = compound.func_74762_e(TAG_MAX_CITIZENS);
        this.permissions.loadPermissions(compound);
        NBTTagList citizenTagList = compound.func_150295_c(TAG_CITIZENS, 10);
        for (int i = 0; i < citizenTagList.func_74745_c(); ++i) {
            NBTTagCompound citizenCompound = citizenTagList.func_150305_b(i);
            CitizenData data = CitizenData.createFromNBT(citizenCompound, this);
            this.citizens.put(data.getId(), data);
            this.topCitizenId = Math.max(this.topCitizenId, data.getId());
        }
        NBTTagList buildingTagList = compound.func_150295_c(TAG_BUILDINGS, 10);
        for (int i = 0; i < buildingTagList.func_74745_c(); ++i) {
            NBTTagCompound buildingCompound = buildingTagList.func_150305_b(i);
            AbstractBuilding b = AbstractBuilding.createFromNBT(this, buildingCompound);
            if (b == null) continue;
            this.addBuilding(b);
        }
        this.workManager.readFromNBT(compound.func_74775_l(TAG_WORK));
    }

    protected void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a(TAG_ID, this.id);
        compound.func_74768_a(TAG_DIMENSION, this.dimensionId);
        compound.func_74778_a(TAG_NAME, this.name);
        BlockPosUtil.writeToNBT(compound, TAG_CENTER, this.center);
        compound.func_74757_a(TAG_MANUAL_HIRING, this.manualHiring);
        compound.func_74768_a(TAG_MAX_CITIZENS, this.maxCitizens);
        this.permissions.savePermissions(compound);
        NBTTagList buildingTagList = new NBTTagList();
        for (AbstractBuilding abstractBuilding : this.buildings.values()) {
            NBTTagCompound buildingCompound = new NBTTagCompound();
            abstractBuilding.writeToNBT(buildingCompound);
            buildingTagList.func_74742_a((NBTBase)buildingCompound);
        }
        compound.func_74782_a(TAG_BUILDINGS, (NBTBase)buildingTagList);
        NBTTagList citizenTagList = new NBTTagList();
        for (CitizenData citizen : this.citizens.values()) {
            NBTTagCompound citizenCompound = new NBTTagCompound();
            citizen.writeToNBT(citizenCompound);
            citizenTagList.func_74742_a((NBTBase)citizenCompound);
        }
        compound.func_74782_a(TAG_CITIZENS, (NBTBase)citizenTagList);
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        this.workManager.writeToNBT(nBTTagCompound);
        compound.func_74782_a(TAG_WORK, (NBTBase)nBTTagCompound);
    }

    public int getID() {
        return this.id;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
        this.markDirty();
    }

    public BlockPos getCenter() {
        return this.center;
    }

    private void markDirty() {
        this.isDirty = true;
    }

    public void markCitizensDirty() {
        this.isCitizensDirty = true;
    }

    public void markBuildingsDirty() {
        this.isBuildingsDirty = true;
    }

    @Override
    public Permissions getPermissions() {
        return this.permissions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCoordInColony(World w, BlockPos pos) {
        if (!w.equals(this.getWorld())) return false;
        BlockPos blockPos = new BlockPos(pos.func_177958_n(), this.center.func_177956_o(), pos.func_177952_p());
        if (!((double)BlockPosUtil.getDistanceSquared(this.center, blockPos) <= MathUtils.square(Configurations.workingRangeTownHall))) return false;
        return true;
    }

    @Override
    public float getDistanceSquared(BlockPos pos) {
        return BlockPosUtil.getDistanceSquared(this.center, new BlockPos(pos.func_177958_n(), this.center.func_177956_o(), pos.func_177952_p()));
    }

    public void onWorldLoad(World w) {
        if (w.field_73011_w.func_177502_q() == this.dimensionId) {
            this.world = w;
        }
    }

    public void onWorldUnload(World w) {
        if (!w.equals(this.world)) {
            throw new IllegalStateException("Colony's world does not match the event.");
        }
        this.world = null;
    }

    public void onServerTick(TickEvent.ServerTickEvent event) {
        for (AbstractBuilding b : this.buildings.values()) {
            b.onServerTick(event);
        }
        if (event.phase == TickEvent.Phase.END) {
            this.updateSubscribers();
        }
    }

    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world != this.getWorld()) {
            throw new IllegalStateException("Colony's world does not match the event.");
        }
        if (event.phase == TickEvent.Phase.START) {
            this.citizens.values().stream().filter(Colony::isCitizenMissingFromWorld).forEach(CitizenData::clearCitizenEntity);
            if (event.world.func_72820_D() % 100L == 0L && this.areAllColonyChunksLoaded(event)) {
                this.citizens.values().stream().filter(citizen -> citizen.getCitizenEntity() == null).forEach(citizen -> {
                    Log.logger.warn(String.format("Citizen #%d:%d has gone AWOL, respawning them!", this.getID(), citizen.getId()));
                    this.spawnCitizen((CitizenData)citizen);
                });
            }
            this.cleanUpBuildings(event);
            if (this.townHall != null && this.citizens.size() < this.maxCitizens) {
                int respawnInterval = Configurations.citizenRespawnInterval * 20;
                if (event.world.func_72820_D() % (long)(respawnInterval -= 60 * this.townHall.getBuildingLevel()) == 0L) {
                    this.spawnCitizen();
                }
            }
        }
        for (AbstractBuilding building : this.buildings.values()) {
            building.onWorldTick(event);
        }
        this.workManager.onWorldTick(event);
    }

    public void updateSubscribers() {
        Set<EntityPlayerMP> oldSubscribers = this.subscribers;
        this.subscribers = new HashSet<EntityPlayerMP>();
        this.subscribers.addAll(MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.stream().filter(this.permissions::isSubscriber).collect(Collectors.toList()));
        if (this.world != null) {
            for (EntityPlayer o : this.world.field_73010_i) {
                double distance;
                EntityPlayerMP player;
                if (!(o instanceof EntityPlayerMP) || this.subscribers.contains(player = (EntityPlayerMP)o) || !((distance = player.func_174818_b(this.center)) < MathUtils.square((double)Configurations.workingRangeTownHall + 16.0)) && (!oldSubscribers.contains(player) || !(distance < MathUtils.square((double)Configurations.workingRangeTownHall * 2.0)))) continue;
                this.subscribers.add(player);
            }
        }
        if (!this.subscribers.isEmpty()) {
            boolean hasNewSubscribers = Colony.hasNewSubscribers(oldSubscribers, this.subscribers);
            this.sendColonyViewPackets(oldSubscribers, hasNewSubscribers);
            this.sendPermissionsPackets(oldSubscribers, hasNewSubscribers);
            this.sendWorkOrderPackets(oldSubscribers, hasNewSubscribers);
            this.sendCitizenPackets(oldSubscribers, hasNewSubscribers);
            this.sendBuildingPackets(oldSubscribers, hasNewSubscribers);
        }
        this.isDirty = false;
        this.isCitizensDirty = false;
        this.isBuildingsDirty = false;
        this.permissions.clearDirty();
        this.buildings.values().forEach(AbstractBuilding::clearDirty);
        this.citizens.values().forEach(CitizenData::clearDirty);
    }

    private void sendBuildingPackets(Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        if (this.isBuildingsDirty || hasNewSubscribers) {
            for (AbstractBuilding building : this.buildings.values()) {
                if (!building.isDirty() && !hasNewSubscribers) continue;
                this.subscribers.stream().filter(player -> building.isDirty() || !oldSubscribers.contains(player)).forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewBuildingViewMessage(building), player));
            }
        }
    }

    private void sendCitizenPackets(Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        if (this.isCitizensDirty || hasNewSubscribers) {
            for (CitizenData citizen : this.citizens.values()) {
                if (!citizen.isDirty() && !hasNewSubscribers) continue;
                this.subscribers.stream().filter(player -> citizen.isDirty() || !oldSubscribers.contains(player)).forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewCitizenViewMessage(this, citizen), player));
            }
        }
    }

    private void sendWorkOrderPackets(Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        if (this.getWorkManager().isDirty() || hasNewSubscribers) {
            for (AbstractWorkOrder workOrder : this.getWorkManager().getWorkOrders().values()) {
                this.subscribers.stream().filter(player -> this.workManager.isDirty() || !oldSubscribers.contains(player)).forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new ColonyViewWorkOrderMessage(this, workOrder), player));
            }
            this.getWorkManager().setDirty(false);
        }
    }

    private void sendPermissionsPackets(Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        if (this.permissions.isDirty() || hasNewSubscribers) {
            this.subscribers.stream().filter(player -> this.permissions.isDirty() || !oldSubscribers.contains(player)).forEach(player -> {
                Permissions.Rank rank = this.getPermissions().getRank((EntityPlayer)player);
                MineColonies.getNetwork().sendTo((IMessage)new PermissionsMessage.View(this, rank), player);
            });
        }
    }

    private void sendColonyViewPackets(Set<EntityPlayerMP> oldSubscribers, boolean hasNewSubscribers) {
        if (this.isDirty || hasNewSubscribers) {
            for (EntityPlayerMP player : this.subscribers) {
                boolean isNewSubscriber;
                boolean bl = isNewSubscriber = !oldSubscribers.contains(player);
                if (!this.isDirty && !isNewSubscriber) continue;
                MineColonies.getNetwork().sendTo((IMessage)new ColonyViewMessage(this, isNewSubscriber), player);
            }
        }
    }

    private static boolean hasNewSubscribers(Set<EntityPlayerMP> oldSubscribers, Set<EntityPlayerMP> subscribers) {
        for (EntityPlayerMP player : subscribers) {
            if (oldSubscribers.contains(player)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCitizenMissingFromWorld(CitizenData citizen) {
        EntityCitizen entity = citizen.getCitizenEntity();
        return entity != null && entity.field_70170_p.func_73045_a(entity.func_145782_y()) != entity;
    }

    private boolean areAllColonyChunksLoaded(TickEvent.WorldTickEvent event) {
        int distanceFromCenter = Configurations.workingRangeTownHall + 48 + 15;
        for (int x = -distanceFromCenter; x <= distanceFromCenter; x += 16) {
            for (int z = -distanceFromCenter; z <= distanceFromCenter; z += 16) {
                if (event.world.func_175667_e(new BlockPos(this.getCenter().func_177958_n() + x, 128, this.getCenter().func_177952_p() + z))) continue;
                return false;
            }
        }
        return true;
    }

    private void cleanUpBuildings(TickEvent.WorldTickEvent event) {
        ArrayList<AbstractBuilding> removedBuildings = null;
        for (AbstractBuilding building : this.buildings.values()) {
            BlockPos loc = building.getLocation();
            if (!event.world.func_175667_e(loc) || building.isMatchingBlock(event.world.func_180495_p(loc).func_177230_c())) continue;
            if (removedBuildings == null) {
                removedBuildings = new ArrayList<AbstractBuilding>();
            }
            removedBuildings.add(building);
        }
        if (removedBuildings != null) {
            removedBuildings.forEach(AbstractBuilding::destroy);
        }
    }

    private void spawnCitizen() {
        this.spawnCitizen(null);
    }

    private void spawnCitizen(CitizenData data) {
        if (!this.world.func_175667_e(this.center)) {
            return;
        }
        BlockPos spawnPoint = Utils.scanForBlockNearPoint(this.world, this.center, 1, 0, 1, 2, Blocks.field_150350_a, Blocks.field_150431_aC);
        if (spawnPoint != null) {
            EntityCitizen entity = new EntityCitizen(this.world);
            CitizenData citizenData = data;
            if (citizenData == null) {
                ++this.topCitizenId;
                citizenData = new CitizenData(this.topCitizenId, this);
                citizenData.initializeFromEntity(entity);
                this.citizens.put(citizenData.getId(), citizenData);
                if (this.getMaxCitizens() == this.getCitizens().size()) {
                    LanguageHandler.sendPlayersLocalizedMessage(EntityUtils.getPlayersFromUUID(this.world, this.permissions.getMessagePlayers()), "tile.blockHutTownHall.messageMaxSize", new Object[0]);
                }
            }
            entity.setColony(this, citizenData);
            entity.func_70107_b(spawnPoint.func_177958_n(), spawnPoint.func_177956_o(), spawnPoint.func_177952_p());
            this.world.func_72838_d((Entity)entity);
            this.markCitizensDirty();
        }
    }

    public Map<BlockPos, AbstractBuilding> getBuildings() {
        return Collections.unmodifiableMap(this.buildings);
    }

    public BuildingTownHall getTownHall() {
        return this.townHall;
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    public AbstractBuilding getBuilding(BlockPos buildingId) {
        return this.buildings.get(buildingId);
    }

    public <B extends AbstractBuilding> B getBuilding(BlockPos buildingId, Class<B> type) {
        try {
            return (B)((AbstractBuilding)type.cast(this.buildings.get(buildingId)));
        }
        catch (ClassCastException e) {
            Log.logger.warn("getBuilding called with wrong type: ", (Throwable)e);
            return null;
        }
    }

    private void addBuilding(AbstractBuilding building) {
        this.buildings.put(building.getID(), building);
        building.markDirty();
        if (building instanceof BuildingTownHall && this.townHall == null) {
            this.townHall = (BuildingTownHall)building;
        }
    }

    public AbstractBuilding addNewBuilding(TileEntityColonyBuilding tileEntity) {
        tileEntity.setColony(this);
        AbstractBuilding building = AbstractBuilding.create(this, tileEntity);
        if (building != null) {
            this.addBuilding(building);
            tileEntity.setBuilding(building);
            Log.logger.info(String.format("Colony %d - new AbstractBuilding for %s at %s", this.getID(), tileEntity.func_145838_q().getClass(), tileEntity.getPosition()));
        } else {
            Log.logger.error(String.format("Colony %d unable to create AbstractBuilding for %s at %s", this.getID(), tileEntity.func_145838_q().getClass(), tileEntity.getPosition()));
        }
        this.calculateMaxCitizens();
        ColonyManager.markDirty();
        return building;
    }

    public void removeBuilding(AbstractBuilding building) {
        if (this.buildings.remove(building.getID()) != null) {
            for (EntityPlayerMP player : this.subscribers) {
                MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveBuildingMessage(this, building.getID()), player);
            }
            Log.logger.info(String.format("Colony %d - removed AbstractBuilding %s of type %s", this.getID(), building.getID(), building.getSchematicName()));
        }
        if (building == this.townHall) {
            this.townHall = null;
        }
        for (CitizenData citizen : this.citizens.values()) {
            citizen.onRemoveBuilding(building);
        }
        this.calculateMaxCitizens();
        ColonyManager.markDirty();
    }

    public boolean isManualHiring() {
        return this.manualHiring;
    }

    public void setManualHiring(boolean manualHiring) {
        this.manualHiring = manualHiring;
        this.markDirty();
    }

    public int getMaxCitizens() {
        return this.maxCitizens;
    }

    public void calculateMaxCitizens() {
        int newMaxCitizens = Configurations.maxCitizens;
        for (AbstractBuilding b : this.buildings.values()) {
            if (!(b instanceof BuildingHome) || b.getBuildingLevel() <= 0) continue;
            newMaxCitizens += ((BuildingHome)b).getMaxInhabitants();
        }
        if (this.maxCitizens != newMaxCitizens) {
            this.maxCitizens = newMaxCitizens;
            this.markDirty();
        }
    }

    public Map<Integer, CitizenData> getCitizens() {
        return Collections.unmodifiableMap(this.citizens);
    }

    public void removeCitizen(CitizenData citizen) {
        this.citizens.remove(citizen.getId());
        for (AbstractBuilding building : this.buildings.values()) {
            building.removeCitizen(citizen);
        }
        this.workManager.clearWorkForCitizen(citizen);
        for (EntityPlayerMP player : this.subscribers) {
            MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveCitizenMessage(this, citizen.getId()), player);
        }
    }

    public void removeWorkOrder(int orderId) {
        for (EntityPlayerMP player : this.subscribers) {
            MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveWorkOrderMessage(this, orderId), player);
        }
    }

    public CitizenData getCitizen(int citizenId) {
        return this.citizens.get(citizenId);
    }

    public CitizenData getJoblessCitizen() {
        for (CitizenData citizen : this.citizens.values()) {
            if (citizen.getWorkBuilding() != null) continue;
            return citizen;
        }
        return null;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public List<BlockPos> getDeliverymanRequired() {
        return this.citizens.values().stream().filter(citizen -> citizen.getWorkBuilding() != null && citizen.getJob() != null).filter(citizen -> !citizen.getJob().isMissingNeededItem()).map(citizen -> citizen.getWorkBuilding().getLocation()).collect(Collectors.toList());
    }

    public MaterialSystem getMaterialSystem() {
        return this.materialSystem;
    }
}

