/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony;

import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyManagerWorldAccess;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.IColony;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.permissions.Permissions;
import com.minecolonies.configuration.Configurations;
import com.minecolonies.util.LanguageHandler;
import com.minecolonies.util.Log;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class ColonyManager {
    private static Map<Integer, Colony> colonies = new HashMap<Integer, Colony>();
    private static Map<Integer, List<Colony>> coloniesByWorld = new HashMap<Integer, List<Colony>>();
    private static int topColonyId = 0;
    private static Map<Integer, ColonyView> colonyViews = new HashMap<Integer, ColonyView>();
    private static int numWorldsLoaded;
    private static boolean saveNeeded;
    private static final String FILENAME_MINECOLONIES_PATH = "minecolonies";
    private static final String FILENAME_MINECOLONIES = "colonies.dat";
    private static final String TAG_COLONIES = "colonies";

    private ColonyManager() {
    }

    public static Colony createColony(World w, BlockPos pos, EntityPlayer player) {
        Colony colony = new Colony(++topColonyId, w, pos);
        colonies.put(colony.getID(), colony);
        if (!coloniesByWorld.containsKey(colony.getDimensionId())) {
            coloniesByWorld.put(colony.getDimensionId(), new ArrayList());
        }
        coloniesByWorld.get(colony.getDimensionId()).add(colony);
        String colonyName = LanguageHandler.format("com.minecolonies.gui.townHall.defaultName", player.getDisplayNameString());
        colony.setName(colonyName);
        colony.getPermissions().setPlayerRank(player.func_146103_bH().getId(), Permissions.Rank.OWNER);
        ColonyManager.markDirty();
        Log.logger.info(String.format("New Colony %d", colony.getID()));
        return colony;
    }

    public static Colony getColony(int id) {
        return colonies.get(id);
    }

    public static Colony getColony(World w, BlockPos pos) {
        List<Colony> coloniesInWorld = coloniesByWorld.get(w.field_73011_w.func_177502_q());
        if (coloniesInWorld == null) {
            return null;
        }
        for (Colony c : coloniesInWorld) {
            if (!c.isCoordInColony(w, pos)) continue;
            return c;
        }
        return null;
    }

    private static Colony getClosestColony(World w, BlockPos pos) {
        List<Colony> coloniesInWorld = coloniesByWorld.get(w.field_73011_w.func_177502_q());
        if (coloniesInWorld == null) {
            return null;
        }
        Colony closestColony = null;
        float closestDist = Float.MAX_VALUE;
        for (Colony c : coloniesInWorld) {
            float dist;
            if (c.getDimensionId() != w.field_73011_w.func_177502_q() || !((dist = c.getDistanceSquared(pos)) < closestDist)) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    private static IColony getColonyByOwner(UUID owner) {
        return colonies.values().stream().filter(c -> c.getPermissions().getOwner().equals(owner)).findFirst().orElse(null);
    }

    public static AbstractBuilding getBuilding(World w, BlockPos pos) {
        AbstractBuilding building;
        Colony colony = ColonyManager.getColony(w, pos);
        if (colony != null && (building = colony.getBuilding(pos)) != null) {
            return building;
        }
        if (coloniesByWorld.containsKey(w.field_73011_w.func_177502_q())) {
            for (Colony otherColony : coloniesByWorld.get(w.field_73011_w.func_177502_q())) {
                AbstractBuilding building2 = otherColony.getBuilding(pos);
                if (building2 == null) continue;
                return building2;
            }
        }
        return null;
    }

    public static AbstractBuilding.View getBuildingView(BlockPos pos) {
        for (ColonyView colony : colonyViews.values()) {
            AbstractBuilding.View building = colony.getBuilding(pos);
            if (building == null) continue;
            return building;
        }
        return null;
    }

    public static ColonyView getColonyView(int id) {
        return colonyViews.get(id);
    }

    private static ColonyView getColonyView(World w, BlockPos pos) {
        for (ColonyView c : colonyViews.values()) {
            if (!c.isCoordInColony(w, pos)) continue;
            return c;
        }
        return null;
    }

    public static ColonyView getClosestColonyView(World w, BlockPos pos) {
        ColonyView closestColony = null;
        float closestDist = Float.MAX_VALUE;
        for (ColonyView c : colonyViews.values()) {
            float dist;
            if (c.getDimensionId() != w.field_73011_w.func_177502_q() || !((dist = c.getDistanceSquared(pos)) < closestDist)) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    private static IColony getColonyViewByOwner(UUID owner) {
        for (ColonyView c : colonyViews.values()) {
            Permissions.Player p = c.getPlayers().get(owner);
            if (p == null || !p.getRank().equals((Object)Permissions.Rank.OWNER)) continue;
            return c;
        }
        return null;
    }

    public static IColony getIColony(World w, BlockPos pos) {
        return w.field_72995_K ? ColonyManager.getColonyView(w, pos) : ColonyManager.getColony(w, pos);
    }

    public static IColony getClosestIColony(World w, BlockPos pos) {
        return w.field_72995_K ? ColonyManager.getClosestColonyView(w, pos) : ColonyManager.getClosestColony(w, pos);
    }

    public static IColony getIColonyByOwner(World w, EntityPlayer owner) {
        return ColonyManager.getIColonyByOwner(w, w.field_72995_K ? owner.func_110124_au() : owner.func_146103_bH().getId());
    }

    public static IColony getIColonyByOwner(World w, UUID owner) {
        return w.field_72995_K ? ColonyManager.getColonyViewByOwner(owner) : ColonyManager.getColonyByOwner(owner);
    }

    public static double getMinimumDistanceBetweenTownHalls() {
        return 2.0 * (double)Configurations.workingRangeTownHall + (double)Configurations.townHallPadding;
    }

    public static void onServerTick(TickEvent.ServerTickEvent event) {
        for (Colony c : colonies.values()) {
            c.onServerTick(event);
        }
        if (saveNeeded) {
            ColonyManager.saveColonies();
        }
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e == null && !colonyViews.isEmpty()) {
            colonyViews.clear();
        }
    }

    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        colonies.values().stream().filter(c -> c.getDimensionId() == worldTickEvent.world.field_73011_w.func_177502_q()).forEach(c -> c.onWorldTick(event));
    }

    public static void readFromNBT(NBTTagCompound compound) {
        NBTTagList colonyTags = compound.func_150295_c(TAG_COLONIES, 10);
        for (int i = 0; i < colonyTags.func_74745_c(); ++i) {
            Colony colony = Colony.loadColony(colonyTags.func_150305_b(i));
            colonies.put(colony.getID(), colony);
            if (!coloniesByWorld.containsKey(colony.getDimensionId())) {
                coloniesByWorld.put(colony.getDimensionId(), new ArrayList());
            }
            coloniesByWorld.get(colony.getDimensionId()).add(colony);
            topColonyId = Math.max(topColonyId, colony.getID());
        }
        Log.logger.info(String.format("Loaded %d colonies", colonies.size()));
    }

    public static void writeToNBT(NBTTagCompound compound) {
        NBTTagList colonyTagList = new NBTTagList();
        for (Colony colony : colonies.values()) {
            NBTTagCompound colonyTagCompound = new NBTTagCompound();
            colony.writeToNBT(colonyTagCompound);
            colonyTagList.func_74742_a((NBTBase)colonyTagCompound);
        }
        compound.func_74782_a(TAG_COLONIES, (NBTBase)colonyTagList);
    }

    private static File getSaveLocation() {
        File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), FILENAME_MINECOLONIES_PATH);
        return new File(saveDir, FILENAME_MINECOLONIES);
    }

    private static NBTTagCompound loadNBTFromPath(File file) {
        try {
            if (file != null && file.exists()) {
                return CompressedStreamTools.func_74797_a((File)file);
            }
        }
        catch (IOException exception) {
            Log.logger.error("Exception when loading ColonyManger", (Throwable)exception);
        }
        return null;
    }

    private static void saveNBTToPath(File file, NBTTagCompound compound) {
        try {
            if (file != null) {
                file.getParentFile().mkdir();
                CompressedStreamTools.func_74793_a((NBTTagCompound)compound, (File)file);
            }
        }
        catch (IOException exception) {
            Log.logger.error("Exception when saving ColonyManager", (Throwable)exception);
        }
    }

    private static void saveColonies() {
        NBTTagCompound compound = new NBTTagCompound();
        ColonyManager.writeToNBT(compound);
        File file = ColonyManager.getSaveLocation();
        ColonyManager.saveNBTToPath(file, compound);
        saveNeeded = false;
    }

    public static void markDirty() {
        saveNeeded = true;
    }

    public static void onWorldLoad(World world) {
        if (!world.field_72995_K) {
            File file;
            NBTTagCompound data;
            if (numWorldsLoaded == 0 && (data = ColonyManager.loadNBTFromPath(file = ColonyManager.getSaveLocation())) != null) {
                ColonyManager.readFromNBT(data);
            }
            ++numWorldsLoaded;
            List<Colony> worldColonies = coloniesByWorld.get(world.field_73011_w.func_177502_q());
            if (worldColonies != null) {
                for (Colony c : worldColonies) {
                    c.onWorldLoad(world);
                }
            }
            world.func_72954_a((IWorldAccess)new ColonyManagerWorldAccess());
        }
    }

    public static void onWorldSave(World world) {
        if (!world.field_72995_K && world.field_73011_w.func_177502_q() == 0) {
            ColonyManager.saveColonies();
        }
    }

    public static void onWorldUnload(World world) {
        if (!world.field_72995_K) {
            List<Colony> worldColonies = coloniesByWorld.get(world.field_73011_w.func_177502_q());
            if (worldColonies != null) {
                for (Colony c : worldColonies) {
                    c.onWorldUnload(world);
                }
            }
            if (--numWorldsLoaded == 0) {
                colonies.clear();
                coloniesByWorld.clear();
            }
        }
    }

    public static IMessage handleColonyViewMessage(int colonyId, ByteBuf colonyData, boolean isNewSubscription) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view == null) {
            view = ColonyView.createFromNetwork(colonyId);
            colonyViews.put(colonyId, view);
        }
        return view.handleColonyViewMessage(colonyData, isNewSubscription);
    }

    public static IMessage handlePermissionsViewMessage(int colonyID, ByteBuf data) {
        ColonyView view = ColonyManager.getColonyView(colonyID);
        if (view != null) {
            return view.handlePermissionsViewMessage(data);
        }
        Log.logger.error(String.format("Colony view does not exist for ID #%d", colonyID));
        return null;
    }

    public static IMessage handleColonyViewCitizensMessage(int colonyId, int citizenId, ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewCitizensMessage(citizenId, buf);
        }
        return null;
    }

    public static IMessage handleColonyViewWorkOrderMessage(int colonyId, ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewWorkOrderMessage(buf);
        }
        return null;
    }

    public static IMessage handleColonyViewRemoveCitizenMessage(int colonyId, int citizenId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewRemoveCitizenMessage(citizenId);
        }
        return null;
    }

    public static IMessage handleColonyBuildingViewMessage(int colonyId, BlockPos buildingId, ByteBuf buf) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyBuildingViewMessage(buildingId, buf);
        }
        Log.logger.error(String.format("Colony view does not exist for ID #%d", colonyId));
        return null;
    }

    public static IMessage handleColonyViewRemoveBuildingMessage(int colonyId, BlockPos buildingId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewRemoveBuildingMessage(buildingId);
        }
        return null;
    }

    public static IMessage handleColonyViewRemoveWorkOrderMessage(int colonyId, int workOrderId) {
        ColonyView view = ColonyManager.getColonyView(colonyId);
        if (view != null) {
            return view.handleColonyViewRemoveWorkOrderMessage(workOrderId);
        }
        return null;
    }
}

