/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony;

import com.minecolonies.MineColonies;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.CitizenDataView;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.IColony;
import com.minecolonies.colony.WorkOrderView;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.buildings.BuildingTownHall;
import com.minecolonies.colony.permissions.Permissions;
import com.minecolonies.colony.workorders.AbstractWorkOrder;
import com.minecolonies.configuration.Configurations;
import com.minecolonies.network.messages.PermissionsMessage;
import com.minecolonies.network.messages.TownHallRenameMessage;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.MathUtils;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class ColonyView
implements IColony {
    private final int id;
    private String name = "Unknown";
    private int dimensionId;
    private BlockPos center;
    private boolean manualHiring = false;
    private Permissions.View permissions = new Permissions.View();
    private BuildingTownHall.View townHall;
    private Map<BlockPos, AbstractBuilding.View> buildings = new HashMap<BlockPos, AbstractBuilding.View>();
    private Map<Integer, CitizenDataView> citizens = new HashMap<Integer, CitizenDataView>();
    private final Map<Integer, WorkOrderView> workOrders = new HashMap<Integer, WorkOrderView>();
    private int maxCitizens = 0;

    private ColonyView(int id) {
        this.id = id;
    }

    public static ColonyView createFromNetwork(int id) {
        return new ColonyView(id);
    }

    public int getID() {
        return this.id;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public void setName(String name) {
        this.name = name;
        MineColonies.getNetwork().sendToServer((IMessage)new TownHallRenameMessage(this, name));
    }

    public boolean isManualHiring() {
        return this.manualHiring;
    }

    public void setManualHiring(boolean manualHiring) {
        this.manualHiring = manualHiring;
    }

    public BuildingTownHall.View getTownHall() {
        return this.townHall;
    }

    public AbstractBuilding.View getBuilding(int x, int y, int z) {
        return this.getBuilding(new BlockPos(x, y, z));
    }

    public AbstractBuilding.View getBuilding(BlockPos buildingId) {
        return this.buildings.get(buildingId);
    }

    public Map<UUID, Permissions.Player> getPlayers() {
        return this.permissions.getPlayers();
    }

    public void setPermission(Permissions.Rank rank, Permissions.Action action) {
        if (this.permissions.setPermission(rank, action)) {
            MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.Permission(this, PermissionsMessage.MessageType.SET_PERMISSION, rank, action));
        }
    }

    public void removePermission(Permissions.Rank rank, Permissions.Action action) {
        if (this.permissions.removePermission(rank, action)) {
            MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.Permission(this, PermissionsMessage.MessageType.REMOVE_PERMISSION, rank, action));
        }
    }

    public void togglePermission(Permissions.Rank rank, Permissions.Action action) {
        this.permissions.togglePermission(rank, action);
        MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.Permission(this, PermissionsMessage.MessageType.TOGGLE_PERMISSION, rank, action));
    }

    public int getMaxCitizens() {
        return this.maxCitizens;
    }

    public Map<Integer, CitizenDataView> getCitizens() {
        return Collections.unmodifiableMap(this.citizens);
    }

    public Collection<WorkOrderView> getWorkOrders() {
        return Collections.unmodifiableCollection(this.workOrders.values());
    }

    public CitizenDataView getCitizen(int id) {
        return this.citizens.get(id);
    }

    public static void serializeNetworkData(Colony colony, ByteBuf buf, boolean isNewSubScription) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)colony.getName());
        buf.writeInt(colony.getDimensionId());
        BlockPosUtil.writeToByteBuf(buf, colony.getCenter());
        buf.writeBoolean(colony.isManualHiring());
        buf.writeInt(colony.getMaxCitizens());
    }

    public IMessage handleColonyViewMessage(ByteBuf buf, boolean isNewSubscription) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.dimensionId = buf.readInt();
        this.center = BlockPosUtil.readFromByteBuf(buf);
        this.manualHiring = buf.readBoolean();
        this.maxCitizens = buf.readInt();
        if (isNewSubscription) {
            this.citizens.clear();
            this.townHall = null;
            this.buildings.clear();
        }
        return null;
    }

    public IMessage handlePermissionsViewMessage(ByteBuf buf) {
        this.permissions.deserialize(buf);
        return null;
    }

    public IMessage handleColonyViewWorkOrderMessage(ByteBuf buf) {
        WorkOrderView workOrder = AbstractWorkOrder.createWorkOrderView(buf);
        this.workOrders.put(workOrder.getId(), workOrder);
        return null;
    }

    public IMessage handleColonyViewCitizensMessage(int id, ByteBuf buf) {
        CitizenDataView citizen = CitizenData.createCitizenDataView(id, buf);
        if (citizen != null) {
            this.citizens.put(citizen.getID(), citizen);
        }
        return null;
    }

    public IMessage handleColonyViewRemoveCitizenMessage(int citizen) {
        this.citizens.remove(citizen);
        return null;
    }

    public IMessage handleColonyViewRemoveBuildingMessage(BlockPos buildingId) {
        AbstractBuilding.View building = this.buildings.remove(buildingId);
        if (this.townHall == building) {
            this.townHall = null;
        }
        return null;
    }

    public IMessage handleColonyViewRemoveWorkOrderMessage(int workOrderId) {
        this.workOrders.remove(workOrderId);
        return null;
    }

    public IMessage handleColonyBuildingViewMessage(BlockPos buildingId, ByteBuf buf) {
        AbstractBuilding.View building = AbstractBuilding.createBuildingView(this, buildingId, buf);
        if (building != null) {
            this.buildings.put(building.getID(), building);
            if (building instanceof BuildingTownHall.View) {
                this.townHall = (BuildingTownHall.View)building;
            }
        }
        return null;
    }

    public void addPlayer(String player) {
        MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.AddPlayer(this, player));
    }

    public void removePlayer(UUID player) {
        MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.RemovePlayer(this, player));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCoordInColony(World w, BlockPos pos) {
        if (w.field_73011_w.func_177502_q() != this.dimensionId) return false;
        BlockPos blockPos = new BlockPos(pos.func_177958_n(), this.center.func_177956_o(), pos.func_177952_p());
        if (!((double)BlockPosUtil.getDistanceSquared(this.center, blockPos) <= MathUtils.square(Configurations.workingRangeTownHall))) return false;
        return true;
    }

    @Override
    public float getDistanceSquared(BlockPos pos) {
        return BlockPosUtil.getDistanceSquared(this.center, new BlockPos(pos.func_177958_n(), this.center.func_177956_o(), pos.func_177952_p()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    public Permissions.View getPermissions() {
        return this.permissions;
    }
}

