/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.buildings;

import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuildingHut;
import com.minecolonies.colony.buildings.BuildingBuilder;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.entity.EntityCitizen;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public abstract class AbstractBuildingWorker
extends AbstractBuildingHut {
    private static final String TAG_WORKER = "worker";
    private CitizenData worker;

    public AbstractBuildingWorker(Colony c, BlockPos l) {
        super(c, l);
    }

    public abstract String getJobName();

    public abstract AbstractJob createJob(CitizenData var1);

    @Override
    public void onDestroyed() {
        if (this.hasWorker()) {
            this.removeCitizen(this.worker);
        }
        super.onDestroyed();
    }

    public CitizenData getWorker() {
        return this.worker;
    }

    public boolean hasWorker() {
        return this.worker != null;
    }

    public EntityCitizen getWorkerEntity() {
        return this.worker != null ? this.worker.getCitizenEntity() : null;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b(TAG_WORKER)) {
            this.worker = this.getColony().getCitizen(compound.func_74762_e(TAG_WORKER));
            if (this.worker != null) {
                this.worker.setWorkBuilding(this);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.worker != null) {
            compound.func_74768_a(TAG_WORKER, this.worker.getId());
        }
    }

    public void setWorker(CitizenData citizen) {
        if (this.worker == citizen) {
            return;
        }
        if (this.worker != null) {
            this.worker.setWorkBuilding(null);
        }
        this.worker = citizen;
        if (this.worker != null) {
            this.worker.setWorkBuilding(this);
        }
        this.markDirty();
    }

    @Override
    public void removeCitizen(CitizenData citizen) {
        if (this.isWorker(citizen)) {
            this.setWorker(null);
        }
    }

    public boolean isWorker(CitizenData citizen) {
        return citizen == this.worker;
    }

    @Override
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        CitizenData joblessCitizen;
        super.onWorldTick(event);
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!(this.hasWorker() || this.getBuildingLevel() <= 0 && !(this instanceof BuildingBuilder) || this.getColony().isManualHiring() || (joblessCitizen = this.getColony().getJoblessCitizen()) == null)) {
            this.setWorker(joblessCitizen);
        }
    }

    @Override
    public void serializeToView(ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.worker != null ? this.worker.getId() : 0);
    }

    public static class View
    extends AbstractBuildingHut.View {
        private int workerId;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        public int getWorkerId() {
            return this.workerId;
        }

        public void setWorkerId(int workerId) {
            this.workerId = workerId;
        }

        @Override
        public void deserialize(ByteBuf buf) {
            super.deserialize(buf);
            this.workerId = buf.readInt();
        }
    }
}

