/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.buildings;

import com.blockout.views.Window;
import com.minecolonies.client.gui.WindowHutFarmer;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.ColonyView;
import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.colony.jobs.JobFarmer;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;

public class BuildingFarmer
extends AbstractBuildingWorker {
    public int wheat = 100;
    public int potato = 0;
    public int carrot = 0;
    public int melon = 0;
    public int pumpkin = 0;
    public static final String WHEAT_TAG = "wheat";
    public static final String POTATO_TAG = "potato";
    public static final String CARROT_TAG = "carrot";
    public static final String MELON_TAG = "melon";
    public static final String PUMPKIN_TAG = "pumpkin";
    private static final String FARMER = "Farmer";
    private static final String TAG_FARMER = "farmer";

    public BuildingFarmer(Colony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public String getSchematicName() {
        return FARMER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 3;
    }

    @Override
    public String getJobName() {
        return FARMER;
    }

    @Override
    public AbstractJob createJob(CitizenData citizen) {
        return new JobFarmer(citizen);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        NBTTagCompound farmerCompound = compound.func_74775_l(TAG_FARMER);
        this.wheat = farmerCompound.func_74762_e(WHEAT_TAG);
        this.potato = farmerCompound.func_74762_e(POTATO_TAG);
        this.carrot = farmerCompound.func_74762_e(CARROT_TAG);
        this.melon = farmerCompound.func_74762_e(MELON_TAG);
        this.pumpkin = farmerCompound.func_74762_e(PUMPKIN_TAG);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagCompound farmerCompound = new NBTTagCompound();
        farmerCompound.func_74768_a(WHEAT_TAG, this.wheat);
        farmerCompound.func_74768_a(POTATO_TAG, this.potato);
        farmerCompound.func_74768_a(CARROT_TAG, this.carrot);
        farmerCompound.func_74768_a(MELON_TAG, this.melon);
        farmerCompound.func_74768_a(PUMPKIN_TAG, this.pumpkin);
        compound.func_74782_a(TAG_FARMER, (NBTBase)farmerCompound);
    }

    @Override
    public void serializeToView(ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.wheat);
        buf.writeInt(this.potato);
        buf.writeInt(this.carrot);
        buf.writeInt(this.melon);
        buf.writeInt(this.pumpkin);
    }

    public int getFarmRadius() {
        return this.getBuildingLevel() + 3;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public int wheat = 100;
        public int potato = 0;
        public int carrot = 0;
        public int melon = 0;
        public int pumpkin = 0;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public Window getWindow() {
            return new WindowHutFarmer(this);
        }

        @Override
        public void deserialize(ByteBuf buf) {
            super.deserialize(buf);
            this.wheat = buf.readInt();
            this.potato = buf.readInt();
            this.carrot = buf.readInt();
            this.melon = buf.readInt();
            this.pumpkin = buf.readInt();
        }
    }
}

