/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.jobs;

import com.minecolonies.client.render.RenderBipedCitizen;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import com.minecolonies.util.BlockPosUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;

public class JobDeliveryman
extends AbstractJob {
    private static final String TAG_DESTINATION = "destination";
    private BlockPos destination;

    public JobDeliveryman(CitizenData entity) {
        super(entity);
    }

    @Override
    public String getName() {
        return "com.minecolonies.job.Deliveryman";
    }

    @Override
    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.DELIVERYMAN;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.hasDestination()) {
            BlockPosUtil.writeToNBT(compound, TAG_DESTINATION, this.destination);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b(TAG_DESTINATION)) {
            this.destination = BlockPosUtil.readFromNBT(compound, TAG_DESTINATION);
        }
    }

    public boolean isNeeded() {
        Colony colony = this.getCitizen().getColony();
        return colony != null && !colony.getDeliverymanRequired().isEmpty();
    }

    @Override
    public AbstractAISkeleton generateAI() {
        return new EntityAIWorkDeliveryman(this);
    }

    public boolean hasDestination() {
        return this.destination != null;
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    public void setDestination(BlockPos destination) {
        this.destination = destination;
    }
}

