/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.jobs;

import com.minecolonies.client.render.RenderBipedCitizen;
import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.entity.ai.citizen.fisherman.EntityAIWorkFisherman;
import com.minecolonies.util.BlockPosUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;

public class JobFisherman
extends AbstractJob {
    private static final String TAG_WATER = "Pond";
    private static final String TAG_PONDS = "Ponds";
    private BlockPos water;
    private ArrayList<BlockPos> ponds = new ArrayList();

    public JobFisherman(CitizenData entity) {
        super(entity);
    }

    @Override
    public String getName() {
        return "com.minecolonies.job.Fisherman";
    }

    @Override
    public RenderBipedCitizen.Model getModel() {
        return RenderBipedCitizen.Model.FISHERMAN;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        NBTTagCompound waterTag = new NBTTagCompound();
        if (this.water != null) {
            BlockPosUtil.writeToNBT(waterTag, TAG_WATER, this.water);
        }
        NBTTagList lakes = new NBTTagList();
        for (BlockPos pond : this.ponds) {
            BlockPosUtil.writeToNBTTagList(lakes, pond);
        }
        compound.func_74782_a(TAG_PONDS, (NBTBase)lakes);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.func_74764_b(TAG_WATER)) {
            this.water = BlockPosUtil.readFromNBT(compound, TAG_WATER);
        }
        this.ponds = new ArrayList();
        NBTTagList listOfPonds = compound.func_150295_c(TAG_PONDS, 10);
        for (int i = 0; i < listOfPonds.func_74745_c(); ++i) {
            this.ponds.add(BlockPosUtil.readFromNBTTagList(listOfPonds, i));
        }
    }

    @Override
    public AbstractAISkeleton generateAI() {
        return new EntityAIWorkFisherman(this);
    }

    public BlockPos getWater() {
        return this.water;
    }

    public void setWater(BlockPos water) {
        this.water = water;
    }

    public List<BlockPos> getPonds() {
        return new ArrayList<BlockPos>(this.ponds);
    }

    public void addToPonds(BlockPos pond) {
        this.ponds.add(pond);
    }

    public void removeFromPonds(BlockPos pond) {
        this.ponds.remove(pond);
    }
}

