/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.materials;

import com.minecolonies.colony.materials.Material;
import com.minecolonies.colony.materials.MaterialStore;
import com.minecolonies.colony.materials.QuantityNotFound;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class MaterialSystem {
    public static final boolean isEnabled = false;
    private Map<Material, Integer> materials = new HashMap<Material, Integer>();
    private Set<MaterialStore> stores = new HashSet<MaterialStore>();
    private Map<Integer, Material> materialCache = new HashMap<Integer, Material>();

    public Map<Material, Integer> getMaterials() {
        return Collections.unmodifiableMap(this.materials);
    }

    public Set<MaterialStore> getStores() {
        return Collections.unmodifiableSet(this.stores);
    }

    public int getMaterialCount(Item item) {
        return this.getMaterialCount(this.getMaterial(item));
    }

    public int getMaterialCount(Block block) {
        return this.getMaterialCount(this.getMaterial(block));
    }

    private int getMaterialCount(Material material) {
        Integer count = this.materials.get(material);
        if (count == null) {
            this.removeItemFromCache(material);
            return 0;
        }
        return count;
    }

    private Material getMaterial(Integer id) {
        Material material = this.materialCache.get(id);
        if (material == null) {
            material = new Material(id);
            this.materialCache.put(id, material);
        }
        return material;
    }

    Material getMaterial(Item item) {
        if (item == null) {
            return null;
        }
        return this.getMaterial(Item.func_150891_b((Item)item));
    }

    Material getMaterial(Block block) {
        if (block == null) {
            return null;
        }
        return this.getMaterial(Block.func_149682_b((Block)block));
    }

    private void removeItemFromCache(Material material) {
        this.materialCache.remove(material.getID());
    }

    void addMaterial(Material material, int quantity) {
        Integer count = this.materials.get(material);
        if (count == null) {
            this.materials.put(material, quantity);
        } else {
            this.materials.put(material, quantity + count);
        }
    }

    void removeMaterial(Material material, int quantity) {
        Integer count = this.materials.get(material);
        if (count == null || count < quantity) {
            throw new QuantityNotFound("MaterialSystem", material.getID(), count == null ? 0 : count, quantity);
        }
        if (count == quantity) {
            this.materials.remove(material);
            this.removeItemFromCache(material);
        } else {
            this.materials.put(material, count - quantity);
        }
    }

    void addStore(MaterialStore store) {
        this.stores.add(store);
    }

    void removeStore(MaterialStore store) {
        this.stores.remove(store);
    }
}

