/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.permissions;

import com.minecolonies.colony.permissions.IPermissions;
import com.minecolonies.network.PacketUtils;
import com.minecolonies.util.Utils;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class Permissions
implements IPermissions {
    private static final String TAG_OWNERS = "owners";
    private static final String TAG_ID = "id";
    private static final String TAG_RANK = "rank";
    private static final String TAG_PERMISSIONS = "permissions";
    private static final String TAG_FLAGS = "flags";
    private static Map<Rank, RankPair> promotionRanks = new EnumMap<Rank, RankPair>(Rank.class);
    private Map<UUID, Player> players = new HashMap<UUID, Player>();
    private Map<Rank, Integer> permissions = new EnumMap<Rank, Integer>(Rank.class);
    private boolean dirty = false;

    public Permissions() {
        this.permissions.put(Rank.OWNER, 0);
        this.setPermission(Rank.OWNER, Action.ACCESS_HUTS);
        this.setPermission(Rank.OWNER, Action.PLACE_HUTS);
        this.setPermission(Rank.OWNER, Action.BREAK_HUTS);
        this.setPermission(Rank.OWNER, Action.CAN_PROMOTE);
        this.setPermission(Rank.OWNER, Action.CAN_DEMOTE);
        this.setPermission(Rank.OWNER, Action.SEND_MESSAGES);
        this.setPermission(Rank.OWNER, Action.EDIT_PERMISSIONS);
        this.permissions.put(Rank.OFFICER, 0);
        this.setPermission(Rank.OFFICER, Action.ACCESS_HUTS);
        this.setPermission(Rank.OFFICER, Action.PLACE_HUTS);
        this.setPermission(Rank.OFFICER, Action.BREAK_HUTS);
        this.setPermission(Rank.OFFICER, Action.CAN_PROMOTE);
        this.setPermission(Rank.OFFICER, Action.CAN_DEMOTE);
        this.setPermission(Rank.OFFICER, Action.SEND_MESSAGES);
        this.permissions.put(Rank.FRIEND, 0);
        this.setPermission(Rank.FRIEND, Action.ACCESS_HUTS);
        this.permissions.put(Rank.NEUTRAL, 0);
        this.permissions.put(Rank.HOSTILE, 0);
        this.setPermission(Rank.HOSTILE, Action.GUARDS_ATTACK);
    }

    public void loadPermissions(NBTTagCompound compound) {
        Rank rank;
        NBTTagList ownerTagList = compound.func_150295_c(TAG_OWNERS, 10);
        for (int i = 0; i < ownerTagList.func_74745_c(); ++i) {
            NBTTagCompound ownerCompound = ownerTagList.func_150305_b(i);
            UUID id = UUID.fromString(ownerCompound.func_74779_i(TAG_ID));
            rank = Rank.valueOf(ownerCompound.func_74779_i(TAG_RANK));
            GameProfile gameprofile = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(id);
            this.players.put(id, new Player(id, gameprofile.getName(), rank));
        }
        NBTTagList permissionsTagList = compound.func_150295_c(TAG_PERMISSIONS, 10);
        for (int i = 0; i < permissionsTagList.func_74745_c(); ++i) {
            NBTTagCompound permissionsCompound = permissionsTagList.func_150305_b(i);
            rank = Rank.valueOf(permissionsCompound.func_74779_i(TAG_RANK));
            NBTTagList flagsTagList = permissionsCompound.func_150295_c(TAG_FLAGS, 8);
            int flags = 0;
            for (int j = 0; j < flagsTagList.func_74745_c(); ++j) {
                String flag = flagsTagList.func_150307_f(j);
                flags = Utils.setFlag(flags, Action.valueOf(flag).flag);
            }
            this.permissions.put(rank, flags);
        }
    }

    public void savePermissions(NBTTagCompound compound) {
        NBTTagList ownerTagList = new NBTTagList();
        for (Player player : this.players.values()) {
            NBTTagCompound ownersCompound = new NBTTagCompound();
            ownersCompound.func_74778_a(TAG_ID, player.id.toString());
            ownersCompound.func_74778_a(TAG_RANK, player.rank.name());
            ownerTagList.func_74742_a((NBTBase)ownersCompound);
        }
        compound.func_74782_a(TAG_OWNERS, (NBTBase)ownerTagList);
        NBTTagList permissionsTagList = new NBTTagList();
        for (Map.Entry<Rank, Integer> entry : this.permissions.entrySet()) {
            NBTTagCompound permissionsCompound = new NBTTagCompound();
            permissionsCompound.func_74778_a(TAG_RANK, entry.getKey().name());
            NBTTagList flagsTagList = new NBTTagList();
            for (Action action : Action.values()) {
                if (!Utils.testFlag(entry.getValue(), action.flag)) continue;
                flagsTagList.func_74742_a((NBTBase)new NBTTagString(action.name()));
            }
            permissionsCompound.func_74782_a(TAG_FLAGS, (NBTBase)flagsTagList);
            permissionsTagList.func_74742_a((NBTBase)permissionsCompound);
        }
        compound.func_74782_a(TAG_PERMISSIONS, (NBTBase)permissionsTagList);
    }

    public Map<UUID, Player> getPlayers() {
        return Collections.unmodifiableMap(this.players);
    }

    public Set<UUID> getMessagePlayers() {
        return this.players.values().stream().filter(player -> this.hasPermission(((Player)player).rank, Action.SEND_MESSAGES)).map(player -> ((Player)player).id).collect(Collectors.toSet());
    }

    public Set<Player> getPlayersByRank(Rank rank) {
        return this.players.values().stream().filter(player -> ((Player)player).rank.equals((Object)rank)).collect(Collectors.toSet());
    }

    public Set<Player> getPlayersByRank(Set<Rank> ranks) {
        return this.players.values().stream().filter(player -> ranks.contains((Object)((Player)player).rank)).collect(Collectors.toSet());
    }

    public Map<Rank, Integer> getPermissions() {
        return this.permissions;
    }

    public Rank getRank(EntityPlayer player) {
        return this.getRank(player.func_146103_bH().getId());
    }

    @Override
    public Rank getRank(UUID id) {
        Player player = this.players.get(id);
        return player != null ? player.rank : Rank.NEUTRAL;
    }

    @Override
    public boolean hasPermission(EntityPlayer player, Action action) {
        return this.hasPermission(this.getRank(player), action);
    }

    @Override
    public boolean isColonyMember(EntityPlayer player) {
        return this.players.containsKey(player.func_146103_bH().getId());
    }

    public boolean hasPermission(Rank rank, Action action) {
        return Utils.testFlag(this.permissions.get((Object)rank), action.flag);
    }

    public final void setPermission(Rank rank, Action action) {
        int flags = this.permissions.get((Object)rank);
        if (!Utils.testFlag(flags, action.flag)) {
            this.permissions.put(rank, Utils.setFlag(flags, action.flag));
            this.markDirty();
        }
    }

    public void removePermission(Rank rank, Action action) {
        int flags = this.permissions.get((Object)rank);
        if (Utils.testFlag(flags, action.flag)) {
            this.permissions.put(rank, Utils.unsetFlag(flags, action.flag));
            this.markDirty();
        }
    }

    public void togglePermission(Rank rank, Action action) {
        this.permissions.put(rank, Utils.toggleFlag(this.permissions.get((Object)rank), action.flag));
        this.markDirty();
    }

    public boolean setPlayerRank(UUID id, Rank rank) {
        Player player = this.players.get(id);
        if (player == null) {
            GameProfile gameprofile = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(id);
            return gameprofile != null && this.addPlayer(gameprofile, rank);
        }
        player.rank = rank;
        this.markDirty();
        return true;
    }

    public boolean addPlayer(String player, Rank rank) {
        GameProfile gameprofile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(player);
        return gameprofile != null && !this.players.containsKey(gameprofile.getId()) && this.addPlayer(gameprofile, rank);
    }

    private boolean addPlayer(GameProfile gameprofile, Rank rank) {
        Player p = new Player(gameprofile.getId(), gameprofile.getName(), rank);
        this.players.put(p.id, p);
        this.markDirty();
        return true;
    }

    public boolean removePlayer(UUID id) {
        Player player = this.players.get(id);
        if (player != null && player.getRank() != Rank.OWNER && this.players.remove(id) != null) {
            this.markDirty();
            return true;
        }
        return false;
    }

    public UUID getOwner() {
        for (Map.Entry<UUID, Player> entry : this.players.entrySet()) {
            if (!entry.getValue().rank.equals((Object)Rank.OWNER)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isSubscriber(EntityPlayer player) {
        return this.isSubscriber(player.func_146103_bH().getId());
    }

    private boolean isSubscriber(UUID player) {
        return this.getRank((UUID)player).isSubscriber;
    }

    private void markDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public void serializeViewNetworkData(ByteBuf buf, Rank viewerRank) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)viewerRank.name());
        buf.writeInt(this.players.size());
        for (Map.Entry<UUID, Player> entry : this.players.entrySet()) {
            PacketUtils.writeUUID(buf, entry.getKey());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getValue().name);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getValue().rank.name());
        }
        buf.writeInt(this.permissions.size());
        for (Map.Entry<Object, Object> entry : this.permissions.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((Rank)((Object)entry.getKey())).name());
            buf.writeInt(((Integer)entry.getValue()).intValue());
        }
    }

    private static void setPromotionRanks(Rank r, Rank p, Rank d) {
        promotionRanks.put(r, new RankPair(p, d));
    }

    public static Rank getPromotionRank(Rank rank) {
        if (promotionRanks.containsKey((Object)rank)) {
            return promotionRanks.get((Object)rank).promote;
        }
        return rank;
    }

    public static Rank getDemotionRank(Rank rank) {
        if (promotionRanks.containsKey((Object)rank)) {
            return promotionRanks.get((Object)rank).demote;
        }
        return rank;
    }

    static {
        Permissions.setPromotionRanks(Rank.OFFICER, Rank.OFFICER, Rank.FRIEND);
        Permissions.setPromotionRanks(Rank.FRIEND, Rank.OFFICER, Rank.NEUTRAL);
        Permissions.setPromotionRanks(Rank.NEUTRAL, Rank.FRIEND, Rank.HOSTILE);
        Permissions.setPromotionRanks(Rank.HOSTILE, Rank.NEUTRAL, Rank.HOSTILE);
    }

    public static class View
    implements IPermissions {
        private Rank userRank = Rank.NEUTRAL;
        private Map<UUID, Player> players = new HashMap<UUID, Player>();
        private Map<Rank, Integer> permissions = new EnumMap<Rank, Integer>(Rank.class);

        public Rank getUserRank() {
            return this.userRank;
        }

        public Map<UUID, Player> getPlayers() {
            return Collections.unmodifiableMap(this.players);
        }

        public Set<Player> getPlayersByRank(Rank rank) {
            return Collections.unmodifiableSet(this.players.values().stream().filter(player -> ((Player)player).rank == rank).collect(Collectors.toSet()));
        }

        public Set<Player> getPlayersByRank(Set<Rank> ranks) {
            return Collections.unmodifiableSet(this.players.values().stream().filter(player -> ranks.contains((Object)((Player)player).rank)).collect(Collectors.toSet()));
        }

        public Map<Rank, Integer> getPermissions() {
            return this.permissions;
        }

        public Rank getRank(EntityPlayer player) {
            return this.getRank(player.func_110124_au());
        }

        @Override
        public Rank getRank(UUID id) {
            Player player = this.players.get(id);
            return player != null ? player.rank : Rank.NEUTRAL;
        }

        @Override
        public boolean hasPermission(EntityPlayer player, Action action) {
            return this.hasPermission(this.getRank(player), action);
        }

        @Override
        public boolean isColonyMember(EntityPlayer player) {
            return this.players.containsKey(player.func_110124_au());
        }

        public boolean hasPermission(UUID id, Action action) {
            return this.hasPermission(this.getRank(id), action);
        }

        public boolean hasPermission(Rank rank, Action action) {
            return Utils.testFlag(this.permissions.get((Object)rank), action.flag);
        }

        public boolean setPermission(Rank rank, Action action) {
            int flags = this.permissions.get((Object)rank);
            if (!Utils.testFlag(flags, action.flag)) {
                this.permissions.put(rank, Utils.setFlag(flags, action.flag));
                return true;
            }
            return false;
        }

        public boolean removePermission(Rank rank, Action action) {
            int flags = this.permissions.get((Object)rank);
            if (Utils.testFlag(flags, action.flag)) {
                this.permissions.put(rank, Utils.unsetFlag(flags, action.flag));
                return true;
            }
            return false;
        }

        public void togglePermission(Rank rank, Action action) {
            this.permissions.put(rank, Utils.toggleFlag(this.permissions.get((Object)rank), action.flag));
        }

        public void deserialize(ByteBuf buf) {
            this.userRank = Rank.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.players.clear();
            int numOwners = buf.readInt();
            for (int i = 0; i < numOwners; ++i) {
                UUID id = PacketUtils.readUUID(buf);
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                Rank rank = Rank.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
                this.players.put(id, new Player(id, name, rank));
            }
            this.permissions.clear();
            int numPermissions = buf.readInt();
            for (int i = 0; i < numPermissions; ++i) {
                Rank rank = Rank.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
                int flags = buf.readInt();
                this.permissions.put(rank, flags);
            }
        }
    }

    private static class RankPair {
        private Rank promote;
        private Rank demote;

        RankPair(Rank p, Rank d) {
            this.promote = p;
            this.demote = d;
        }
    }

    public static class Player {
        private UUID id;
        private String name;
        private Rank rank;

        public Player(UUID id, String name, Rank rank) {
            this.id = id;
            this.name = name;
            this.rank = rank;
        }

        public UUID getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Rank getRank() {
            return this.rank;
        }
    }

    public static enum Action {
        ACCESS_HUTS(0),
        GUARDS_ATTACK(1),
        PLACE_HUTS(2),
        BREAK_HUTS(3),
        CAN_PROMOTE(4),
        CAN_DEMOTE(5),
        SEND_MESSAGES(6),
        EDIT_PERMISSIONS(7);

        private final int flag;

        private Action(int bit) {
            this.flag = 1 << bit;
        }

        public int getFlag() {
            return this.flag;
        }
    }

    public static enum Rank {
        OWNER(true),
        OFFICER(true),
        FRIEND(true),
        NEUTRAL(false),
        HOSTILE(false);

        public final boolean isSubscriber;

        private Rank(boolean isSubscriber) {
            this.isSubscriber = isSubscriber;
        }
    }
}

