/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.colony.workorders;

import com.minecolonies.colony.CitizenData;
import com.minecolonies.colony.Colony;
import com.minecolonies.colony.buildings.AbstractBuilding;
import com.minecolonies.colony.jobs.JobBuilder;
import com.minecolonies.colony.workorders.AbstractWorkOrder;
import com.minecolonies.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.EntityUtils;
import com.minecolonies.util.LanguageHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;

public class WorkOrderBuild
extends AbstractWorkOrder {
    private static final String TAG_BUILDING = "building";
    private static final String TAG_UPGRADE_LEVEL = "upgradeLevel";
    private static final String TAG_UPGRADE_NAME = "upgrade";
    private static final String TAG_IS_CLEARED = "cleared";
    private static final String TAG_SCHEMATIC_NAME = "schematicName";
    private static final String TAG_BUILDING_ROTATION = "buildingRotation";
    protected BlockPos buildingLocation;
    protected int buildingRotation;
    protected String schematicName;
    private int upgradeLevel;
    private String upgradeName;
    protected boolean cleared;
    private boolean hasSentMessageForThisWorkOrder = false;

    public WorkOrderBuild() {
    }

    public WorkOrderBuild(AbstractBuilding building, int level) {
        this.buildingLocation = building.getID();
        this.upgradeLevel = level;
        this.upgradeName = building.getSchematicName() + level;
        this.schematicName = building.getStyle() + '/' + this.getUpgradeName();
        this.buildingRotation = building.getRotation();
        this.cleared = level > 1;
    }

    @Override
    protected AbstractWorkOrder.WorkOrderType getType() {
        return AbstractWorkOrder.WorkOrderType.BUILD;
    }

    @Override
    protected String getValue() {
        return this.upgradeName;
    }

    private String getUpgradeName() {
        return this.upgradeName;
    }

    public int getUpgradeLevel() {
        return this.upgradeLevel;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        BlockPosUtil.writeToNBT(compound, TAG_BUILDING, this.buildingLocation);
        if (!(this instanceof WorkOrderBuildDecoration)) {
            compound.func_74768_a(TAG_UPGRADE_LEVEL, this.upgradeLevel);
            compound.func_74778_a(TAG_UPGRADE_NAME, this.upgradeName);
        }
        compound.func_74757_a(TAG_IS_CLEARED, this.cleared);
        compound.func_74778_a(TAG_SCHEMATIC_NAME, this.schematicName);
        compound.func_74768_a(TAG_BUILDING_ROTATION, this.buildingRotation);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.buildingLocation = BlockPosUtil.readFromNBT(compound, TAG_BUILDING);
        if (!(this instanceof WorkOrderBuildDecoration)) {
            this.upgradeLevel = compound.func_74762_e(TAG_UPGRADE_LEVEL);
            this.upgradeName = compound.func_74779_i(TAG_UPGRADE_NAME);
        }
        this.cleared = compound.func_74767_n(TAG_IS_CLEARED);
        this.schematicName = compound.func_74779_i(TAG_SCHEMATIC_NAME);
        this.buildingRotation = compound.func_74762_e(TAG_BUILDING_ROTATION);
    }

    @Override
    public boolean isValid(Colony colony) {
        return colony.getBuilding(this.buildingLocation) != null;
    }

    @Override
    public void attemptToFulfill(Colony colony) {
        boolean sendMessage = true;
        for (CitizenData citizen : colony.getCitizens().values()) {
            JobBuilder job = citizen.getJob(JobBuilder.class);
            if (job == null) continue;
            int builderLevel = citizen.getWorkBuilding().getBuildingLevel();
            if (this.canBuildHut(builderLevel, citizen, colony)) {
                sendMessage = false;
            }
            if (job.hasWorkOrder() || !this.canBuildHut(builderLevel, citizen, colony)) continue;
            job.setWorkOrder(this);
            this.setClaimedBy(citizen);
            return;
        }
        if (sendMessage && !this.hasSentMessageForThisWorkOrder) {
            this.hasSentMessageForThisWorkOrder = true;
            LanguageHandler.sendPlayersLocalizedMessage(EntityUtils.getPlayersFromUUID(colony.getWorld(), colony.getPermissions().getMessagePlayers()), "entity.builder.messageBuilderNecessary", this.upgradeLevel);
        }
    }

    private boolean canBuildHut(int builderLevel, CitizenData citizen, Colony colony) {
        return builderLevel >= this.upgradeLevel || builderLevel == 2 || citizen.getWorkBuilding().getID().equals((Object)this.buildingLocation) || this.isLocationTownhall(colony, this.buildingLocation);
    }

    private boolean isLocationTownhall(Colony colony, BlockPos buildingLocation) {
        return colony.hasTownHall() && colony.getTownHall().getID().equals((Object)buildingLocation);
    }

    public BlockPos getBuildingLocation() {
        return this.buildingLocation;
    }

    public String getSchematicName() {
        return this.schematicName;
    }

    public int getRotation() {
        return this.buildingRotation;
    }

    public void setCleared(boolean cleared) {
        this.cleared = cleared;
    }

    public boolean isCleared() {
        return this.cleared;
    }
}

