/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.basic;

import com.minecolonies.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.colony.jobs.AbstractJob;
import com.minecolonies.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.entity.ai.util.AIState;
import com.minecolonies.entity.ai.util.AITarget;
import com.minecolonies.inventory.InventoryCitizen;
import com.minecolonies.util.EntityUtils;
import com.minecolonies.util.InventoryFunctions;
import com.minecolonies.util.InventoryUtils;
import com.minecolonies.util.Log;
import com.minecolonies.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIBasic<J extends AbstractJob>
extends AbstractAISkeleton<J> {
    private static final int DELAY_RECHECK = 10;
    private static final int DEFAULT_RANGE_FOR_DELAY = 4;
    private static final int ACTIONS_UNTIL_DUMP = 32;
    protected BlockPos currentWorkingLocation = null;
    protected BlockPos currentStandingLocation = null;
    private int delay = 0;
    private List<ItemStack> itemsCurrentlyNeeded = new ArrayList<ItemStack>();
    private List<ItemStack> itemsNeeded = new ArrayList<ItemStack>();
    private boolean needsShovel = false;
    private boolean needsAxe = false;
    private boolean needsHoe = false;
    private boolean needsPickaxe = false;
    private int needsPickaxeLevel = -1;
    private boolean hasDelayed = false;
    private int actionsDone = 0;

    protected AbstractEntityAIBasic(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget(AIState.INIT, this::initSafetyChecks), new AITarget(this::updateVisualState), new AITarget(this::waitingForSomething, this::getState), new AITarget(() -> !this.itemsCurrentlyNeeded.isEmpty(), this::waitForNeededItems), new AITarget(() -> this.needsShovel, this::waitForShovel), new AITarget(() -> this.needsAxe, this::waitForAxe), new AITarget(() -> this.needsHoe, this::waitForHoe), new AITarget(() -> this.needsPickaxe, this::waitForPickaxe), new AITarget(AIState.INVENTORY_FULL, this::dumpInventory), new AITarget(this::inventoryNeedsDump, AIState.INVENTORY_FULL));
    }

    private boolean inventoryNeedsDump() {
        return this.worker.isInventoryFull() || this.actionsDone >= this.getActionsDoneUntilDumping() || this.wantInventoryDumped();
    }

    protected boolean wantInventoryDumped() {
        return false;
    }

    protected int getActionsDoneUntilDumping() {
        return 32;
    }

    private AIState initSafetyChecks() {
        if (null == this.getOwnBuilding()) {
            return AIState.INIT;
        }
        return AIState.IDLE;
    }

    @Nullable
    protected AbstractBuildingWorker getOwnBuilding() {
        return this.worker.getWorkBuilding();
    }

    private AIState updateVisualState() {
        this.job.setNameTag(this.getState().toString());
        this.updateRenderMetaData();
        return null;
    }

    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata("");
    }

    private boolean waitingForSomething() {
        if (this.delay > 0) {
            if (this.currentStandingLocation != null && !this.worker.isWorkerAtSiteWithMove(this.currentStandingLocation, 4)) {
                return true;
            }
            this.worker.hitBlockWithToolInHand(this.currentWorkingLocation);
            --this.delay;
            return true;
        }
        this.clearWorkTarget();
        return false;
    }

    private void clearWorkTarget() {
        this.currentStandingLocation = null;
        this.currentWorkingLocation = null;
        this.delay = 0;
    }

    private AIState waitForNeededItems() {
        this.delay = 10;
        return this.lookForNeededItems();
    }

    private AIState lookForNeededItems() {
        this.syncNeededItemsWithInventory();
        if (this.itemsCurrentlyNeeded.isEmpty()) {
            this.itemsNeeded.clear();
            this.job.clearItemsNeeded();
            return AIState.IDLE;
        }
        if (!this.walkToBuilding()) {
            this.delay += 10;
            ItemStack first = this.itemsCurrentlyNeeded.get(0);
            if (this.isInHut(first)) {
                return AIState.NEEDS_ITEM;
            }
            this.requestWithoutSpam(first.func_82833_r(), 10);
        }
        return AIState.NEEDS_ITEM;
    }

    private void syncNeededItemsWithInventory() {
        this.job.clearItemsNeeded();
        this.itemsNeeded.forEach(this.job::addItemNeeded);
        InventoryUtils.getInventoryAsList(this.worker.getInventoryCitizen()).forEach(this.job::removeItemNeeded);
        this.itemsCurrentlyNeeded = new ArrayList<ItemStack>(this.job.getItemsNeeded());
    }

    private boolean isInHut(@Nullable ItemStack is) {
        AbstractBuildingWorker buildingMiner = this.getOwnBuilding();
        return buildingMiner != null && is != null && InventoryFunctions.matchFirstInInventory((IInventory)buildingMiner.getTileEntity(), stack -> stack != null && is.func_77969_a(stack), this::takeItemStackFromChest);
    }

    private void requestWithoutSpam(@NotNull String chat, int ticks) {
        this.chatSpamFilter.requestWithoutSpam(chat, ticks);
    }

    protected final boolean walkToBuilding() {
        AbstractBuildingWorker ownBuilding = this.getOwnBuilding();
        return ownBuilding == null || this.walkToBlock(ownBuilding.getLocation());
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand) {
        return this.walkToBlock(stand, 4);
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand, int range) {
        if (!EntityUtils.isWorkerAtSite(this.worker, stand.func_177958_n(), stand.func_177956_o(), stand.func_177952_p(), range)) {
            this.workOnBlock(null, stand, 1);
            return true;
        }
        return false;
    }

    private void workOnBlock(@Nullable BlockPos target, @Nullable BlockPos stand, int timeout) {
        this.currentWorkingLocation = target;
        this.currentStandingLocation = stand;
        this.delay = timeout;
    }

    private void takeItemStackFromChest(int slot) {
        AbstractBuildingWorker ownBuilding = this.getOwnBuilding();
        if (ownBuilding == null) {
            return;
        }
        InventoryUtils.takeStackInSlot((IInventory)ownBuilding.getTileEntity(), this.worker.getInventoryCitizen(), slot);
    }

    private AIState waitForShovel() {
        if (this.checkForShovel()) {
            this.delay += 10;
            return AIState.NEEDS_SHOVEL;
        }
        return AIState.IDLE;
    }

    private boolean checkForShovel() {
        this.needsShovel = this.checkForTool("shovel");
        return this.needsShovel;
    }

    private boolean checkForTool(String tool) {
        boolean needsTool;
        boolean bl = needsTool = !InventoryFunctions.matchFirstInInventory(this.worker.getInventoryCitizen(), stack -> Utils.isTool(stack, tool), xva$0 -> InventoryFunctions.doNothing(xva$0));
        if (!needsTool) {
            return false;
        }
        this.delay += 10;
        if (this.walkToBuilding()) {
            return true;
        }
        if (this.isToolInHut(tool)) {
            return false;
        }
        this.requestWithoutSpam(tool, 10);
        return true;
    }

    private boolean isToolInHut(String tool) {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return buildingWorker != null && InventoryFunctions.matchFirstInInventory((IInventory)buildingWorker.getTileEntity(), stack -> Utils.isTool(stack, tool), this::takeItemStackFromChest);
    }

    private AIState waitForAxe() {
        if (this.checkForAxe()) {
            this.delay += 10;
            return AIState.NEEDS_AXE;
        }
        return AIState.IDLE;
    }

    protected boolean checkForAxe() {
        this.needsAxe = this.checkForTool("axe");
        return this.needsAxe;
    }

    private AIState waitForHoe() {
        if (this.checkForHoe()) {
            this.delay += 10;
            return AIState.NEEDS_HOE;
        }
        return AIState.IDLE;
    }

    private boolean checkForHoe() {
        this.needsHoe = this.checkForTool("hoe");
        return this.needsHoe;
    }

    private AIState waitForPickaxe() {
        if (this.checkForPickaxe(this.needsPickaxeLevel)) {
            this.delay += 10;
            return AIState.NEEDS_PICKAXE;
        }
        return AIState.IDLE;
    }

    private boolean checkForPickaxe(int minlevel) {
        this.needsPickaxe = !InventoryFunctions.matchFirstInInventory(this.worker.getInventoryCitizen(), stack -> Utils.checkIfPickaxeQualifies(minlevel, Utils.getMiningLevel(stack, "pickaxe")), xva$0 -> InventoryFunctions.doNothing(xva$0));
        this.delay += 10;
        if (this.needsPickaxe) {
            this.needsPickaxeLevel = minlevel;
            if (this.walkToBuilding()) {
                return false;
            }
            if (this.isPickaxeInHut(minlevel)) {
                return true;
            }
            this.requestWithoutSpam("Pickaxe at least level " + minlevel, 10);
        }
        return this.needsPickaxe;
    }

    private boolean isPickaxeInHut(int minlevel) {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return buildingWorker != null && InventoryFunctions.matchFirstInInventory((IInventory)buildingWorker.getTileEntity(), stack -> Utils.checkIfPickaxeQualifies(minlevel, Utils.getMiningLevel(stack, "pickaxe")), this::takeItemStackFromChest);
    }

    private AIState dumpInventory() {
        if (this.dumpOneMoreSlot()) {
            this.delay += 10;
            return AIState.INVENTORY_FULL;
        }
        if (this.isInventoryAndChestFull()) {
            this.chatSpamFilter.talkWithoutSpam("entity.worker.inventoryFullChestFull", new String[0]);
        }
        this.itemsNiceToHave().forEach(this::isInHut);
        this.clearActionsDone();
        return AIState.IDLE;
    }

    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        return new ArrayList<ItemStack>();
    }

    private boolean dumpOneMoreSlot() {
        return this.dumpOneMoreSlot(this::neededForWorker);
    }

    private boolean dumpOneMoreSlot(Predicate<ItemStack> keepIt) {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return this.walkToBuilding() || InventoryFunctions.matchFirstInInventory((IInventory)this.worker.getInventoryCitizen(), (i, stack) -> {
            if (buildingWorker == null || stack == null || keepIt.test((ItemStack)stack)) {
                return false;
            }
            ItemStack returnStack = InventoryUtils.setStack((IInventory)buildingWorker.getTileEntity(), stack);
            if (returnStack == null) {
                this.worker.getInventoryCitizen().func_70298_a((int)i, stack.field_77994_a);
                return true;
            }
            this.worker.getInventoryCitizen().func_70298_a((int)i, stack.field_77994_a - returnStack.field_77994_a);
            return stack.field_77994_a != returnStack.field_77994_a;
        });
    }

    private boolean isInventoryAndChestFull() {
        AbstractBuildingWorker buildingWorker = this.getOwnBuilding();
        return InventoryUtils.isInventoryFull(this.worker.getInventoryCitizen()) && buildingWorker != null && InventoryUtils.isInventoryFull((IInventory)buildingWorker.getTileEntity());
    }

    private void clearActionsDone() {
        this.actionsDone = 0;
    }

    protected boolean checkOrRequestItems(ItemStack ... items) {
        if (items == null) {
            return false;
        }
        boolean allClear = true;
        for (ItemStack stack : items) {
            int countOfItem;
            if (stack == null || stack.func_77973_b() == null || (countOfItem = this.worker.getItemCountInInventory(stack.func_77973_b())) >= stack.field_77994_a) continue;
            int itemsLeft = stack.field_77994_a - countOfItem;
            ItemStack requiredStack = new ItemStack(stack.func_77973_b(), itemsLeft);
            this.itemsCurrentlyNeeded.add(requiredStack);
            allClear = false;
        }
        if (allClear) {
            return false;
        }
        this.itemsNeeded.clear();
        Collections.addAll(this.itemsNeeded, items);
        return true;
    }

    @NotNull
    protected InventoryCitizen getInventory() {
        return this.worker.getInventoryCitizen();
    }

    protected boolean neededForWorker(@Nullable ItemStack stack) {
        return false;
    }

    protected final boolean holdEfficientTool(@NotNull Block target) {
        int bestSlot = this.getMostEfficientTool(target);
        if (bestSlot >= 0) {
            this.worker.setHeldItem(bestSlot);
            return true;
        }
        this.requestTool(target);
        return false;
    }

    private void requestTool(@NotNull Block target) {
        String tool = target.getHarvestTool(target.func_176223_P());
        int required = target.getHarvestLevel(target.func_176223_P());
        this.updateToolFlag(tool, required);
    }

    private void updateToolFlag(@NotNull String tool, int required) {
        switch (tool) {
            case "axe": {
                this.checkForAxe();
                break;
            }
            case "shovel": {
                this.checkForShovel();
                break;
            }
            case "hoe": {
                this.checkForHoe();
                break;
            }
            case "pickaxe": {
                this.checkForPickaxe(required);
                break;
            }
            default: {
                Log.logger.error("Invalid tool " + tool + " not implemented as tool!");
            }
        }
    }

    private int getMostEfficientTool(@NotNull Block target) {
        String tool = target.getHarvestTool(target.func_176223_P());
        int required = target.getHarvestLevel(target.func_176223_P());
        int bestSlot = -1;
        int bestLevel = Integer.MAX_VALUE;
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            int level = Utils.getMiningLevel(item, tool);
            if (level < required || level >= bestLevel) continue;
            bestSlot = i;
            bestLevel = level;
        }
        return bestSlot;
    }

    protected final boolean hasNotDelayed(int time) {
        if (!this.hasDelayed) {
            this.setDelay(time);
            this.hasDelayed = true;
            return true;
        }
        this.hasDelayed = false;
        return false;
    }

    protected final void setDelay(int timeout) {
        this.delay = timeout;
    }

    protected final void incrementActionsDone() {
        ++this.actionsDone;
    }
}

