/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.citizen.lumberjack;

import com.minecolonies.util.BlockPosUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Tree {
    private static final String TAG_LOCATION = "Location";
    private static final String TAG_LOGS = "Logs";
    private static final String TAG_STUMPS = "Stumps";
    private static final int NUMBER_OF_LEAVES = 3;
    private BlockPos location;
    private LinkedList<BlockPos> woodBlocks;
    private boolean isTree;
    private ArrayList<BlockPos> stumpLocations;
    private BlockPlanks.EnumType variant;

    private Tree() {
        this.isTree = true;
    }

    public Tree(World world, BlockPos log) {
        Block block = BlockPosUtil.getBlock(world, log);
        if (block.isWood((IBlockAccess)world, log)) {
            this.variant = (BlockPlanks.EnumType)world.func_180495_p(log).func_177229_b((IProperty)BlockNewLog.field_176300_b);
            this.location = Tree.getBaseLog((IBlockAccess)world, log);
            this.woodBlocks = new LinkedList();
            this.checkTree(world, Tree.getTopLog((IBlockAccess)world, log));
            this.stumpLocations = new ArrayList();
        }
    }

    public void findLogs(World world) {
        this.addAndSearch(world, this.location);
        Collections.sort(this.woodBlocks, (c1, c2) -> (int)(c1.func_177951_i((Vec3i)this.location) - c2.func_177951_i((Vec3i)this.location)));
        if (this.getStumpLocations().isEmpty()) {
            this.fillTreeStumps(world, this.location.func_177956_o());
        }
    }

    public void fillTreeStumps(World world, int yLevel) {
        for (BlockPos pos : this.woodBlocks) {
            if (pos.func_177956_o() != yLevel) continue;
            this.stumpLocations.add(Tree.getBaseLog((IBlockAccess)world, pos));
        }
    }

    public void addBaseLog() {
        this.woodBlocks.add(new BlockPos((Vec3i)this.location));
    }

    private void addAndSearch(World world, BlockPos log) {
        this.woodBlocks.add(log);
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos temp = log.func_177982_a(x, y, z);
                    if (!BlockPosUtil.getBlock(world, temp).isWood(null, new BlockPos(0, 0, 0)) || this.woodBlocks.contains(temp)) continue;
                    this.addAndSearch(world, temp);
                }
            }
        }
    }

    private void checkTree(World world, BlockPos topLog) {
        if (!world.func_180495_p(new BlockPos(this.location.func_177958_n(), this.location.func_177956_o() - 1, this.location.func_177952_p())).func_177230_c().func_149688_o().func_76220_a()) {
            return;
        }
        int leafCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    if (!world.func_180495_p(new BlockPos(topLog.func_177958_n() + x, topLog.func_177956_o() + y, topLog.func_177952_p() + z)).func_177230_c().func_149688_o().equals(Material.field_151584_j) || ++leafCount < 3) continue;
                    this.isTree = true;
                    return;
                }
            }
        }
    }

    private static BlockPos getBaseLog(IBlockAccess world, BlockPos pos) {
        BlockPos basePos = pos;
        while (world.func_180495_p(basePos.func_177977_b()).func_177230_c().isWood(world, basePos)) {
            basePos = basePos.func_177977_b();
        }
        return basePos;
    }

    private static BlockPos getTopLog(IBlockAccess world, BlockPos pos) {
        BlockPos topPos = pos;
        while (world.func_180495_p(topPos.func_177984_a()).func_177230_c().isWood(world, topPos.func_177977_b())) {
            topPos = topPos.func_177984_a();
        }
        return topPos;
    }

    public static boolean checkTree(IBlockAccess world, BlockPos pos) {
        if (!world.func_180495_p(pos).func_177230_c().isWood(world, pos)) {
            return false;
        }
        BlockPos basePos = Tree.getBaseLog(world, pos);
        return world.func_180495_p(basePos.func_177977_b()).func_177230_c().func_149688_o().func_76220_a() && world.func_180495_p(basePos.func_177977_b()).func_177230_c() != Blocks.field_150347_e && Tree.hasEnoughLeaves(world, pos);
    }

    private static boolean hasEnoughLeaves(IBlockAccess world, BlockPos pos) {
        BlockPos topPos = Tree.getTopLog(world, pos);
        int leafCount = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -1; dy <= 1; ++dy) {
                    if (!world.func_180495_p(topPos.func_177982_a(dx, dy, dz)).func_177230_c().func_149688_o().equals(Material.field_151584_j) || ++leafCount < 3) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Tree readFromNBT(NBTTagCompound compound) {
        Tree tree = new Tree();
        tree.location = BlockPosUtil.readFromNBT(compound, TAG_LOCATION);
        tree.woodBlocks = new LinkedList();
        NBTTagList logs = compound.func_150295_c(TAG_LOGS, 10);
        for (int i = 0; i < logs.func_74745_c(); ++i) {
            tree.woodBlocks.add(BlockPosUtil.readFromNBTTagList(logs, i));
        }
        tree.stumpLocations = new ArrayList();
        NBTTagList stumps = compound.func_150295_c(TAG_STUMPS, 10);
        for (int i = 0; i < stumps.func_74745_c(); ++i) {
            tree.stumpLocations.add(BlockPosUtil.readFromNBTTagList(stumps, i));
        }
        return tree;
    }

    public BlockPos pollNextLog() {
        return this.woodBlocks.poll();
    }

    public BlockPos peekNextLog() {
        return this.woodBlocks.peek();
    }

    public boolean hasLogs() {
        return !this.woodBlocks.isEmpty();
    }

    public List<BlockPos> getStumpLocations() {
        return new ArrayList<BlockPos>(this.stumpLocations);
    }

    public void removeStump(BlockPos pos) {
        this.stumpLocations.remove(pos);
    }

    public BlockPlanks.EnumType getVariant() {
        return this.variant;
    }

    public double squareDistance(Tree other) {
        return this.getLocation().func_177951_i((Vec3i)other.getLocation());
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public boolean equals(Object tree) {
        return tree != null && tree.getClass() == this.getClass() && ((Tree)tree).getLocation().equals((Object)this.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public void writeToNBT(NBTTagCompound compound) {
        if (!this.isTree) {
            return;
        }
        BlockPosUtil.writeToNBT(compound, TAG_LOCATION, this.location);
        NBTTagList logs = new NBTTagList();
        for (BlockPos log : this.woodBlocks) {
            BlockPosUtil.writeToNBTTagList(logs, log);
        }
        compound.func_74782_a(TAG_LOGS, (NBTBase)logs);
        NBTTagList stumps = new NBTTagList();
        for (BlockPos stump : this.stumpLocations) {
            BlockPosUtil.writeToNBTTagList(stumps, stump);
        }
        compound.func_74782_a(TAG_STUMPS, (NBTBase)stumps);
    }
}

