/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.citizen.miner;

import com.minecolonies.blocks.AbstractBlockHut;
import com.minecolonies.colony.buildings.BuildingMiner;
import com.minecolonies.colony.jobs.JobMiner;
import com.minecolonies.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.entity.ai.citizen.miner.Level;
import com.minecolonies.entity.ai.citizen.miner.Node;
import com.minecolonies.entity.ai.util.AIState;
import com.minecolonies.entity.ai.util.AITarget;
import com.minecolonies.util.Log;
import com.minecolonies.util.SchematicWrapper;
import com.minecolonies.util.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockOre;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIStructureMiner
extends AbstractEntityAIStructure<JobMiner> {
    private static final String RENDER_META_TORCH = "Torch";
    private static final int NODE_DISTANCE = 7;
    private static final int MAX_BLOCKS_MINED = 192;
    private static final Set<Block> notReplacedInSecuringMine = new HashSet<Block>(Arrays.asList(Blocks.field_150347_e, Blocks.field_150348_b, Blocks.field_150346_d));
    public static final int DELAY_TIMEOUT = 10;
    public static final int LADDER_SEARCH_RANGE = 10;
    public static final int SHAFT_RADIUS = 3;
    public static final int SAFE_CHECK_RANGE = 5;
    public static final int SAFE_CHECK_UPPER_BOUND = 4;
    public static final int SAFE_CHECK_LOWER_BOUND = -7;
    private BlockPos currentWorkingLocation;
    private BlockPos currentStandingPosition;
    private Node workingNode = null;
    private boolean requestedBlock = false;
    private boolean buildStructure = false;

    public EntityAIStructureMiner(JobMiner job) {
        super(job);
        super.registerTargets(new AITarget(AIState.IDLE, AIState.START_WORKING), new AITarget(AIState.START_WORKING, this::startWorkingAtOwnBuilding), new AITarget(AIState.PREPARING, this::prepareForMining), new AITarget(AIState.MINER_SEARCHING_LADDER, this::lookForLadder), new AITarget(AIState.MINER_WALKING_TO_LADDER, this::goToLadder), new AITarget(AIState.MINER_CHECK_MINESHAFT, this::checkMineShaft), new AITarget(AIState.MINER_MINING_SHAFT, this::doShaftMining), new AITarget(AIState.MINER_BUILDING_SHAFT, this::doShaftBuilding), new AITarget(AIState.MINER_MINING_NODE, this::doNodeMining));
        this.worker.setSkillModifier(2 * this.worker.getCitizenData().getStrength() + this.worker.getCitizenData().getEndurance());
        this.worker.func_98053_h(true);
    }

    private AIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return AIState.START_WORKING;
        }
        return AIState.PREPARING;
    }

    private AIState prepareForMining() {
        if (!this.getOwnBuilding().hasFoundLadder()) {
            return AIState.MINER_SEARCHING_LADDER;
        }
        return AIState.MINER_CHECK_MINESHAFT;
    }

    @Override
    protected BuildingMiner getOwnBuilding() {
        return (BuildingMiner)this.worker.getWorkBuilding();
    }

    private AIState goToLadder() {
        if (this.walkToLadder()) {
            return AIState.MINER_WALKING_TO_LADDER;
        }
        return AIState.MINER_CHECK_MINESHAFT;
    }

    private boolean walkToLadder() {
        return this.walkToBlock(this.getOwnBuilding().getLadderLocation());
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 192;
    }

    private AIState checkMineShaft() {
        if (this.getLastLadder(this.getOwnBuilding().getLadderLocation()) < this.getOwnBuilding().getDepthLimit()) {
            if (this.getOwnBuilding().getNumberOfLevels() == 0) {
                this.chatSpamFilter.talkWithoutSpam("entity.miner.messageRequiresBetterHut", new String[0]);
                this.getOwnBuilding().clearedShaft = false;
                return AIState.IDLE;
            }
            this.getOwnBuilding().clearedShaft = true;
            return AIState.MINER_MINING_NODE;
        }
        this.getOwnBuilding().clearedShaft = false;
        return AIState.MINER_MINING_SHAFT;
    }

    @Override
    protected void updateRenderMetaData() {
        String renderMetaData = this.getRenderMetaTorch();
        this.worker.setRenderMetadata(renderMetaData);
    }

    private String getRenderMetaTorch() {
        if (this.worker.hasItemInInventory(Blocks.field_150478_aa)) {
            return RENDER_META_TORCH;
        }
        return "";
    }

    @Override
    protected boolean neededForWorker(@Nullable ItemStack stack) {
        return Utils.isMiningTool(stack);
    }

    @Override
    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        return Arrays.asList(new ItemStack(Blocks.field_150468_ap), new ItemStack(Blocks.field_150344_f), new ItemStack(Blocks.field_180407_aO), new ItemStack(Blocks.field_150478_aa), new ItemStack(Blocks.field_150347_e));
    }

    private AIState lookForLadder() {
        BuildingMiner buildingMiner = this.getOwnBuilding();
        if (buildingMiner.hasFoundLadder() && buildingMiner.getLadderLocation() != null) {
            if (this.world.func_180495_p(buildingMiner.getLadderLocation()).func_177230_c() == Blocks.field_150468_ap) {
                return AIState.MINER_WALKING_TO_LADDER;
            }
            buildingMiner.setFoundLadder(false);
            buildingMiner.setLadderLocation(null);
        }
        int posX = buildingMiner.getLocation().func_177958_n();
        int posY = buildingMiner.getLocation().func_177956_o() + 2;
        int posZ = buildingMiner.getLocation().func_177952_p();
        for (int y = posY - 10; y < posY; ++y) {
            for (int x = posX - 10; x < posX + 10; ++x) {
                for (int z = posZ - 10; z < posZ + 10; ++z) {
                    this.tryFindLadderAt(new BlockPos(x, y, z));
                }
            }
        }
        return AIState.MINER_SEARCHING_LADDER;
    }

    private void tryFindLadderAt(BlockPos pos) {
        BuildingMiner buildingMiner = this.getOwnBuilding();
        if (buildingMiner.hasFoundLadder()) {
            return;
        }
        if (this.world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150468_ap)) {
            int firstLadderY = this.getFirstLadder(pos);
            buildingMiner.setLadderLocation(new BlockPos(pos.func_177958_n(), firstLadderY, pos.func_177952_p()));
            this.validateLadderOrientation();
        }
    }

    private void validateLadderOrientation() {
        BuildingMiner buildingMiner = this.getOwnBuilding();
        EnumFacing ladderOrientation = (EnumFacing)this.world.func_180495_p(buildingMiner.getLadderLocation()).func_177229_b((IProperty)BlockLadder.field_176382_a);
        if (ladderOrientation == EnumFacing.WEST) {
            buildingMiner.setVectorX(-1);
            buildingMiner.setVectorZ(0);
        } else if (ladderOrientation == EnumFacing.EAST) {
            buildingMiner.setVectorX(1);
            buildingMiner.setVectorZ(0);
        } else if (ladderOrientation == EnumFacing.SOUTH) {
            buildingMiner.setVectorX(0);
            buildingMiner.setVectorZ(1);
        } else if (ladderOrientation == EnumFacing.NORTH) {
            buildingMiner.setVectorX(0);
            buildingMiner.setVectorZ(-1);
        } else {
            throw new IllegalStateException("Ladder metadata was " + ladderOrientation);
        }
        int x = buildingMiner.getLadderLocation().func_177958_n();
        int y = buildingMiner.getLadderLocation().func_177956_o();
        int z = buildingMiner.getLadderLocation().func_177952_p();
        buildingMiner.setCobbleLocation(new BlockPos(x - buildingMiner.getVectorX(), y, z - buildingMiner.getVectorZ()));
        buildingMiner.setShaftStart(new BlockPos(x, this.getLastLadder(buildingMiner.getLadderLocation()) - 1, z));
        buildingMiner.setFoundLadder(true);
    }

    private AIState doShaftMining() {
        this.currentWorkingLocation = this.getNextBlockInShaftToMine();
        if (this.currentWorkingLocation == null) {
            return this.advanceLadder(AIState.MINER_MINING_SHAFT);
        }
        this.mineBlock(this.currentWorkingLocation, this.currentStandingPosition);
        return AIState.MINER_MINING_SHAFT;
    }

    private AIState advanceLadder(AIState state) {
        if (this.getOwnBuilding().getStartingLevelShaft() >= 4) {
            return AIState.MINER_BUILDING_SHAFT;
        }
        if (this.checkOrRequestItems(new ItemStack(Blocks.field_150347_e, 2), new ItemStack(Blocks.field_150468_ap))) {
            return state;
        }
        BlockPos safeCobble = new BlockPos(this.getOwnBuilding().getLadderLocation().func_177958_n(), this.getLastLadder(this.getOwnBuilding().getLadderLocation()) - 2, this.getOwnBuilding().getLadderLocation().func_177952_p());
        int xOffset = 3 * this.getOwnBuilding().getVectorX();
        int zOffset = 3 * this.getOwnBuilding().getVectorZ();
        for (int x = -5 + xOffset; x <= 5 + xOffset; ++x) {
            for (int z = -5 + zOffset; z <= 5 + zOffset; ++z) {
                BlockPos curBlock = new BlockPos(safeCobble.func_177958_n() + x, safeCobble.func_177956_o(), safeCobble.func_177952_p() + z);
                if (this.secureBlock(curBlock, this.currentStandingPosition)) continue;
                return state;
            }
        }
        BlockPos safeStand = new BlockPos(this.getOwnBuilding().getLadderLocation().func_177958_n(), this.getLastLadder(this.getOwnBuilding().getLadderLocation()), this.getOwnBuilding().getLadderLocation().func_177952_p());
        BlockPos nextLadder = new BlockPos(this.getOwnBuilding().getLadderLocation().func_177958_n(), this.getLastLadder(this.getOwnBuilding().getLadderLocation()) - 1, this.getOwnBuilding().getLadderLocation().func_177952_p());
        BlockPos nextCobble = new BlockPos(this.getOwnBuilding().getCobbleLocation().func_177958_n(), this.getLastLadder(this.getOwnBuilding().getLadderLocation()) - 1, this.getOwnBuilding().getCobbleLocation().func_177952_p());
        if (!this.mineBlock(nextCobble, safeStand) || !this.mineBlock(nextLadder, safeStand)) {
            return state;
        }
        IBlockState metadata = this.getBlockState(safeStand);
        this.setBlockFromInventory(nextCobble, Blocks.field_150347_e);
        this.setBlockFromInventory(nextLadder, Blocks.field_150468_ap, metadata);
        this.getOwnBuilding().incrementStartingLevelShaft();
        return AIState.MINER_CHECK_MINESHAFT;
    }

    private IBlockState getBlockState(BlockPos pos) {
        return this.world.func_180495_p(pos);
    }

    private BlockPos getNextBlockInShaftToMine() {
        BlockPos curBlock;
        double distance;
        int z;
        int x;
        Block block;
        BlockPos ladderPos = this.getOwnBuilding().getLadderLocation();
        int lastLadder = this.getLastLadder(ladderPos);
        if (this.currentWorkingLocation == null) {
            this.currentWorkingLocation = new BlockPos(ladderPos.func_177958_n(), lastLadder + 1, ladderPos.func_177952_p());
        }
        if ((block = this.getBlock(this.currentWorkingLocation)) != null && block != Blocks.field_150350_a && block != Blocks.field_150468_ap) {
            return this.currentWorkingLocation;
        }
        this.currentStandingPosition = this.currentWorkingLocation;
        BlockPos nextBlockToMine = null;
        double bestDistance = Double.MAX_VALUE;
        int xOffset = 3 * this.getOwnBuilding().getVectorX();
        int zOffset = 3 * this.getOwnBuilding().getVectorZ();
        for (x = 3 + xOffset; x >= -3 + xOffset; --x) {
            for (z = -3 + zOffset; z <= 3 + zOffset; ++z) {
                if (x == 0 && 0 == z || !((distance = (curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder, ladderPos.func_177952_p() + z)).func_177951_i((Vec3i)ladderPos) + Math.pow(curBlock.func_177951_i((Vec3i)this.currentWorkingLocation), 2.0)) < bestDistance) || this.world.func_175623_d(curBlock)) continue;
                nextBlockToMine = curBlock;
                bestDistance = distance;
            }
        }
        bestDistance = Double.MAX_VALUE;
        if (nextBlockToMine != null) {
            for (x = 1; x >= -1; --x) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && 0 == z || !((distance = (curBlock = new BlockPos(nextBlockToMine.func_177958_n() + x, lastLadder, nextBlockToMine.func_177952_p() + z)).func_177951_i((Vec3i)ladderPos)) < bestDistance) || !this.world.func_175623_d(curBlock)) continue;
                    this.currentStandingPosition = curBlock;
                    bestDistance = distance;
                }
            }
        }
        return nextBlockToMine;
    }

    private boolean buildNextBlockInShaft() {
        int normalizedZ;
        int z;
        int x;
        BlockPos ladderPos = this.getOwnBuilding().getLadderLocation();
        int lastLadder = this.getLastLadder(ladderPos) + 1;
        int xOffset = 3 * this.getOwnBuilding().getVectorX();
        int zOffset = 3 * this.getOwnBuilding().getVectorZ();
        for (x = -5 + xOffset; x <= 5 + xOffset; ++x) {
            for (z = -5 + zOffset; z <= 5 + zOffset; ++z) {
                for (int y = 4; y >= -7; --y) {
                    if (x == 0 && 0 == z || lastLadder + y <= 1) continue;
                    BlockPos curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder + y, ladderPos.func_177952_p() + z);
                    int normalizedX = x - xOffset;
                    int normalizedZ2 = z - zOffset;
                    if (Math.abs(normalizedX) <= 3 && Math.abs(normalizedZ2) <= 3 || notReplacedInSecuringMine.contains(this.world.func_180495_p(curBlock).func_177230_c())) continue;
                    if (!this.mineBlock(curBlock, this.getOwnBuilding().getLocation())) {
                        this.setDelay(1);
                        return true;
                    }
                    if (this.checkOrRequestItems(new ItemStack(Blocks.field_150347_e))) {
                        return true;
                    }
                    this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
                    return true;
                }
            }
        }
        for (x = -3 + xOffset; x <= 3 + xOffset; ++x) {
            for (z = -3 + zOffset; z <= 3 + zOffset; ++z) {
                if (x == 0 && 0 == z) continue;
                BlockPos curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder, ladderPos.func_177952_p() + z);
                int normalizedX = x - xOffset;
                normalizedZ = z - zOffset;
                if (Math.abs(normalizedX) < 2 && Math.abs(normalizedZ) < 2 || this.world.func_180495_p(curBlock).func_177230_c() == this.getOwnBuilding().getFloorBlock()) continue;
                this.setDelay(10);
                if (this.checkOrRequestItems(new ItemStack(this.getOwnBuilding().getFloorBlock()))) {
                    return true;
                }
                this.setBlockFromInventory(curBlock, this.getOwnBuilding().getFloorBlock());
                return true;
            }
        }
        for (x = -3 + xOffset; x <= 3 + xOffset; ++x) {
            for (z = -3 + zOffset; z <= 3 + zOffset; ++z) {
                if (x == 0 && 0 == z) continue;
                BlockPos curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder + 1, ladderPos.func_177952_p() + z);
                int normalizedX = x - xOffset;
                normalizedZ = z - zOffset;
                if ((Math.abs(normalizedX) != 2 || Math.abs(normalizedZ) >= 3) && (Math.abs(normalizedZ) != 2 || Math.abs(normalizedX) >= 3) || this.world.func_180495_p(curBlock).func_177230_c() == this.getOwnBuilding().getFenceBlock()) continue;
                this.setDelay(10);
                if (this.checkOrRequestItems(new ItemStack(this.getOwnBuilding().getFenceBlock()))) {
                    return true;
                }
                this.setBlockFromInventory(curBlock, this.getOwnBuilding().getFenceBlock());
                return true;
            }
        }
        for (x = -3 + xOffset; x <= 3 + xOffset; ++x) {
            for (z = -3 + zOffset; z <= 3 + zOffset; ++z) {
                if (x == 0 && 0 == z) continue;
                BlockPos curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder + 2, ladderPos.func_177952_p() + z);
                int normalizedX = x - xOffset;
                normalizedZ = z - zOffset;
                if (Math.abs(normalizedX) != 2 || Math.abs(normalizedZ) != 2 || this.world.func_180495_p(curBlock).func_177230_c() == Blocks.field_150478_aa) continue;
                this.setDelay(10);
                if (this.checkOrRequestItems(new ItemStack(Blocks.field_150478_aa))) {
                    return true;
                }
                this.setBlockFromInventory(curBlock, Blocks.field_150478_aa);
                return true;
            }
        }
        Level currentLevel = new Level(this.getOwnBuilding(), lastLadder);
        this.getOwnBuilding().addLevel(currentLevel);
        this.getOwnBuilding().setCurrentLevel(this.getOwnBuilding().getNumberOfLevels());
        this.getOwnBuilding().markDirty();
        return false;
    }

    private AIState doShaftBuilding() {
        if (this.walkToBuilding()) {
            return AIState.MINER_BUILDING_SHAFT;
        }
        if (this.buildNextBlockInShaft()) {
            return AIState.MINER_BUILDING_SHAFT;
        }
        this.getOwnBuilding().resetStartingLevelShaft();
        return AIState.START_WORKING;
    }

    private AIState doNodeMining() {
        Level currentLevel = this.getOwnBuilding().getCurrentLevel();
        if (currentLevel == null) {
            Log.logger.warn("Current Level not set, resetting...");
            this.getOwnBuilding().setCurrentLevel(this.getOwnBuilding().getNumberOfLevels() - 1);
            return this.doNodeMining();
        }
        this.mineAtLevel(currentLevel);
        return AIState.MINER_CHECK_MINESHAFT;
    }

    private void mineAtLevel(Level currentLevel) {
        BlockPos standingPosition;
        if (this.workingNode == null) {
            this.workingNode = this.findNodeOnLevel(currentLevel);
            return;
        }
        int foundDirection = 0;
        Node foundNode = null;
        List<Integer> directions = Arrays.asList(1, 2, 3, 4);
        for (Integer dir : directions) {
            Optional<Node> node = this.tryFindNodeInDirectionOfNode(currentLevel, this.workingNode, dir);
            if (!node.isPresent() || this.getNodeStatusForDirection(node.get(), this.invertDirection(dir)) != Node.NodeStatus.COMPLETED) continue;
            foundDirection = dir;
            foundNode = node.get();
            break;
        }
        if (foundNode == null || foundDirection <= 0) {
            this.workingNode = null;
            return;
        }
        int xOffSet = this.getXDistance(foundDirection) / 2;
        int zOffSet = this.getZDistance(foundDirection) / 2;
        xOffSet = xOffSet > 0 ? ++xOffSet : --xOffSet;
        zOffSet = zOffSet > 0 ? ++zOffSet : --zOffSet;
        this.currentStandingPosition = standingPosition = new BlockPos(this.workingNode.getX() + xOffSet, currentLevel.getDepth(), this.workingNode.getZ() + zOffSet);
        if (this.workingNode.getStatus() == Node.NodeStatus.IN_PROGRESS || this.workingNode.getStatus() == Node.NodeStatus.COMPLETED || !this.walkToBlock(standingPosition)) {
            this.mineNodeFromStand(this.workingNode, standingPosition, foundDirection);
        }
    }

    private boolean isOre(Block block) {
        return block instanceof BlockOre;
    }

    private boolean secureBlock(BlockPos curBlock, BlockPos safeStand) {
        if (!this.getBlock(curBlock).func_149688_o().func_76230_c() && this.getBlock(curBlock) != Blocks.field_150478_aa || this.isOre(this.getBlock(curBlock))) {
            if (!this.mineBlock(curBlock, safeStand)) {
                this.setDelay(1);
                return false;
            }
            if (this.checkOrRequestItems(new ItemStack(Blocks.field_150347_e))) {
                return false;
            }
            this.setBlockFromInventory(curBlock, Blocks.field_150347_e);
            return false;
        }
        return true;
    }

    private void mineNodeFromStand(Node mineNode, BlockPos standingPosition, int direction) {
        BlockPos newStandingPosition;
        if (((JobMiner)this.job).getSchematic() == null) {
            if (mineNode.getStyle() == Node.NodeType.CROSSROAD) {
                this.loadSchematic("classic/minerX4");
            }
            if (mineNode.getStyle() == Node.NodeType.BEND) {
                this.loadSchematic("classic/minerX2Right");
            }
            if (mineNode.getStyle() == Node.NodeType.TUNNEL) {
                this.loadSchematic("classic/minerX2Top");
            }
            if (((JobMiner)this.job).getSchematic() != null) {
                ((JobMiner)this.job).getSchematic().setPosition(new BlockPos(mineNode.getX(), this.getOwnBuilding().getCurrentLevel().getDepth() + 1, mineNode.getZ()));
                int rotateTimes = 2;
                if (direction == 3) {
                    rotateTimes = 3;
                } else if (direction == 2) {
                    rotateTimes = 0;
                } else if (direction == 4) {
                    rotateTimes = 1;
                }
                ((JobMiner)this.job).getSchematic().rotate(rotateTimes);
            }
        }
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                for (int y = 0; y <= 4; ++y) {
                    BlockPos curBlock = new BlockPos(mineNode.getX() + x, standingPosition.func_177956_o() + y, mineNode.getZ() + z);
                    if ((Math.abs(x) < 2 || Math.abs(z) < 2) && this.getBlock(curBlock) == Blocks.field_150350_a && y >= 1 && y <= 3 || this.secureBlock(curBlock, standingPosition)) continue;
                    return;
                }
            }
        }
        if (!this.mineSideOfNode(mineNode, direction, standingPosition)) {
            return;
        }
        if (mineNode.getStatus() == Node.NodeStatus.AVAILABLE) {
            mineNode.setStatus(Node.NodeStatus.IN_PROGRESS);
        }
        int xOffSet = this.getXDistance(direction) / 2;
        int zOffSet = this.getZDistance(direction) / 2;
        xOffSet = xOffSet > 0 ? --xOffSet : ++xOffSet;
        zOffSet = zOffSet > 0 ? --zOffSet : ++zOffSet;
        this.currentStandingPosition = newStandingPosition = new BlockPos(mineNode.getX() + xOffSet, standingPosition.func_177956_o(), mineNode.getZ() + zOffSet);
        if (mineNode.getStatus() != Node.NodeStatus.COMPLETED) {
            for (int y = 1; y <= 3; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos curBlock = new BlockPos(mineNode.getX() + x, standingPosition.func_177956_o() + y, mineNode.getZ() + z);
                        if (this.getBlock(curBlock) == Blocks.field_150478_aa || this.getBlock(curBlock) == this.getOwnBuilding().getFloorBlock() || this.getBlock(curBlock) == this.getOwnBuilding().getFenceBlock() || this.mineBlock(curBlock, newStandingPosition)) continue;
                        return;
                    }
                }
            }
        }
        List<Integer> directions = Arrays.asList(1, 2, 3, 4);
        for (Integer dir : directions) {
            BlockPos sideStandingPosition;
            this.currentStandingPosition = sideStandingPosition = new BlockPos(mineNode.getX() + this.getXDistance(dir) / 3, standingPosition.func_177956_o(), mineNode.getZ() + this.getZDistance(dir) / 3);
            if (this.mineSideOfNode(mineNode, dir, sideStandingPosition)) continue;
            return;
        }
        if (!this.buildNodeSupportStructure(mineNode, standingPosition)) {
            return;
        }
        if (mineNode.getStatus() == Node.NodeStatus.IN_PROGRESS) {
            mineNode.setStatus(Node.NodeStatus.COMPLETED);
        }
        this.workingNode = null;
    }

    private boolean buildNodeSupportStructure(Node mineNode, BlockPos standingPosition) {
        if (mineNode.getStyle() == Node.NodeType.CROSSROAD || mineNode.getStyle() == Node.NodeType.BEND || mineNode.getStyle() == Node.NodeType.TUNNEL) {
            return this.executeSchematicPlacement();
        }
        if (mineNode.getStyle() == Node.NodeType.LADDER_BACK) {
            return true;
        }
        Log.logger.info("None of the above: " + mineNode);
        return false;
    }

    private boolean requestBlock() {
        while (((JobMiner)this.job).getSchematic().findNextBlock()) {
            Block block = ((JobMiner)this.job).getSchematic().getBlock();
            if (((JobMiner)this.job).getSchematic().doesSchematicBlockEqualWorldBlock() || block == Blocks.field_150348_b || block == Blocks.field_150350_a || !this.checkOrRequestItems(new ItemStack(block))) continue;
            ((JobMiner)this.job).getSchematic().reset();
            return false;
        }
        ((JobMiner)this.job).getSchematic().reset();
        this.requestedBlock = true;
        this.buildStructure = false;
        return true;
    }

    private void loadSchematic(String name) {
        this.requestedBlock = false;
        this.buildStructure = false;
        try {
            ((JobMiner)this.job).setSchematic(new SchematicWrapper(this.world, name));
        }
        catch (IllegalStateException e) {
            Log.logger.warn(String.format("Schematic: (%s) does not exist - removing build request", name), (Throwable)e);
            ((JobMiner)this.job).setSchematic(null);
        }
    }

    private boolean executeSchematicPlacement() {
        if (!this.requestedBlock && !this.requestBlock()) {
            return false;
        }
        if (!this.buildStructure && !this.buildStructure()) {
            return false;
        }
        return this.buildDecoration();
    }

    private boolean buildDecoration() {
        if (((JobMiner)this.job).getSchematic().getBlock() == null || ((JobMiner)this.job).getSchematic().doesSchematicBlockEqualWorldBlock() || ((JobMiner)this.job).getSchematic().getBlock() != null && ((JobMiner)this.job).getSchematic().getBlock().func_149688_o().func_76220_a() || ((JobMiner)this.job).getSchematic().getBlock() == Blocks.field_150350_a) {
            return !this.findNextBlockNonSolid();
        }
        if (!this.worker.isWorkerAtSiteWithMove(((JobMiner)this.job).getSchematic().getPosition(), 3)) {
            return false;
        }
        Block block = ((JobMiner)this.job).getSchematic().getBlock();
        IBlockState metadata = ((JobMiner)this.job).getSchematic().getBlockState();
        BlockPos coordinates = ((JobMiner)this.job).getSchematic().getBlockPosition();
        int x = coordinates.func_177958_n();
        int y = coordinates.func_177956_o();
        int z = coordinates.func_177952_p();
        Block worldBlock = this.world.func_180495_p(coordinates).func_177230_c();
        if (block == null) {
            BlockPos local = ((JobMiner)this.job).getSchematic().getLocalPosition();
            Log.logger.error(String.format("Schematic has null block at %d, %d, %d - local(%d, %d, %d)", x, y, z, local.func_177958_n(), local.func_177956_o(), local.func_177952_p()));
            this.findNextBlockNonSolid();
            return false;
        }
        if (worldBlock instanceof AbstractBlockHut || worldBlock == Blocks.field_150357_h || block instanceof AbstractBlockHut) {
            this.findNextBlockNonSolid();
            return false;
        }
        Item item = Item.func_150898_a((Block)block);
        this.worker.func_70062_b(0, item != null ? new ItemStack(item, 1) : null);
        this.setBlockFromInventory(new BlockPos(x, y, z), block, metadata);
        if (this.findNextBlockNonSolid()) {
            this.worker.func_71038_i();
            return false;
        }
        ((JobMiner)this.job).setSchematic(null);
        return true;
    }

    private boolean buildStructure() {
        if (((JobMiner)this.job).getSchematic().getBlock() == null || ((JobMiner)this.job).getSchematic().doesSchematicBlockEqualWorldBlock() || !((JobMiner)this.job).getSchematic().getBlock().func_149688_o().func_76220_a() && ((JobMiner)this.job).getSchematic().getBlock() != Blocks.field_150350_a) {
            return !this.findNextBlockSolid();
        }
        if (!this.worker.isWorkerAtSiteWithMove(((JobMiner)this.job).getSchematic().getPosition(), 3)) {
            return false;
        }
        Block block = ((JobMiner)this.job).getSchematic().getBlock();
        IBlockState metadata = ((JobMiner)this.job).getSchematic().getBlockState();
        BlockPos coordinates = ((JobMiner)this.job).getSchematic().getBlockPosition();
        int x = coordinates.func_177958_n();
        int y = coordinates.func_177956_o();
        int z = coordinates.func_177952_p();
        Block worldBlock = this.world.func_180495_p(coordinates).func_177230_c();
        if (block == null) {
            BlockPos local = ((JobMiner)this.job).getSchematic().getLocalPosition();
            Log.logger.error(String.format("Schematic has null block at %d, %d, %d - local(%d, %d, %d)", x, y, z, local.func_177958_n(), local.func_177956_o(), local.func_177952_p()));
            this.findNextBlockSolid();
            return false;
        }
        if (worldBlock instanceof AbstractBlockHut || worldBlock == Blocks.field_150357_h || block instanceof AbstractBlockHut || ((JobMiner)this.job).getSchematic().getBlock() == Blocks.field_150348_b) {
            this.findNextBlockSolid();
            return false;
        }
        if (block != Blocks.field_150350_a) {
            Item item = Item.func_150898_a((Block)block);
            this.worker.func_70062_b(0, item != null ? new ItemStack(item, 1) : null);
            this.setBlockFromInventory(new BlockPos(x, y, z), block, metadata);
        }
        if (this.findNextBlockSolid()) {
            this.worker.func_71038_i();
            return false;
        }
        ((JobMiner)this.job).getSchematic().reset();
        this.buildStructure = true;
        return true;
    }

    private boolean findNextBlockNonSolid() {
        if (!((JobMiner)this.job).getSchematic().findNextBlockNonSolid()) {
            ((JobMiner)this.job).getSchematic().incrementBlock();
            ((JobMiner)this.job).getSchematic().reset();
            return false;
        }
        return true;
    }

    private boolean findNextBlockSolid() {
        if (!((JobMiner)this.job).getSchematic().findNextBlockSolid()) {
            ((JobMiner)this.job).getSchematic().incrementBlock();
            ((JobMiner)this.job).getSchematic().reset();
            this.buildStructure = true;
            return false;
        }
        return true;
    }

    private boolean mineSideOfNode(Node mineNode, int direction, BlockPos standingPosition) {
        if (this.getNodeStatusForDirection(mineNode, direction) == Node.NodeStatus.LADDER) {
            return true;
        }
        if (this.getNodeStatusForDirection(mineNode, direction) == Node.NodeStatus.AVAILABLE) {
            this.setNodeStatusForDirection(mineNode, direction, Node.NodeStatus.IN_PROGRESS);
        }
        int xoffset = this.getXDistance(direction) / 2;
        int zoffset = this.getZDistance(direction) / 2;
        int posx = 1;
        int negx = -1;
        int posz = 1;
        int negz = -1;
        if (xoffset > 0) {
            posx = xoffset;
            negx = 2;
        }
        if (xoffset < 0) {
            negx = xoffset;
            posx = -2;
        }
        if (zoffset > 0) {
            posz = zoffset;
            negz = 2;
        }
        if (zoffset < 0) {
            negz = zoffset;
            posz = -2;
        }
        for (int y = 1; y <= 3; ++y) {
            for (int x = negx; x <= posx; ++x) {
                for (int z = negz; z <= posz; ++z) {
                    BlockPos curBlock = new BlockPos(mineNode.getX() + x, standingPosition.func_177956_o() + y, mineNode.getZ() + z);
                    if (this.getBlock(curBlock) == Blocks.field_150478_aa || this.getBlock(curBlock) == this.getOwnBuilding().getFloorBlock() || this.getBlock(curBlock) == this.getOwnBuilding().getFenceBlock()) continue;
                    if (this.getNodeStatusForDirection(mineNode, direction) == Node.NodeStatus.WALL) {
                        this.secureBlock(curBlock, standingPosition);
                        continue;
                    }
                    if (this.mineBlock(curBlock, standingPosition)) continue;
                    return false;
                }
            }
        }
        if (this.getNodeStatusForDirection(mineNode, direction) == Node.NodeStatus.IN_PROGRESS) {
            this.setNodeStatusForDirection(mineNode, direction, Node.NodeStatus.COMPLETED);
        }
        return true;
    }

    private void setNodeStatusForDirection(Node node, int direction, Node.NodeStatus status) {
        if (direction == 1) {
            node.setDirectionPosX(status);
        } else if (direction == 2) {
            node.setDirectionNegX(status);
        } else if (direction == 3) {
            node.setDirectionPosZ(status);
        } else if (direction == 4) {
            node.setDirectionNegZ(status);
        }
    }

    private Node.NodeStatus getNodeStatusForDirection(Node node, int direction) {
        if (direction == 1) {
            return node.getDirectionPosX();
        }
        if (direction == 2) {
            return node.getDirectionNegX();
        }
        if (direction == 3) {
            return node.getDirectionPosZ();
        }
        if (direction == 4) {
            return node.getDirectionNegZ();
        }
        return Node.NodeStatus.LADDER;
    }

    private int invertDirection(int direction) {
        if (direction == 1) {
            return 2;
        }
        if (direction == 2) {
            return 1;
        }
        if (direction == 3) {
            return 4;
        }
        if (direction == 4) {
            return 3;
        }
        return 0;
    }

    private boolean isNodeInDirectionOfOtherNode(Node start, int direction, Node check) {
        return start.getX() + this.getXDistance(direction) == check.getX() && start.getZ() + this.getZDistance(direction) == check.getZ();
    }

    private int getXDistance(int direction) {
        if (direction == 1) {
            return 7;
        }
        if (direction == 2) {
            return -7;
        }
        return 0;
    }

    private int getZDistance(int direction) {
        if (direction == 3) {
            return 7;
        }
        if (direction == 4) {
            return -7;
        }
        return 0;
    }

    private Optional<Node> tryFindNodeInDirectionOfNode(Level curlevel, Node start, int direction) {
        Node finalCurrentNode = start;
        return curlevel.getNodes().parallelStream().filter(check -> this.isNodeInDirectionOfOtherNode(finalCurrentNode, direction, (Node)check)).findFirst();
    }

    private Node createNewNodeInDirectionFromNode(Node start, int direction) {
        int otherDirection;
        int x = start.getX() + this.getXDistance(direction);
        int z = start.getZ() + this.getZDistance(direction);
        Node node = new Node(x, z);
        node.setStyle(this.getRandomNodeType());
        if (node.getStyle() == Node.NodeType.TUNNEL) {
            otherDirection = Math.max(direction, this.invertDirection(direction)) == 2 ? 4 : 2;
            this.setNodeStatusForDirection(node, otherDirection, Node.NodeStatus.WALL);
            this.setNodeStatusForDirection(node, this.invertDirection(otherDirection), Node.NodeStatus.WALL);
        }
        if (node.getStyle() == Node.NodeType.BEND) {
            this.setNodeStatusForDirection(node, direction, Node.NodeStatus.WALL);
            int n = otherDirection = Math.max(direction, this.invertDirection(direction)) == 2 ? 4 : 2;
            if (Math.random() > 0.5) {
                otherDirection = this.invertDirection(otherDirection);
            }
            this.setNodeStatusForDirection(node, otherDirection, Node.NodeStatus.WALL);
        }
        return node;
    }

    private Node.NodeType getRandomNodeType() {
        int roll = new Random().nextInt(100);
        if (roll > 50) {
            return Node.NodeType.TUNNEL;
        }
        if (roll > 20) {
            return Node.NodeType.BEND;
        }
        return Node.NodeType.CROSSROAD;
    }

    private Node findNodeOnLevel(Level currentLevel) {
        Node currentNode = currentLevel.getLadderNode();
        LinkedList<Node> visited = new LinkedList<Node>();
        block0: while (currentNode != null) {
            if (visited.contains(currentNode)) {
                return null;
            }
            visited.add(currentNode);
            if (currentNode.getStatus() == Node.NodeStatus.AVAILABLE || currentNode.getStatus() == Node.NodeStatus.IN_PROGRESS) {
                return currentNode;
            }
            List<Integer> directions = Arrays.asList(1, 2, 3, 4);
            Collections.shuffle(directions);
            for (Integer dir : directions) {
                Node.NodeStatus status = this.getNodeStatusForDirection(currentNode, dir);
                if (status == Node.NodeStatus.AVAILABLE || status == Node.NodeStatus.IN_PROGRESS) {
                    return currentNode;
                }
                if (status != Node.NodeStatus.COMPLETED) continue;
                Optional<Node> first = this.tryFindNodeInDirectionOfNode(currentLevel, currentNode, dir);
                if (first.isPresent()) {
                    if (visited.contains(first.get()) || this.getNodeStatusForDirection(first.get(), this.invertDirection(dir)) == Node.NodeStatus.WALL) continue;
                    currentNode = first.get();
                    continue block0;
                }
                Node newnode = this.createNewNodeInDirectionFromNode(currentNode, dir);
                currentLevel.addNode(newnode);
                return newnode;
            }
        }
        return null;
    }

    private void setBlockFromInventory(BlockPos location, Block block) {
        this.worker.func_71038_i();
        this.setBlockFromInventory(location, block, block.func_176223_P());
    }

    private void setBlockFromInventory(BlockPos location, Block block, IBlockState metadata) {
        int slot = this.worker.findFirstSlotInInventoryWith(block);
        if (slot != -1) {
            this.getInventory().func_70298_a(slot, 1);
            this.world.func_180501_a(location, metadata, 3);
        }
    }

    private Block getBlock(BlockPos loc) {
        return this.world.func_180495_p(loc).func_177230_c();
    }

    private int getLastLadder(BlockPos pos) {
        if (this.world.func_180495_p(pos).func_177230_c().isLadder((IBlockAccess)this.world, pos, null)) {
            return this.getLastLadder(pos.func_177977_b());
        }
        return pos.func_177956_o() + 1;
    }

    private int getFirstLadder(BlockPos pos) {
        if (this.world.func_180495_p(pos).func_177230_c().isLadder((IBlockAccess)this.world, pos, null)) {
            return this.getFirstLadder(pos.func_177984_a());
        }
        return pos.func_177956_o() - 1;
    }
}

