/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.minimal;

import com.minecolonies.entity.EntityCitizen;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;

public class EntityAICitizenAvoidEntity
extends EntityAIBase {
    private EntityCitizen theEntity;
    private double farSpeed;
    private double nearSpeed;
    private Entity closestLivingEntity;
    private float distanceFromEntity;
    private Class targetEntityClass;

    public EntityAICitizenAvoidEntity(EntityCitizen entity, Class targetEntityClass, float distanceFromEntity, double farSpeed, double nearSpeed) {
        this.theEntity = entity;
        this.targetEntityClass = targetEntityClass;
        this.distanceFromEntity = distanceFromEntity;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        super.func_75248_a(1);
    }

    public boolean func_75250_a() {
        this.closestLivingEntity = this.getClosestToAvoid();
        return this.closestLivingEntity != null;
    }

    private Entity getClosestToAvoid() {
        if (this.targetEntityClass == EntityPlayer.class) {
            return this.theEntity.field_70170_p.func_72890_a((Entity)this.theEntity, (double)this.distanceFromEntity);
        }
        Optional<Entity> entityOptional = this.theEntity.field_70170_p.func_175674_a((Entity)this.theEntity, this.theEntity.func_174813_aQ().func_72314_b((double)this.distanceFromEntity, 3.0, (double)this.distanceFromEntity), target -> target.func_70089_S() && this.theEntity.func_70635_at().func_75522_a(target)).stream().filter(this.targetEntityClass::isInstance).findFirst();
        return entityOptional.isPresent() ? entityOptional.get() : null;
    }

    public boolean func_75253_b() {
        return !this.theEntity.getNavigator().func_75500_f();
    }

    public void func_75249_e() {
        this.performMoveAway();
    }

    private void performMoveAway() {
        this.theEntity.getNavigator().moveAwayFromEntityLiving(this.closestLivingEntity, (double)this.distanceFromEntity * 2.0, this.nearSpeed);
    }

    public void func_75251_c() {
        this.closestLivingEntity = null;
    }

    public void func_75246_d() {
        Entity newClosest = this.getClosestToAvoid();
        if (newClosest != null && newClosest != this.closestLivingEntity) {
            this.closestLivingEntity = newClosest;
            this.performMoveAway();
            return;
        }
        if (this.theEntity.func_70068_e(this.closestLivingEntity) < 49.0) {
            this.theEntity.getNavigator().func_75489_a(this.nearSpeed);
        } else {
            this.theEntity.getNavigator().func_75489_a(this.farSpeed);
        }
    }
}

