/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.util;

import com.minecolonies.entity.EntityCitizen;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ChatSpamFilter {
    protected static final int BASE_TIMEOUT = 600;
    protected static final int MAX_TIMEOUT = 12000;
    private static final int POWER_TIMEOUT = 2;
    private final EntityCitizen worker;
    private int speechDelay = 0;
    private String speechDelayString = "";
    private int speechRepeat = 0;

    public ChatSpamFilter(EntityCitizen worker) {
        this.worker = worker;
    }

    public void requestWithoutSpam(@NotNull String chat) {
        this.requestWithoutSpam(chat, 1);
    }

    public void requestWithoutSpam(@NotNull String chat, int ticks) {
        this.talkWithoutSpam("entity.miner.messageNeedBlockAndItem", ticks, chat);
    }

    public void talkWithoutSpam(String key, int ticks, String ... chat) {
        String curstring = key + Arrays.toString(chat);
        if (Objects.equals(this.speechDelayString, curstring)) {
            if (this.speechDelay > 0) {
                this.speechDelay -= ticks;
                return;
            }
            ++this.speechRepeat;
        } else {
            this.speechDelay = 0;
            this.speechRepeat = 0;
        }
        this.worker.sendLocalizedChat(key, chat);
        this.speechDelayString = key + Arrays.toString(chat);
        this.speechDelay = Math.min((int)(600.0 * Math.pow(2.0, this.speechRepeat)), 12000);
    }

    public void talkWithoutSpam(String key, String ... chat) {
        this.talkWithoutSpam(key, 1, chat);
    }
}

