/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.entity.ai.util;

import com.minecolonies.configuration.Configurations;
import com.minecolonies.util.BlockPosUtil;
import com.minecolonies.util.SchematicWrapper;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class Structure {
    private final Stage stage;
    private final SchematicWrapper schematic;
    private final World targetWorld;

    public Structure(World targetWorld, BlockPos buildingLocation, String schematicFileName, int rotation) throws StructureException {
        this(targetWorld, buildingLocation, schematicFileName, rotation, Stage.CLEAR, null);
    }

    public Structure(World targetWorld, BlockPos buildingLocation, String schematicFileName, int rotation, Stage stageProgress, BlockPos blockProgress) throws StructureException {
        this.schematic = Structure.loadSchematic(targetWorld, buildingLocation, schematicFileName, rotation, stageProgress, blockProgress);
        this.stage = stageProgress;
        this.targetWorld = targetWorld;
    }

    private static SchematicWrapper loadSchematic(World targetWorld, BlockPos buildingLocation, String schematicFileName, int rotation, Stage stageProgress, BlockPos blockProgress) throws StructureException {
        if (targetWorld == null || buildingLocation == null || schematicFileName == null) {
            throw new StructureException(String.format("Some parameters were null! (targetWorld: %s), (buildingLocation: %s), (schematicFileName: %s)", targetWorld, buildingLocation, schematicFileName));
        }
        SchematicWrapper tempSchematic = null;
        try {
            tempSchematic = new SchematicWrapper(targetWorld, schematicFileName);
        }
        catch (IllegalStateException e) {
            throw new StructureException("failed to load schematic file!", e);
        }
        tempSchematic.rotate(rotation);
        tempSchematic.setPosition(buildingLocation);
        if (blockProgress != null) {
            tempSchematic.setLocalPosition(blockProgress);
        }
        return tempSchematic;
    }

    public Stage getStage() {
        return this.stage;
    }

    public BlockPos getCurrentBlockPosition() {
        return this.schematic.getBlockPosition();
    }

    public SchematicBlock getCurrentBlock() {
        return new SchematicBlock(this.schematic.getBlock(), this.schematic.getBlockPosition(), this.schematic.getBlockState(), this.schematic.getItem(), BlockPosUtil.getBlock(this.targetWorld, this.schematic.getBlockPosition()), BlockPosUtil.getBlockState(this.targetWorld, this.schematic.getBlockPosition()));
    }

    public Result advanceBlock() {
        switch (this.stage) {
            case CLEAR: {
                return this.advanceBlocks(this.schematic::decrementBlock, schematicBlock -> schematicBlock.blockPosition.func_177958_n() <= 0 || this.targetWorld.func_175623_d(schematicBlock.blockPosition));
            }
            case BUILD: {
                return this.advanceBlocks(this.schematic::incrementBlock, schematicBlock -> false);
            }
            case DECORATE: {
                return this.advanceBlocks(this.schematic::incrementBlock, schematicBlock -> false);
            }
        }
        return Result.NEW_BLOCK;
    }

    private Result advanceBlocks(Supplier<Boolean> moveOneBlock, Function<SchematicBlock, Boolean> checkIfApplies) {
        for (int i = 0; i < Configurations.maxBlocksCheckedByBuilder; ++i) {
            if (!moveOneBlock.get().booleanValue()) {
                return Result.AT_END;
            }
            if (checkIfApplies.apply(this.getCurrentBlock()).booleanValue()) continue;
            return Result.NEW_BLOCK;
        }
        return Result.CONFIG_LIMIT;
    }

    private boolean checkBlocksEqual(SchematicBlock blocksToTest) {
        return blocksToTest.block == blocksToTest.worldBlock && Objects.equals(blocksToTest.metadata, blocksToTest.worldMetadata);
    }

    public int getWidth() {
        return this.schematic.getWidth();
    }

    public int getLength() {
        return this.schematic.getLength();
    }

    public static final class SchematicBlock {
        public final Block block;
        public final BlockPos blockPosition;
        public final IBlockState metadata;
        public final Item item;
        public final Block worldBlock;
        public final IBlockState worldMetadata;

        public SchematicBlock(Block block, BlockPos blockPosition, IBlockState metadata, Item item, Block worldBlock, IBlockState worldMetadata) {
            this.block = block;
            this.blockPosition = blockPosition;
            this.metadata = metadata;
            this.item = item;
            this.worldBlock = worldBlock;
            this.worldMetadata = worldMetadata;
        }
    }

    public static final class StructureException
    extends Exception {
        public StructureException(String message, Throwable cause) {
            super(message, cause);
        }

        public StructureException(String message) {
            super(message);
        }
    }

    public static enum Stage {
        CLEAR,
        BUILD,
        DECORATE,
        SPAWN,
        COMPLETE;

    }

    public static enum Result {
        NEW_BLOCK,
        AT_END,
        CONFIG_LIMIT;

    }
}

